/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl;

import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class Process {
    public static void printHelp() {
        System.out.println("XSLT CommandLine Processor. Version 1.0");
        System.out.println(" -Usage:");
        System.out.println("    -java com.sap.engine.lib.xsl.Process -xsl=stylesheet -xml=source -out=output");
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Process.printHelp();
            System.exit(0);
        } else {
            String xml = null;
            String xsl = null;
            String out = null;
            int i = 0;
            while (i < args.length) {
                if (args[i].startsWith("-xml=")) {
                    xml = args[i].substring("-xml=".length());
                } else if (args[i].startsWith("-xsl=")) {
                    xsl = args[i].substring("-xsl=".length());
                } else if (args[i].startsWith("-out=")) {
                    out = args[i].substring("-out=".length());
                } else {
                    System.out.println("Unsupported argument: " + args[i]);
                }
                ++i;
            }
            if (xml == null || xsl == null) {
                System.out.println("Error: you need to supply -xml and -xsl parameters");
                System.exit(0);
            }
            if (out == null) {
                out = xml + ".out";
                System.out.println("Warning: no -out parameter supplied. using default output to: " + out);
            }
            System.out.println("Processing transformation:");
            System.out.println("  -xml=" + xml);
            System.out.println("  -xsl=" + xsl);
            System.out.println("  -out=" + out);
            TransformerFactory.newInstance().newTransformer(new StreamSource(xsl)).transform(new StreamSource(xml), new StreamResult(out));
            System.out.println("Done.");
        }
    }
}

