/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.NestedSAXParseException;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class SAXToDocHandler
extends DefaultHandler
implements ContentHandler,
DTDHandler,
ErrorHandler,
DeclHandler,
LexicalHandler {
    private DocHandler docHandler;
    private CharArray[] ca = new CharArray[10];
    private NamespaceSupport namespaceSupport = new NamespaceSupport();
    private boolean isInCDATASection;

    public SAXToDocHandler() {
        this.initCA();
    }

    public SAXToDocHandler(DocHandler docHandler) {
        this.initCA();
        this.setDocHandler(docHandler);
    }

    public void setDocHandler(DocHandler docHandler) {
        this.docHandler = docHandler;
    }

    private void initCA() {
        int i = 0;
        while (i < this.ca.length) {
            this.ca[i] = new CharArray();
            ++i;
        }
    }

    public void startDocument() throws SAXException {
        try {
            this.docHandler.startDocument();
            this.namespaceSupport.reset();
            this.isInCDATASection = false;
        }
        catch (Exception e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.docHandler.endDocument();
        }
        catch (Exception e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.ca[0].set(qName);
            this.ca[1].set(localName);
            this.ca[2].set(uri);
            this.docHandler.startElementStart(this.ca[2], this.ca[1], this.ca[0]);
            int i = 0;
            while (i < atts.getLength()) {
                String attQName = atts.getQName(i);
                int a = attQName.indexOf(58);
                String pref = a == -1 ? "" : attQName.substring(0, a);
                this.ca[2].set(pref);
                this.ca[6].set(atts.getURI(i));
                this.docHandler.addAttribute(this.ca[6], this.ca[2], this.ca[3].set(atts.getLocalName(i)), this.ca[4].set(atts.getQName(i)), atts.getType(i), this.ca[5].set(atts.getValue(i)));
                ++i;
            }
            this.docHandler.startElementEnd(false);
        }
        catch (Exception e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.ca[0].set(qName);
            this.ca[1].set(localName);
            this.ca[2].set(uri);
            this.docHandler.endElement(this.ca[2], this.ca[1], this.ca[0], false);
        }
        catch (Exception e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.ca[0].set(ch);
            this.ca[1].set(this.ca[0], start, start + length);
            if (this.isInCDATASection) {
                this.docHandler.onCDSect(this.ca[1]);
            } else {
                this.docHandler.charData(this.ca[1], true);
            }
        }
        catch (Exception e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.characters(ch, start, length);
        }
        catch (Exception e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.ca[0].set(target);
            this.ca[1].set(data);
            this.docHandler.onPI(this.ca[0], this.ca[1]);
        }
        catch (Exception e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            this.namespaceSupport.pushContext();
            this.namespaceSupport.declarePrefix(prefix, uri);
            this.docHandler.startPrefixMapping(new CharArray(prefix), new CharArray(uri));
        }
        catch (Exception e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        try {
            this.namespaceSupport.popContext();
            this.docHandler.endPrefixMapping(new CharArray(prefix));
        }
        catch (Exception e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public void warning(SAXParseException exception) throws SAXException {
    }

    public void error(SAXParseException exception) throws SAXException {
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void elementDecl(String name, String model) throws SAXException {
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.ca[0].set(ch);
            this.ca[1].set(this.ca[0], start, start + length);
            this.docHandler.onComment(this.ca[1]);
        }
        catch (Exception e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        try {
            this.ca[0].set(name);
            this.ca[1].set(publicId);
            this.ca[2].set(systemId);
            this.docHandler.startDTD(this.ca[0], this.ca[1], this.ca[2]);
        }
        catch (Exception e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void endDTD() throws SAXException {
        try {
            this.docHandler.endDTD();
        }
        catch (Exception e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void startCDATA() throws SAXException {
        this.isInCDATASection = true;
    }

    public void endCDATA() throws SAXException {
        this.isInCDATASection = false;
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }
}

