/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import com.sap.engine.lib.xml.util.JarFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class FileClassLoader
extends ClassLoader {
    protected byte pattern;
    protected final byte EMPTY = 0;
    protected final byte JARS = 1;
    protected final byte DIRS = (byte)2;
    protected final byte MIXED = (byte)3;
    private final int BUFFER_SIZE = 8192;
    protected String name;
    protected String[] jars;
    protected JarFilter[] jarFilters;
    protected String[] dirs;
    protected File[] dirFiles;
    protected int findIndex;
    protected boolean isFindInJar;
    protected ProtectionDomain domain;
    protected Set inloadable = new HashSet();
    protected Set inloadableLocal = new HashSet();
    protected static Set inloadableContainer = new HashSet();
    protected static int hits;

    public FileClassLoader(ClassLoader parent, String name) {
        this(parent, name, null);
    }

    public FileClassLoader(ClassLoader parent, String name, ProtectionDomain domain) {
        super(parent);
        inloadableContainer.add(this.inloadableLocal);
        inloadableContainer.add(this.inloadable);
        this.setName(name);
        this.domain = domain;
        this.pattern = 0;
    }

    public FileClassLoader(ClassLoader parent, String name, String fileName, boolean isJar, ProtectionDomain domain) {
        super(parent);
        this.setName(name);
        this.domain = domain;
        if (isJar) {
            this.pattern = 1;
            this.jars = new String[1];
            this.jars[0] = fileName;
            this.jarFilters = new JarFilter[1];
            this.jarFilters[0] = null;
        } else {
            this.pattern = (byte)2;
            this.dirs = new String[1];
            this.dirs[0] = fileName;
            this.dirFiles = new File[1];
            this.dirFiles[0] = null;
        }
    }

    public FileClassLoader(ClassLoader parent, String name, String[] fileNames, boolean areJars, ProtectionDomain domain) {
        super(parent);
        this.setName(name);
        this.domain = domain;
        if (areJars) {
            this.pattern = 1;
            this.jars = fileNames;
            this.jarFilters = new JarFilter[this.jars.length];
            int i = 0;
            while (i < this.jarFilters.length) {
                this.jarFilters[i] = null;
                ++i;
            }
        } else {
            this.pattern = (byte)2;
            this.dirs = fileNames;
            this.dirFiles = new File[this.dirs.length];
            int i = 0;
            while (i < this.dirFiles.length) {
                this.dirFiles[i] = null;
                ++i;
            }
        }
    }

    public FileClassLoader(ClassLoader parent, String name, String[] jarNames, String[] dirNames, ProtectionDomain domain) {
        super(parent);
        this.setName(name);
        this.domain = domain;
        this.pattern = (byte)3;
        this.jars = jarNames;
        this.dirs = dirNames;
        this.jarFilters = new JarFilter[this.jars.length];
        int i = 0;
        while (i < this.jarFilters.length) {
            this.jarFilters[i] = null;
            ++i;
        }
        this.dirFiles = new File[this.dirs.length];
        int i2 = 0;
        while (i2 < this.dirFiles.length) {
            this.dirFiles[i2] = null;
            ++i2;
        }
    }

    public FileClassLoader(ClassLoader parent, String name, File[] dirFiles, ProtectionDomain domain) {
        super(parent);
        this.setName(name);
        this.domain = domain;
        this.dirFiles = dirFiles;
        this.pattern = (byte)2;
        this.dirs = new String[dirFiles.length];
        int i = 0;
        while (i < this.dirs.length) {
            this.dirs[i] = dirFiles[i].getAbsolutePath();
            ++i;
        }
    }

    public FileClassLoader(ClassLoader parent, String name, File[] files, boolean areJars, ProtectionDomain domain) {
        super(parent);
        if (!areJars) {
            this.setName(name);
            this.domain = domain;
            this.dirFiles = this.dirFiles;
            this.pattern = (byte)2;
            this.dirs = new String[files.length];
            int i = 0;
            while (i < this.dirs.length) {
                this.dirs[i] = files[i].getAbsolutePath();
                ++i;
            }
        } else {
            this.setName(name);
            this.domain = domain;
            this.dirFiles = this.dirFiles;
            this.pattern = 1;
            this.jars = new String[files.length];
            this.jarFilters = new JarFilter[this.jars.length];
            int i = 0;
            while (i < this.jarFilters.length) {
                this.jars[i] = files[i].getAbsolutePath();
                this.jarFilters[i] = null;
                ++i;
            }
        }
    }

    public URL getResource(String name) {
        boolean isFindInJarLocal;
        InputStream in;
        URL result;
        ClassLoader parent = this.getParent();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        if ((result = parent.getResource(name)) != null) {
            return result;
        }
        String string = this.name;
        synchronized (string) {
            in = this.getResourceAsStream(name);
            isFindInJarLocal = this.isFindInJar;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
            try {
                if (isFindInJarLocal) {
                    return new URL("jar:file:" + this.jars[this.findIndex] + "!/" + name);
                }
                return new URL("file:" + this.dirs[this.findIndex] + name);
            }
            catch (MalformedURLException murlException) {
                murlException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream in;
        Set set = this.inloadable;
        synchronized (set) {
            if (this.inloadable.contains(name)) {
                InputStream inputStream = null;
                return inputStream;
            }
        }
        ClassLoader parent = this.getParent();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        if ((in = parent.getResourceAsStream(name)) != null) {
            return in;
        }
        byte[] buffer = this.readResourceData(name, false);
        if (buffer != null) {
            return new ByteArrayInputStream(buffer);
        }
        return null;
    }

    public void addJar(String jar) {
        String string = this.name;
        synchronized (string) {
            if (jar == null) {
                return;
            }
            String[] jars = new String[]{jar};
            this.addJars(jars);
        }
    }

    public void addJars(String[] names) {
        String string = this.name;
        synchronized (string) {
            if (names == null) {
                return;
            }
            FileClassLoader.clearInloadableContainer();
            switch (this.pattern) {
                case 0: 
                case 2: {
                    this.pattern = (byte)(this.pattern + 1);
                    this.jars = names;
                    this.jarFilters = new JarFilter[this.jars.length];
                    int i = 0;
                    while (i < this.jarFilters.length) {
                        this.jarFilters[i] = null;
                        ++i;
                    }
                    break;
                }
                case 1: 
                case 3: {
                    String[] newJars = new String[this.jars.length + names.length];
                    System.arraycopy(this.jars, 0, newJars, 0, this.jars.length);
                    System.arraycopy(names, 0, newJars, this.jars.length, names.length);
                    this.jars = newJars;
                    JarFilter[] newJarFilters = new JarFilter[this.jars.length];
                    System.arraycopy(this.jarFilters, 0, newJarFilters, 0, this.jarFilters.length);
                    int i = this.jarFilters.length;
                    while (i < newJarFilters.length) {
                        newJarFilters[i] = null;
                        ++i;
                    }
                    this.jarFilters = newJarFilters;
                    break;
                }
            }
        }
    }

    public String[] getJars() {
        return this.jars;
    }

    public void addDir(String dir) {
        String string = this.name;
        synchronized (string) {
            if (dir == null) {
                return;
            }
            String[] dirs = new String[]{dir};
            this.addDirs(dirs);
        }
    }

    public void addDirs(String[] names) {
        String string = this.name;
        synchronized (string) {
            if (names == null) {
                return;
            }
            FileClassLoader.clearInloadableContainer();
            switch (this.pattern) {
                case 0: 
                case 1: {
                    this.pattern = (byte)(this.pattern + 2);
                    this.dirs = names;
                    this.dirFiles = new File[this.dirs.length];
                    int i = 0;
                    while (i < this.dirFiles.length) {
                        this.dirFiles[i] = null;
                        ++i;
                    }
                    break;
                }
                case 2: 
                case 3: {
                    String[] newDirs = new String[this.dirs.length + names.length];
                    System.arraycopy(this.dirs, 0, newDirs, 0, this.dirs.length);
                    System.arraycopy(names, 0, newDirs, this.dirs.length, names.length);
                    this.dirs = newDirs;
                    File[] newDirFiles = new File[this.dirs.length];
                    System.arraycopy(this.dirFiles, 0, newDirFiles, 0, this.dirFiles.length);
                    int i = this.dirFiles.length;
                    while (i < newDirFiles.length) {
                        newDirFiles[i] = null;
                        ++i;
                    }
                    this.dirFiles = newDirFiles;
                    break;
                }
            }
        }
    }

    public void addMixed(File[] files) {
        String string = this.name;
        synchronized (string) {
            if (files == null) {
                return;
            }
            Vector<String> jarsTmp = new Vector<String>();
            Vector<String> dirsTmp = new Vector<String>();
            int i = 0;
            while (i < files.length) {
                String token = files[i].getPath();
                if (token.endsWith(".jar") || token.endsWith(".zip")) {
                    jarsTmp.add(token);
                } else {
                    dirsTmp.add(token);
                }
                ++i;
            }
            String[] jarsTemp = new String[jarsTmp.size()];
            String[] dirsTemp = new String[dirsTmp.size()];
            int i2 = 0;
            while (i2 < jarsTmp.size()) {
                jarsTemp[i2] = (String)jarsTmp.elementAt(i2);
                ++i2;
            }
            int i3 = 0;
            while (i3 < dirsTmp.size()) {
                dirsTemp[i3] = (String)dirsTmp.elementAt(i3);
                ++i3;
            }
            this.addJars(jarsTemp);
            this.addDirs(dirsTemp);
        }
    }

    public static void clearInloadableContainer() {
        if (inloadableContainer != null) {
            Set set = inloadableContainer;
            synchronized (set) {
                if (inloadableContainer.size() > 0) {
                    int count = 0;
                    Iterator iterator = inloadableContainer.iterator();
                    while (iterator.hasNext()) {
                        Set currentSet = (Set)iterator.next();
                        count += currentSet.size();
                        Set set2 = currentSet;
                        synchronized (set2) {
                            currentSet.clear();
                        }
                    }
                }
            }
        }
    }

    public void updateJar(String jar, String newFile) throws IOException {
        String string = this.name;
        synchronized (string) {
            if (jar == null) {
                return;
            }
            FileClassLoader.clearInloadableContainer();
            int offset = -1;
            int i = 0;
            while (i < this.jars.length) {
                if (jar.equals(this.jars[i])) {
                    offset = i;
                }
                ++i;
            }
            if (offset == -1) {
                return;
            }
            File dest = new File(jar);
            File source = new File(newFile);
            if (dest.exists() && source.exists()) {
                RandomAccessFile destFile = new RandomAccessFile(dest, "rw");
                RandomAccessFile sourceFile = new RandomAccessFile(source, "r");
                destFile.seek(0L);
                sourceFile.seek(0L);
                byte[] buffer = new byte[16384];
                int read = sourceFile.read(buffer, 0, buffer.length);
                while (read > 0) {
                    destFile.write(buffer, 0, read);
                    read = sourceFile.read(buffer, 0, buffer.length);
                }
                destFile.setLength(sourceFile.length());
                destFile.close();
                sourceFile.close();
            }
            this.jarFilters[offset] = null;
        }
    }

    protected synchronized Class findClass(String name) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        byte[] buffer = this.readClassData(name);
        this.loadPackageForClass(name);
        c = this.defineClass(name, buffer, 0, buffer.length, this.getProtectionDomain());
        return c;
    }

    protected void loadPackageForClass(String className) {
        String pkgName;
        int index = className.lastIndexOf(46);
        if (index != -1 && this.getPackage(pkgName = className.substring(0, index)) == null) {
            if (this.isFindInJar) {
                Manifest manifest = this.jarFilters[this.findIndex].getManifest();
                this.definePackage(pkgName, manifest);
            } else {
                this.definePackage(pkgName, null, null, null, null, null, null, null);
            }
        }
    }

    protected Package definePackage(String pkgName, Manifest manifest) {
        if (manifest == null) {
            return this.definePackage(pkgName, null, null, null, null, null, null, null);
        }
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        Attributes attributes = manifest.getAttributes(pkgName.replace('.', '/'));
        if (attributes != null) {
            specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        return this.definePackage(pkgName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
    }

    protected byte[] readClassData(String name) throws ClassNotFoundException {
        Set set = this.inloadableLocal;
        synchronized (set) {
            if (this.inloadableLocal.contains(name)) {
                throw new ClassNotFoundException(name);
            }
        }
        if (this.isContainClass(name)) {
            String findName = name.replace('.', '/') + ".class";
            byte[] result = this.readResourceData(findName, true);
            if (result != null) {
                return result;
            }
            Set set2 = this.inloadableLocal;
            synchronized (set2) {
                this.inloadableLocal.add(name);
            }
        }
        throw new ClassNotFoundException(name);
    }

    protected byte[] readResourceData(String name, boolean filterFlag) {
        String string = this.name;
        synchronized (string) {
            switch (this.pattern) {
                case 0: {
                    byte[] byArray = null;
                    return byArray;
                }
                case 1: {
                    byte[] result;
                    int i = 0;
                    while (i < this.jarFilters.length) {
                        if ((!filterFlag || this.jarFilters[i] == null || this.jarFilters[i].accept(name)) && this.openJar(i)) {
                            result = this.readResourceFromJar(name, this.jarFilters[i].getJar());
                            this.closeJar(i);
                            if (result != null) {
                                this.isFindInJar = true;
                                this.findIndex = i;
                                byte[] byArray = result;
                                return byArray;
                            }
                        }
                        ++i;
                    }
                    result = null;
                    return result;
                }
                case 2: {
                    byte[] result;
                    int i = 0;
                    while (i < this.dirFiles.length) {
                        if (this.isExist(i)) {
                            result = this.readResourceFromDir(name, this.dirFiles[i]);
                            this.releaseDir(i);
                            if (result != null) {
                                this.isFindInJar = false;
                                this.findIndex = i;
                                byte[] byArray = result;
                                return byArray;
                            }
                        }
                        ++i;
                    }
                    result = null;
                    return result;
                }
                case 3: {
                    int i = 0;
                    while (i < this.jarFilters.length) {
                        if ((!filterFlag || this.jarFilters[i] == null || this.jarFilters[i].accept(name)) && this.openJar(i)) {
                            byte[] result = this.readResourceFromJar(name, this.jarFilters[i].getJar());
                            this.closeJar(i);
                            if (result != null) {
                                this.isFindInJar = true;
                                this.findIndex = i;
                                byte[] byArray = result;
                                return byArray;
                            }
                        }
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < this.dirFiles.length) {
                        if (this.isExist(i2)) {
                            byte[] result = this.readResourceFromDir(name, this.dirFiles[i2]);
                            this.releaseDir(i2);
                            if (result != null) {
                                this.isFindInJar = false;
                                this.findIndex = i2;
                                byte[] byArray = result;
                                return byArray;
                            }
                        }
                        ++i2;
                    }
                    byte[] byArray = null;
                    return byArray;
                }
            }
            byte[] byArray = null;
            return byArray;
        }
    }

    protected boolean isContainClass(String name) {
        return true;
    }

    protected ProtectionDomain getProtectionDomain() {
        return this.domain;
    }

    private byte[] readResourceFromJar(String name, JarFile jar) {
        JarEntry entry = jar.getJarEntry(name);
        if (entry == null) {
            return null;
        }
        byte[] byteBuffer = new byte[8192];
        ByteArrayOutputStream buffer = null;
        int offset = 0;
        try {
            InputStream in = jar.getInputStream(entry);
            int read = 0;
            while (read != -1 & offset < 8192) {
                read = in.read(byteBuffer, offset, 8192 - offset);
                if (read == -1) continue;
                offset += read;
            }
            while (read != -1) {
                if (buffer == null) {
                    buffer = new ByteArrayOutputStream(16384);
                }
                buffer.write(byteBuffer, 0, 8192);
                offset = 0;
                while (read != -1 & offset < 8192) {
                    read = in.read(byteBuffer, offset, 8192 - offset);
                    if (read == -1) continue;
                    offset += read;
                }
            }
            if (buffer != null) {
                buffer.write(byteBuffer, 0, offset);
            }
            in.close();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return null;
        }
        if (buffer != null) {
            try {
                byteBuffer = buffer.toByteArray();
                buffer.close();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        } else {
            byte[] tempBuffer = new byte[offset];
            System.arraycopy(byteBuffer, 0, tempBuffer, 0, offset);
            byteBuffer = tempBuffer;
        }
        return byteBuffer;
    }

    private byte[] readResourceFromDir(String name, File dir) {
        File f = new File(dir, name);
        if (f.exists()) {
            try {
                RandomAccessFile raf = new RandomAccessFile(f, "r");
                byte[] result = new byte[(int)raf.length()];
                raf.seek(0L);
                raf.read(result, 0, result.length);
                raf.close();
                return result;
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
        return null;
    }

    private boolean openJar(int i) {
        if (this.jarFilters[i] == null) {
            try {
                this.jarFilters[i] = new JarFilter(this.jars[i]);
            }
            catch (IOException ioException) {
                return false;
            }
        }
        try {
            this.jarFilters[i].open(this.jars[i]);
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return false;
        }
        return true;
    }

    private void closeJar(int i) {
        try {
            this.jarFilters[i].getJar().close();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        catch (NullPointerException npException) {
            npException.printStackTrace();
        }
    }

    private boolean isExist(int i) {
        if (this.dirFiles[i] == null) {
            this.dirFiles[i] = new File(this.dirs[i]);
        }
        return this.dirFiles[i].exists();
    }

    private void releaseDir(int i) {
        this.dirFiles[i] = null;
    }

    private void setName(String name) {
        this.name = name == null ? "NULL" : name;
    }

    public boolean filterCheck(String className) {
        Set set = this.inloadableLocal;
        synchronized (set) {
            if (this.inloadableLocal.contains(className)) {
                boolean bl = false;
                return bl;
            }
        }
        if (className.startsWith("[")) {
            return true;
        }
        String string = this.name;
        synchronized (string) {
            if (this.pattern == 1) {
                String findName = className.replace('.', '/') + ".class";
                int i = 0;
                while (i < this.jarFilters.length) {
                    block14: {
                        if (this.jarFilters[i] == null) {
                            try {
                                this.jarFilters[i] = new JarFilter(this.jars[i]);
                            }
                            catch (IOException ioException) {
                                break block14;
                            }
                        }
                        if (this.jarFilters[i].accept(findName)) {
                            boolean bl = true;
                            return bl;
                        }
                    }
                    ++i;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }
}

