/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import com.sap.engine.lib.xml.dom.DOMImplementationImpl;
import com.sap.engine.lib.xml.util.DOMToDocHandler;
import com.sap.engine.lib.xsl.xslt.output.DocHandlerSerializer;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMSerializer {
    private final Properties p = new Properties();
    private DocHandlerSerializer h = new DocHandlerSerializer();
    private DOMToDocHandler d = new DOMToDocHandler();

    public DOMSerializer() {
        this.p.setProperty("method", "xml");
        this.p.setProperty("version", "1.0");
        this.p.setProperty("encoding", "UTF-8");
        this.p.setProperty("omit-xml-declaration", "no");
        this.p.setProperty("standalone", "");
        this.p.setProperty("doctype-public", "");
        this.p.setProperty("doctype-system", "");
        this.p.setProperty("cdata-section-elements", "");
        this.p.setProperty("indent", "yes");
        this.p.setProperty("media-type", "");
        this.h.setOutputProperties(this.p);
    }

    public void write(Node node, Writer w) throws Exception {
        this.h.setCloseOnEnd(false);
        this.h.setWriter(w);
        this.serialize(node);
    }

    public void write(Document doc, OutputStream out) throws Exception {
        this.write((Node)doc, out);
    }

    public void write(Node node, OutputStream out) throws Exception {
        this.h.setCloseOnEnd(false);
        this.h.setOutputStream(out);
        this.serialize(node);
    }

    public void write(Node node, String systemId) throws Exception {
        this.h.setCloseOnEnd(true);
        this.h.setOutputStream(new FileOutputStream(systemId));
        this.serialize(node);
    }

    private void serialize(Node node) throws Exception {
        if (node.getNodeType() == 9) {
            this.d.process(node, this.h);
        } else {
            this.h.startDocument();
            this.d.process(node, this.h);
            this.h.endDocument();
        }
    }

    public void setOutputProperty(String name, String value) {
        this.p.setProperty(name, value);
        this.h.setOutputProperties(this.p);
    }

    public static void main(String[] args) throws Exception {
        DOMImplementationImpl di = new DOMImplementationImpl();
        Document d = di.createDocument(null, "", null);
        Element a = d.createElementNS("http://www.u.com", "u:a");
        Element b = d.createElementNS("http://www.v.com", "v:a");
        a.appendChild(b);
        DOMSerializer serializer = new DOMSerializer();
        serializer.write((Node)a, (OutputStream)System.out);
    }
}

