/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.verifier;

import com.sap.engine.lib.xml.signature.Configurator;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.elements.Reference;
import com.sap.engine.lib.xml.signature.elements.XMLSignature;
import com.sap.engine.lib.xml.signature.generator.SignatureGenerator;
import com.sap.engine.lib.xml.signature.transform.TransformationFactory;
import com.sap.engine.lib.xml.signature.transform.algorithms.Canonicalization;
import com.sap.engine.lib.xml.signature.transform.algorithms.ExclusiveCanonicalization;
import com.sap.engine.lib.xml.signature.transform.algorithms.XPathTransformation;
import com.sap.engine.lib.xml.signature.verifier.XMLVerifier;
import com.sap.engine.lib.xml.util.BASE64Decoder;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SignatureVerifier
implements XMLVerifier {
    public boolean exclusive = false;
    private static final String[] certTypes = new String[]{"X509"};
    private Certificate cert = null;
    private PublicKey publicKey = null;
    private XMLSignature signature = null;
    private Reference[] references = new Reference[0];
    private TransformationFactory trFact = TransformationFactory.newInstance();
    private String idNamespaceURI = null;
    private String idLocalName = "Id";
    private int statusCode = -1;

    public SignatureVerifier(Document doc) throws SignatureException {
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        this.signature = new XMLSignature((Element)nl.item(0), true);
        this.signature.initializeDescendants();
    }

    public SignatureVerifier(Element domSignature) throws SignatureException {
        this.signature = new XMLSignature(domSignature, true);
        this.signature.initializeDescendants();
    }

    public void setPublicKey(PublicKey publicKey) {
        SignatureException.traceKey("Public key for verification", publicKey);
        this.publicKey = publicKey;
    }

    public void setCertificate(Certificate cert) {
        SignatureException.traceCertificate("Certificate for verification", cert);
        this.cert = cert;
    }

    public void setIDAttribute(String localName, String uri) {
        this.idLocalName = localName;
        this.idNamespaceURI = uri;
    }

    public void setTransformationFactory(TransformationFactory trFact) {
        this.trFact = trFact;
    }

    public int getSignatureValidationResult() throws IllegalStateException {
        if (this.statusCode == -1) {
            throw new IllegalStateException("Must invoke verify() before getSignatureValidationResult().");
        }
        return this.statusCode;
    }

    public Reference[] getReferenceValidationResults() throws IllegalStateException {
        if (this.statusCode == -1) {
            throw new IllegalStateException("Must invoke verify() before getReferenceValidationResult().");
        }
        return this.references;
    }

    public void setAttribute(String name, Object value) throws SignatureException {
        throw new SignatureException("Incorrect attribute name or value:" + name, new Object[]{name, value});
    }

    public Object getAttribute(String name) {
        return null;
    }

    public boolean verify() throws SignatureException {
        boolean res = true;
        if (!this.validateSignatureValue()) {
            this.statusCode = 2;
            SignatureException.traceByte("SignatureIncorrect", "");
            res = false;
            if (!SignatureException.dumpFlag) {
                return res;
            }
        }
        if (!this.verifyReferences()) {
            this.statusCode = 3;
            SignatureException.traceByte("ReferenceIncorrect", "");
            res = false;
        }
        if (!res) {
            return false;
        }
        this.statusCode = 0;
        return true;
    }

    public boolean verifyReferences() throws SignatureException {
        boolean result = true;
        GenericElement signedInfo = this.signature.getDescendant("http://www.w3.org/2000/09/xmldsig#", "SignedInfo");
        Vector vectRef = signedInfo.getDirectChildren("http://www.w3.org/2000/09/xmldsig#", "Reference");
        this.references = new Reference[vectRef.size()];
        int i = 0;
        while (i < vectRef.size()) {
            Reference ref;
            this.references[i] = ref = (Reference)vectRef.get(i);
            ref.setTransformationFactory(this.trFact);
            ref.setIDAttribute(this.idLocalName, this.idNamespaceURI);
            try {
                if (!ref.validate()) {
                    this.statusCode = 3;
                    return false;
                }
            }
            catch (SignatureException e) {
                new SignatureException(e);
                this.statusCode = 3;
                return false;
            }
            ++i;
        }
        return result;
    }

    public boolean validateSignatureValue() throws SignatureException {
        Signature sig = null;
        try {
            try {
                byte[] canonInfo;
                boolean[] commExcl;
                GenericElement sInfo = this.signature.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "SignedInfo");
                GenericElement canonAlg = sInfo.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod");
                String canonAlgorithm = canonAlg.getAttribute("Algorithm", null, null);
                String sigAlgorithm = sInfo.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "SignatureMethod").getAttribute("Algorithm", null, null);
                try {
                    this.publicKey = this.getPublicKey();
                }
                catch (SignatureException e) {
                    this.statusCode = 1;
                    throw e;
                }
                catch (GeneralSecurityException e) {
                    this.statusCode = 1;
                    throw new SignatureException("No valid key info", new Object[]{this.signature}, e);
                }
                try {
                    commExcl = SignatureGenerator.detCommExcl(canonAlgorithm);
                }
                catch (SignatureException e) {
                    this.statusCode = 5;
                    throw e;
                }
                boolean retainComments = commExcl[0];
                boolean localExclusive = commExcl[1];
                if (localExclusive) {
                    GenericElement el = canonAlg.getDirectChild("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces");
                    String[] iN = null;
                    if (el != null) {
                        String prefixList = el.getAttribute("PrefixList", null, null);
                        StringTokenizer tokenizer = new StringTokenizer(prefixList);
                        iN = new String[tokenizer.countTokens()];
                        int i = 0;
                        while (i < iN.length) {
                            iN[i] = tokenizer.nextToken();
                            ++i;
                        }
                    }
                    canonInfo = ExclusiveCanonicalization.canonicalize(sInfo.getDomRepresentation(), retainComments, iN);
                } else {
                    Document owner = sInfo.getOwner();
                    Element dummyNode = owner.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:dummy");
                    this.signature.getDomRepresentation().appendChild(dummyNode);
                    String locator = "ancestor-or-self::ds:SignedInfo and count(ancestor::*/child::node()[name()='ds:dummy']) > 0";
                    canonInfo = Canonicalization.canonicalize(owner, true);
                    ByteArrayInputStream s = new ByteArrayInputStream(canonInfo);
                    canonInfo = XPathTransformation.filterSet(s, locator, SignatureGenerator.nsMappings, retainComments);
                    this.signature.getDomRepresentation().removeChild(dummyNode);
                }
                String sValue = this.signature.getSignatureValue();
                SignatureException.traceByteAsString("Canonicalized signature for verification", canonInfo);
                sig = SignatureContext.getCryptographicPool().getSignatureFromPool(sigAlgorithm);
                byte[] toCheck = BASE64Decoder.decode(sValue.getBytes());
                if (sigAlgorithm.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                    toCheck = SignatureVerifier.xmlSignatureToAsn1(toCheck);
                }
                sig.initVerify(this.publicKey);
                sig.update(canonInfo);
                boolean bl = sig.verify(toCheck);
                Object var16_22 = null;
                SignatureContext.getCryptographicPool().releaseSignature(sig);
                return bl;
            }
            catch (SignatureException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SignatureException("Unable to validate signature", new Object[]{this.signature}, e);
            }
        }
        catch (Throwable throwable) {
            Object var16_23 = null;
            SignatureContext.getCryptographicPool().releaseSignature(sig);
            throw throwable;
        }
    }

    public String getKeyName() throws SignatureException {
        GenericElement keyInfo = this.signature.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        GenericElement keyName = keyInfo.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "KeyName");
        return keyName == null ? null : keyName.getNodeValue();
    }

    public Certificate getCertificate() throws SignatureException, GeneralSecurityException {
        if (this.cert != null) {
            return this.cert;
        }
        String encCert = null;
        String certType = null;
        GenericElement keyInfo = this.signature.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        int i = 0;
        while (i < certTypes.length) {
            GenericElement certData = keyInfo.getDirectChild("http://www.w3.org/2000/09/xmldsig#", certTypes[i] + "Data");
            if (certData != null) {
                certType = certTypes[i];
                GenericElement certCertificate = certData.getDirectChild("http://www.w3.org/2000/09/xmldsig#", certTypes[i] + "Certificate");
                encCert = certCertificate.getNodeValue();
                break;
            }
            ++i;
        }
        if (encCert == null) {
            return null;
        }
        byte[] decCert = BASE64Decoder.decode(encCert.getBytes());
        CertificateFactory cFact = CertificateFactory.getInstance(certType);
        return cFact.generateCertificate(new ByteArrayInputStream(decCert));
    }

    public Certificate[] getCertificates() throws SignatureException, GeneralSecurityException {
        Vector<String> certs = new Vector<String>(10);
        Vector<String> types = new Vector<String>(10);
        GenericElement keyInfo = this.signature.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        int i = 0;
        while (i < certTypes.length) {
            GenericElement certData = keyInfo.getDirectChild("http://www.w3.org/2000/09/xmldsig#", certTypes[i] + "Data");
            if (certData != null) {
                Vector children = certData.getDirectChildren("http://www.w3.org/2000/09/xmldsig#", certTypes[i] + "Certificate");
                int j = 0;
                while (j < children.size()) {
                    certs.add(((GenericElement)children.get(j)).getNodeValue());
                    types.add(certTypes[i]);
                    ++j;
                }
            }
            ++i;
        }
        Certificate[] res = new Certificate[certs.size()];
        int i2 = 0;
        while (i2 < res.length) {
            byte[] decCert = BASE64Decoder.decode(((String)certs.get(i2)).getBytes());
            CertificateFactory cFact = CertificateFactory.getInstance((String)types.get(i2));
            res[i2] = cFact.generateCertificate(new ByteArrayInputStream(decCert));
            ++i2;
        }
        return res;
    }

    public PublicKey getPublicKey() throws SignatureException, GeneralSecurityException {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        GenericElement keyInfo = this.signature.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        GenericElement keyValue = null;
        if (keyInfo != null) {
            keyValue = keyInfo.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
        }
        if (keyValue == null) {
            Certificate localCert = this.getCertificate();
            if (localCert != null) {
                return localCert.getPublicKey();
            }
            throw new SignatureException("Can't constuct a public key without keyValue element and no certificate info.", new Object[]{this.signature});
        }
        GenericElement specValue = keyValue.getFirstChild();
        String specLocal = specValue.getLocalName();
        String specURI = specValue.getNamespaceURI();
        if (!specURI.equals("http://www.w3.org/2000/09/xmldsig#")) {
            throw new SignatureException("Can't create key - direct child of Key Value in wrong namespace: " + specURI + " and should be in " + "http://www.w3.org/2000/09/xmldsig#", new Object[]{this.signature});
        }
        if (specLocal.equals("DSAKeyValue")) {
            String pString = specValue.getDirectChildIgnoreCase("http://www.w3.org/2000/09/xmldsig#", "P").getNodeValue();
            String qString = specValue.getDirectChildIgnoreCase("http://www.w3.org/2000/09/xmldsig#", "Q").getNodeValue();
            String gString = specValue.getDirectChildIgnoreCase("http://www.w3.org/2000/09/xmldsig#", "G").getNodeValue();
            String yString = specValue.getDirectChildIgnoreCase("http://www.w3.org/2000/09/xmldsig#", "Y").getNodeValue();
            BigInteger p = new BigInteger(1, BASE64Decoder.decode(pString.getBytes()));
            BigInteger q = new BigInteger(1, BASE64Decoder.decode(qString.getBytes()));
            BigInteger g = new BigInteger(1, BASE64Decoder.decode(gString.getBytes()));
            BigInteger y = new BigInteger(1, BASE64Decoder.decode(yString.getBytes()));
            DSAPublicKeySpec spec = new DSAPublicKeySpec(y, p, q, g);
            KeyFactory fact = KeyFactory.getInstance("DSA", Configurator.getProviderName());
            return fact.generatePublic(spec);
        }
        if (specLocal.equals("RSAKeyValue")) {
            String _modulus = specValue.getDirectChildIgnoreCase("http://www.w3.org/2000/09/xmldsig#", "Modulus").getNodeValue();
            String _exponent = specValue.getDirectChildIgnoreCase("http://www.w3.org/2000/09/xmldsig#", "Exponent").getNodeValue();
            BigInteger modulus = new BigInteger(1, BASE64Decoder.decode(_modulus.getBytes()));
            BigInteger exponent = new BigInteger(1, BASE64Decoder.decode(_exponent.getBytes()));
            RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
            KeyFactory fact = KeyFactory.getInstance("RSA", Configurator.getProviderName());
            return fact.generatePublic(spec);
        }
        throw new SignatureException("Unknown signauture algorithm:" + specLocal, new Object[]{this.signature});
    }

    private static byte[] xmlSignatureToAsn1(byte[] signatureOctets) throws SignatureException {
        if (signatureOctets.length != 40) {
            throw new SignatureException("Invalid format for DSA. ", new Object[]{signatureOctets});
        }
        int i = 20;
        while (i > 0 && signatureOctets[20 - i] == 0) {
            --i;
        }
        int j = i;
        if (signatureOctets[20 - i] < 0) {
            ++j;
        }
        int k = 20;
        while (k > 0 && signatureOctets[40 - k] == 0) {
            --k;
        }
        int l = k;
        if (signatureOctets[40 - k] < 0) {
            ++l;
        }
        byte[] asn1Octets = new byte[6 + j + l];
        asn1Octets[0] = 48;
        asn1Octets[1] = (byte)(4 + j + l);
        asn1Octets[2] = 2;
        asn1Octets[3] = (byte)j;
        System.arraycopy(signatureOctets, 20 - i, asn1Octets, 4 + j - i, i);
        asn1Octets[4 + j] = 2;
        asn1Octets[5 + j] = (byte)l;
        System.arraycopy(signatureOctets, 40 - k, asn1Octets, 6 + j + l - k, k);
        return asn1Octets;
    }
}

