/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.transform.algorithms;

import com.sap.engine.lib.xml.parser.handlers.NamespaceHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.signature.transform.algorithms.Canonicalization;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.DTMDOMBuilder;
import com.sap.engine.lib.xsl.xpath.DTMFactory;
import com.sap.engine.lib.xsl.xpath.ETBuilder;
import com.sap.engine.lib.xsl.xpath.ETObject;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathProcessor;
import com.sap.engine.lib.xsl.xpath.xobjects.XBoolean;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xslt.NamespaceManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.w3c.dom.Node;

public class XPathTransformation
extends Transformation {
    private Hashtable mappings = new Hashtable();
    boolean exclusiveX = false;

    public XPathTransformation(Object[] args) {
        super(args);
    }

    public XPathTransformation() {
        this(null);
    }

    public void addPrefixMapping(String prefix, String $uri) {
        this.mappings.put(prefix, $uri);
    }

    public void setPrefixMappings(Hashtable newMappings) {
        this.mappings = newMappings;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusiveX = exclusive;
    }

    public boolean getExclusive() {
        return this.exclusiveX;
    }

    public void transform(Data data) throws SignatureException {
        if (this.additionalArgs.length != 2 || !(this.additionalArgs[0] instanceof String) || this.additionalArgs[1] != null && !(this.additionalArgs[1] instanceof Hashtable)) {
            throw new SignatureException("XPathTransformation expects a two-elemnent array, containing a xpath query and a hashtable of prefix mappings", new Object[]{data, this.additionalArgs});
        }
        String query = (String)this.additionalArgs[0];
        Hashtable bindings = null;
        bindings = this.additionalArgs[1] != null ? (Hashtable)this.additionalArgs[1] : this.mappings;
        ByteArrayInputStream is = new ByteArrayInputStream(data.getOctets());
        data.setOctets(XPathTransformation.filterSetSpecialToOctets(is, query, bindings, this.exclusiveX, null, true, true));
    }

    public static byte[] filterSet(InputStream input, String query, Hashtable prefixMappings, boolean retainComments) throws SignatureException {
        return XPathTransformation.filterSetSpecial(input, query, prefixMappings, false, null, retainComments);
    }

    public static byte[] filterSetSpecial(InputStream input, String query, Hashtable prefixMappings, boolean exclusive, String[] specialPrefixes, boolean retainComments) throws SignatureException {
        return XPathTransformation.filterSetSpecialToOctets(input, query, prefixMappings, exclusive, specialPrefixes, retainComments, !exclusive);
    }

    private static synchronized byte[] filterSetSpecialToOctets(InputStream input, String query, Hashtable prefixMappings, boolean exclusive, String[] specialPrefixes, boolean retainComments, boolean retainNamespaces) throws SignatureException {
        try {
            SignatureContext.excluded = 0;
            NamespaceHandler nh = new NamespaceHandler(null);
            Enumeration vars = prefixMappings.keys();
            while (vars.hasMoreElements()) {
                String nextVar = (String)vars.nextElement();
                String nextVal = (String)prefixMappings.get(nextVar);
                nh.add(new CharArray(nextVar), new CharArray(nextVal));
            }
            DTM dtm = SignatureContext.getDTM();
            DTMFactory factory = SignatureContext.getDTMFactory();
            NamespaceManager nm = SignatureContext.getNamespaceManager();
            factory.initializeDirty(dtm, nm, input);
            XPathContext ctx = dtm.getInitialContext();
            ctx.node = dtm.firstChild[0];
            XPathProcessor processor = new XPathProcessor(dtm);
            ETBuilder etBuilder = SignatureContext.getETBuilder();
            etBuilder.setNamespaceStuff(nm, nh);
            ETObject processed = etBuilder.process(query);
            ctx.dtm = dtm;
            int length = dtm.size;
            XObject obj = processor.process(processed, ctx);
            int[] tempList = null;
            if (obj instanceof XNodeSet && ((XNodeSet)obj).size() != 0) {
                XNodeSet nodeSet = (XNodeSet)obj;
                tempList = new int[length - nodeSet.count()];
                if (tempList.length == length) {
                    return new byte[0];
                }
                int index = 0;
                int tempIndex = 1;
                int i = 0;
                while (i < length) {
                    int k;
                    int n = k = tempIndex > nodeSet.count() ? length : nodeSet.getKth(tempIndex);
                    if (i < k) {
                        tempList[index++] = i;
                    } else if (i == k) {
                        ++tempIndex;
                    }
                    ++i;
                }
            } else {
                int i = dtm.firstChild[0];
                while (i < length) {
                    ctx.node = i;
                    XObject res = processor.process(processed, ctx);
                    if (!((XBoolean)(res = res.toXBoolean())).getValue()) {
                        if (SignatureContext.excluded == SignatureContext.excludeList.length) {
                            int[] excludeListTemp = new int[SignatureContext.excluded + 16];
                            System.arraycopy(SignatureContext.excludeList, 0, excludeListTemp, 0, SignatureContext.excluded);
                            SignatureContext.excludeList = excludeListTemp;
                        }
                        SignatureContext.excludeList[SignatureContext.excluded++] = i;
                    }
                    ++i;
                }
                tempList = new int[SignatureContext.excluded];
                System.arraycopy(SignatureContext.excludeList, 0, tempList, 0, SignatureContext.excluded);
            }
            DTMDOMBuilder domBuilder = new DTMDOMBuilder(dtm);
            domBuilder.reinitializeDOM(tempList, retainNamespaces, specialPrefixes, exclusive);
            Node n = domBuilder.getFragment();
            StringBuffer leadingText = dtm.getLeadingText();
            byte[] octets2 = Canonicalization.canonicalize(n, retainComments);
            return XPathTransformation.appendDataOctets(leadingText.toString().getBytes(), octets2);
        }
        catch (SignatureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SignatureException("Error in XPathTransformation", new Object[]{input, query, prefixMappings}, e);
        }
    }

    public static byte[] appendDataOctets(byte[] octets1, byte[] octets2) {
        if (octets1 == null || octets1.length == 0) {
            return octets2;
        }
        if (octets2 == null || octets2.length == 0) {
            return octets1;
        }
        int length1 = octets1.length;
        int length2 = octets2.length;
        int length3 = length1 + length2;
        byte[] octets3 = new byte[length3];
        System.arraycopy(octets1, 0, octets3, 0, length1);
        System.arraycopy(octets2, 0, octets3, length1, length2);
        return octets3;
    }

    public Transformation defineFrom(GenericElement el, HashMap $dataHashmap) throws SignatureException {
        throw new SignatureException("defineFrom not implemented for standard transformation: XPathTransformation!", new Object[]{el, $dataHashmap});
    }
}

