/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.transform.algorithms;

import com.sap.engine.lib.jaxp.DocHandlerResult;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xsl.xslt.output.ExclusiveCanonicalDocHandlerSerializer;
import com.sap.engine.lib.xsl.xslt.output.OutputException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Node;

public class ExclusiveCanonicalization
extends Transformation {
    private boolean commented = false;

    public ExclusiveCanonicalization(Object[] args, boolean commented) {
        super(args);
        this.commented = commented;
    }

    public ExclusiveCanonicalization(boolean commented) {
        this(null, commented);
    }

    public void transform(Data data) throws SignatureException {
        if (this.additionalArgs != null && this.additionalArgs.length > 1) {
            throw new SignatureException("ExclusiveCanonicalization expects at most one argument - InclusiveNamespaces.", new Object[]{data, this.additionalArgs});
        }
        String[] inclusiveNamespaces = null;
        if (this.additionalArgs != null && this.additionalArgs.length == 1 && this.additionalArgs[0] instanceof String[]) {
            inclusiveNamespaces = (String[])this.additionalArgs[0];
        }
        data.setOctets(ExclusiveCanonicalization.canonicalize(data.getOctets(), this.commented, inclusiveNamespaces));
    }

    public static byte[] canonicalize(byte[] input, boolean retainComments, String[] inclusiveNamespaces) throws SignatureException {
        ByteArrayInputStream bais = new ByteArrayInputStream(input);
        return ExclusiveCanonicalization.canonicalize(bais, retainComments, inclusiveNamespaces);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] canonicalize(InputStream input, boolean retainComments, String[] inclusiveNamespaces) throws SignatureException {
        byte[] byArray;
        ExclusiveCanonicalDocHandlerSerializer cdhs = null;
        try {
            try {
                ByteArrayOutputStream baos = SignatureContext.getByteArrayOutputStreamPool().getInstance();
                if (inclusiveNamespaces != null) {
                    Arrays.sort(inclusiveNamespaces);
                }
                cdhs = ExclusiveCanonicalization.get(baos, SignatureContext.getProperties(), inclusiveNamespaces);
                cdhs.retainComments(retainComments);
                XMLParser parser = new XMLParser();
                parser.setEntityResolver(SignatureContext.getEntityResolver());
                parser.parse(input, (DocHandler)cdhs);
                byArray = baos.toByteArray();
                Object var8_8 = null;
            }
            catch (Exception e) {
                throw new SignatureException("Exception while canonicalization", new Object[]{input}, e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ExclusiveCanonicalization.release(cdhs);
            throw throwable;
        }
        ExclusiveCanonicalization.release(cdhs);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] canonicalize(Node n, boolean retainComments, String[] inclusiveNamespaces) throws SignatureException {
        byte[] byArray;
        ExclusiveCanonicalDocHandlerSerializer cdhs = null;
        try {
            try {
                ByteArrayOutputStream baos = SignatureContext.getByteArrayOutputStreamPool().getInstance();
                if (inclusiveNamespaces != null) {
                    Arrays.sort(inclusiveNamespaces);
                }
                Hashtable namespacesInScope = DOM.getNamespaceMappingsInScope(n);
                cdhs = ExclusiveCanonicalization.get(baos, SignatureContext.getProperties(), inclusiveNamespaces, namespacesInScope);
                cdhs.retainComments(retainComments);
                DOMSource source = new DOMSource(n);
                DocHandlerResult result = new DocHandlerResult(cdhs);
                SignatureContext.getTransformer().transform(source, result);
                byArray = baos.toByteArray();
                Object var10_10 = null;
            }
            catch (Exception e) {
                throw new SignatureException("Exception while canonicalizing " + n.toString(), new Object[]{n}, e);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            ExclusiveCanonicalization.release(cdhs);
            throw throwable;
        }
        ExclusiveCanonicalization.release(cdhs);
        return byArray;
    }

    private static ExclusiveCanonicalDocHandlerSerializer get(ByteArrayOutputStream baos, Properties properties, String[] inclusiveNamespaces, Hashtable namespacesInScope) throws OutputException {
        return SignatureContext.getExclusiveCanonicalizationPool().get(baos, properties, inclusiveNamespaces, namespacesInScope);
    }

    public Transformation defineFrom(GenericElement el, HashMap $dataHashmap) throws SignatureException {
        throw new SignatureException("defineFrom not implemented for standard transformation: ExclusiveCanonicailization!", new Object[]{el, $dataHashmap});
    }

    private static void release(ExclusiveCanonicalDocHandlerSerializer cdhs) {
        SignatureContext.getExclusiveCanonicalizationPool().release(cdhs);
    }

    private static ExclusiveCanonicalDocHandlerSerializer get(ByteArrayOutputStream baos, Properties properties, String[] inclusiveNamespaces) throws OutputException {
        return SignatureContext.getExclusiveCanonicalizationPool().get(baos, properties, inclusiveNamespaces, null);
    }
}

