/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.transform.algorithms;

import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.encryption.EncryptedData;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DecryptTransformation
extends Transformation {
    public DecryptTransformation(Object[] args) {
        super(args);
    }

    public void transform(Data data) throws SignatureException {
        Node n = data.getNode();
        Element el = n instanceof Document ? ((Document)n).getDocumentElement() : (Element)n;
        boolean getNodeList = true;
        while (getNodeList) {
            NodeList list = el.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
            getNodeList = false;
            try {
                int i = 0;
                while (i < list.getLength()) {
                    EncryptedData encData = new EncryptedData((Element)list.item(i), true);
                    if (!this.skipDecryption(encData)) {
                        encData.initializeDescendants();
                        encData.replaceContent();
                        getNodeList = true;
                    }
                    ++i;
                }
                data.setNode(n);
            }
            catch (SignatureException ex1) {
                throw ex1;
            }
            catch (Exception ex) {
                throw new SignatureException(ex);
            }
        }
    }

    public Transformation defineFrom(GenericElement el, HashMap $dataHashmap) throws SignatureException {
        throw new SignatureException("defineFrom not implemented for standard transformation: XSLTTransformation!", new Object[]{el, $dataHashmap});
    }

    protected boolean skipDecryption(EncryptedData data) throws Exception {
        String elementUri;
        Element domRepr = (Element)data.getDomRepresentation();
        if (this.additionalArgs != null && (elementUri = domRepr.getAttribute("Id")) != null && elementUri.length() > 0) {
            elementUri = "#".concat(elementUri);
            int j = 0;
            while (j < this.additionalArgs.length) {
                if (elementUri.equals(this.additionalArgs[j])) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }
}

