/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.generator;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.signature.Configurator;
import com.sap.engine.lib.xml.signature.Constants;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.elements.KeyInfo;
import com.sap.engine.lib.xml.signature.elements.Object;
import com.sap.engine.lib.xml.signature.elements.Reference;
import com.sap.engine.lib.xml.signature.elements.SignedInfo;
import com.sap.engine.lib.xml.signature.elements.XMLSignature;
import com.sap.engine.lib.xml.signature.generator.XMLSigner;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.signature.transform.TransformationFactory;
import com.sap.engine.lib.xml.signature.transform.algorithms.Canonicalization;
import com.sap.engine.lib.xml.signature.transform.algorithms.ExclusiveCanonicalization;
import com.sap.engine.lib.xml.signature.transform.algorithms.XPathTransformation;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureGenerator
implements XMLSigner {
    private boolean showKeyValue = true;
    private String keyName = null;
    private Certificate[] certs = null;
    private PublicKey publicKey = null;
    private PrivateKey privateKey = null;
    private String cAlgorithmURI = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private String signatureAlgorithmURI = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private String idNamespaceURI = null;
    private String idLocalName = "Id";
    public boolean skipConsistencyCheck = false;
    public boolean showKeyInfo = true;
    public static String defaultSignatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private Node parent = null;
    private Vector references = new Vector();
    private Vector objects = new Vector();
    private Vector objectIDs = new Vector();
    private OutputStream out;
    private String digestAlgorithmURI;
    protected XMLSignature signature = null;
    protected SignedInfo sInfo = null;
    protected GenericElement sValue;
    protected boolean skipPrefixList = true;
    private boolean generateSignature = true;
    public static Hashtable nsMappings = new Hashtable();

    public void addReference(String uri, Transformation[] transforms, String digestMethod) throws SignatureException {
        this.addReference(null, uri, transforms, digestMethod, null, null);
    }

    public void addReference(String uri, Transformation[] transforms, String digestMethod, String proxyHost, String proxyPort) throws SignatureException {
        this.addReference(null, uri, transforms, digestMethod, proxyHost, proxyPort);
    }

    public void addReference(String canonicalizationURI, String uri, Transformation[] transforms, String digestMethod) throws SignatureException {
        this.addReference(canonicalizationURI, uri, transforms, digestMethod, null, null);
    }

    public void addReference(String canonicalizationURI, String uri, Transformation[] transforms, String digestMethod, String proxyHost, String proxyPort) throws SignatureException {
        if (uri == null) {
            uri = "";
        }
        if (!this.skipConsistencyCheck) {
            this.checkConsistency(canonicalizationURI, uri, transforms, digestMethod);
        }
        Reference ref = new Reference();
        ref.setURI(uri);
        ref.setTransforms(transforms);
        ref.setDigestURI(digestMethod);
        ref.setProxy(proxyHost, proxyPort);
        this.references.add(ref);
    }

    public void addObject(Node object) {
        this.objects.add(object);
        this.objectIDs.add(null);
    }

    public void addObject(Node object, String id) {
        this.objects.add(object);
        this.objectIDs.add(id);
    }

    public void setIDAttribute(String localName, String uri) {
        this.idLocalName = localName;
        this.idNamespaceURI = uri;
    }

    public void setSignatureAlgorithmURI(String signatureAlgorithmURI) {
        this.signatureAlgorithmURI = signatureAlgorithmURI;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        SignatureException.traceKey("Private key for signing", privateKey);
        this.privateKey = privateKey;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public void setPublicKey(PublicKey publicKey) {
        SignatureException.traceKey("Public key for signing", publicKey);
        this.publicKey = publicKey;
    }

    public void setCertificate(Certificate cert) {
        SignatureException.traceCertificate("Setting certificate", cert);
        this.certs = new Certificate[]{cert};
    }

    public void setCertificates(Certificate[] certs) {
        SignatureException.traceCertificateArray("Setting certificate ", certs);
        this.certs = certs;
    }

    public void setOutputStream(OutputStream $out) {
        this.out = $out;
    }

    public void setDigestAlgorithm(String digestAlgorithmURI) {
        this.digestAlgorithmURI = digestAlgorithmURI;
    }

    public void setCanonicalizationAlgorithm(String cAlgorithmURI) {
        this.cAlgorithmURI = cAlgorithmURI;
    }

    public void showKeyValue(boolean $showKeyValue) {
        this.showKeyValue = $showKeyValue;
    }

    public static void signDocument(Element parent) throws SignatureException {
        SignatureGenerator.signDocument(parent, null, null, null);
    }

    public static void signDocument(Element parent, PrivateKey privateKey, Certificate cert) throws SignatureException {
        SignatureGenerator.signDocument(parent, privateKey, null, cert);
    }

    public static void signDocument(Element parent, PrivateKey privateKey, PublicKey publicKey) throws SignatureException {
        SignatureGenerator.signDocument(parent, privateKey, publicKey, null);
    }

    public static void signDocument(Element parent, PrivateKey privateKey, PublicKey publicKey, Certificate cert) throws SignatureException {
        if (publicKey == null && privateKey == null) {
            KeyPairGenerator gen;
            block6: {
                try {
                    if (defaultSignatureAlgorithm.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                        gen = KeyPairGenerator.getInstance("DSA", Configurator.getProviderName());
                        break block6;
                    }
                    if (defaultSignatureAlgorithm.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                        gen = KeyPairGenerator.getInstance("RSA", Configurator.getProviderName());
                        break block6;
                    }
                    throw new SignatureException("Unrecognized default signature algorithm: " + defaultSignatureAlgorithm, new java.lang.Object[]{parent, privateKey, publicKey, cert});
                }
                catch (SignatureException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SignatureException("Error signing document", new java.lang.Object[]{parent, privateKey, publicKey, cert}, e);
                }
            }
            KeyPair pair = gen.genKeyPair();
            privateKey = pair.getPrivate();
            publicKey = pair.getPublic();
        }
        SignatureGenerator generator = new SignatureGenerator();
        Transformation tr1 = TransformationFactory.newInstance().getInstance("http://www.w3.org/2000/09/xmldsig#enveloped-signature", new Object[0]);
        generator.setPrivateKey(privateKey);
        generator.setCertificate(cert);
        generator.setPublicKey(publicKey);
        generator.addReference("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "", new Transformation[]{tr1}, "http://www.w3.org/2000/09/xmldsig#sha1");
        generator.generate(parent);
    }

    public Node generateHere(Element dummy) throws SignatureException {
        Node localParent = dummy.getParentNode();
        if (localParent == null) {
            throw new SignatureException("Parent element is null!", new java.lang.Object[]{dummy});
        }
        this.parent = localParent;
        this.signature = new XMLSignature(localParent, dummy, true);
        this.generate(this.signature);
        return this.signature.getDomRepresentation();
    }

    public Node generate(Element $parent) throws SignatureException {
        if ($parent == null) {
            throw new SignatureException("Parent element is null!", new java.lang.Object[]{$parent});
        }
        this.parent = $parent;
        this.signature = new XMLSignature($parent);
        this.generate(this.signature);
        return this.signature.getDomRepresentation();
    }

    public Node generateBefore(Element sibling) throws SignatureException {
        Node localParent = sibling.getParentNode();
        if (localParent == null) {
            throw new SignatureException("Parent element is null!", new java.lang.Object[]{sibling});
        }
        this.parent = localParent;
        this.signature = new XMLSignature(localParent, sibling, false);
        this.generate(this.signature);
        return this.signature.getDomRepresentation();
    }

    private void generate(XMLSignature sig) throws SignatureException {
        try {
            this.appendObjects(sig);
            this.sInfo = new SignedInfo("http://www.w3.org/2000/09/xmldsig#", Constants.STANDARD_PREFIX + "SignedInfo", sig);
            this.sValue = new GenericElement("http://www.w3.org/2000/09/xmldsig#", Constants.STANDARD_PREFIX + "SignatureValue", sig);
            GenericElement canonURI = new GenericElement("http://www.w3.org/2000/09/xmldsig#", Constants.STANDARD_PREFIX + "CanonicalizationMethod", this.sInfo);
            GenericElement algURI = new GenericElement("http://www.w3.org/2000/09/xmldsig#", Constants.STANDARD_PREFIX + "SignatureMethod", this.sInfo);
            canonURI.setAttribute("Algorithm", this.cAlgorithmURI);
            if (!this.skipPrefixList && this.cAlgorithmURI.startsWith("http://www.w3.org/2001/10/xml-exc-c14n#")) {
                GenericElement inclusiveNamespaces = new GenericElement("http://www.w3.org/2001/10/xml-exc-c14n#", "c14:InclusiveNamespaces", canonURI);
                inclusiveNamespaces.setAttribute("PrefixList", "c14");
            }
            algURI.setAttribute("Algorithm", this.signatureAlgorithmURI);
            int i = 0;
            while (i < this.references.size()) {
                Reference ref = (Reference)this.references.get(i);
                ref.setEnvelopingElement(this.parent);
                ref.setIDAttribute(this.idLocalName, this.idNamespaceURI);
                ref.setSkipPrefixList(this.skipPrefixList);
                ref.digest(this.sInfo);
                ++i;
            }
            if (this.generateSignature) {
                this.sValue.appendTextChild(new String(this.sign(this.sInfo, this.privateKey)));
            }
            if (this.showKeyInfo) {
                KeyInfo kInfo = new KeyInfo("http://www.w3.org/2000/09/xmldsig#", Constants.STANDARD_PREFIX + "KeyInfo", sig);
                kInfo.setPrivateKey(this.privateKey);
                kInfo.setPublicKey(this.publicKey);
                if (this.keyName != null) {
                    kInfo.setKeyName(this.keyName);
                    kInfo.addKeyName();
                }
                if (this.certs != null) {
                    kInfo.setCertificates(this.certs);
                    kInfo.addCertificateInfo();
                }
                if (this.showKeyValue && (this.publicKey != null || this.certs != null && this.certs.length > 0)) {
                    kInfo.addKeyValue(this.privateKey.getAlgorithm());
                }
            }
        }
        catch (SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureException("Generating signature exception", new java.lang.Object[]{sig}, e);
        }
    }

    private byte[] sign(SignedInfo sInfo, PrivateKey $privateKey) throws NoSuchAlgorithmException, SignatureException {
        byte[] canonInfo;
        boolean[] commExcl = SignatureGenerator.detCommExcl(this.cAlgorithmURI);
        boolean retainComments = commExcl[0];
        boolean exclusive = commExcl[1];
        if (exclusive) {
            canonInfo = ExclusiveCanonicalization.canonicalize(sInfo.getDomRepresentation(), retainComments, null);
        } else {
            String newSignatureLocator = "ancestor-or-self::ds:SignedInfo and count(ancestor::*/child::node()[name()='ds:SignatureValue'][string()!='']) = 0";
            ByteArrayInputStream is = new ByteArrayInputStream(Canonicalization.canonicalize(sInfo.getOwner(), true));
            canonInfo = XPathTransformation.filterSet(is, newSignatureLocator, nsMappings, retainComments);
        }
        SignatureException.traceByteAsString("Canonicalized signature", canonInfo);
        Signature sig = null;
        try {
            try {
                sig = SignatureContext.getCryptographicPool().getSignatureFromPool(this.signatureAlgorithmURI);
                sig.initSign($privateKey);
                sig.update(canonInfo);
                byte[] xmlSpecific = this.signatureAlgorithmURI.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1") ? SignatureGenerator.Asn1toXMLsignture(sig.sign()) : sig.sign();
                SignatureException.traceByte("Signature result", xmlSpecific);
                byte[] byArray = BASE64Encoder.encode(xmlSpecific);
                java.lang.Object var12_11 = null;
                SignatureContext.getCryptographicPool().releaseSignature(sig);
                return byArray;
            }
            catch (SignatureException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SignatureException("Error while signing", new java.lang.Object[]{sInfo, $privateKey}, e);
            }
        }
        catch (Throwable throwable) {
            java.lang.Object var12_12 = null;
            SignatureContext.getCryptographicPool().releaseSignature(sig);
            throw throwable;
        }
    }

    private void appendObjects(XMLSignature sig) throws SignatureException {
        int i = 0;
        while (i < this.objects.size()) {
            Object o = new Object(sig);
            o.getDomRepresentation().appendChild(((Node)this.objects.get(i)).cloneNode(true));
            String id = (String)this.objectIDs.get(i);
            if (id != null) {
                if (this.idNamespaceURI == null) {
                    ((Element)o.getDomRepresentation()).setAttribute("Id", (String)this.objectIDs.get(i));
                } else {
                    Hashtable nsMappingsLocal = DOM.getNamespaceMappingsInScopeSpecial((Node)((java.lang.Object)o));
                    Enumeration keys = nsMappingsLocal.keys();
                    while (keys.hasMoreElements()) {
                        String nextPrefix = (String)keys.nextElement();
                        String nextUri = (String)nsMappingsLocal.get(nextPrefix);
                        if (!nextUri.equals(this.idNamespaceURI)) continue;
                        ((Element)o.getDomRepresentation()).setAttributeNS(nextUri, nextPrefix + ":" + nextUri, (String)this.objectIDs.get(i));
                    }
                }
            }
            ++i;
        }
    }

    public static boolean[] detCommExcl(String canonURI) throws SignatureException {
        String url;
        boolean[] commExcl = new boolean[2];
        int sharpIndex = canonURI.indexOf(35);
        if (sharpIndex >= 0) {
            commExcl[0] = canonURI.substring(sharpIndex).equals("WithComments");
            url = canonURI.substring(0, sharpIndex);
        } else {
            commExcl[0] = false;
            url = canonURI;
        }
        if (url.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            commExcl[1] = true;
            return commExcl;
        }
        if (url.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315")) {
            commExcl[1] = false;
            return commExcl;
        }
        if (canonURI.equals("http://www.w3.org/2000/09/xmldsig#excludeC14N")) {
            commExcl[0] = true;
            commExcl[1] = true;
            return commExcl;
        }
        if (canonURI.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            commExcl[0] = false;
            commExcl[1] = true;
            return commExcl;
        }
        throw new SignatureException("Unrecognized canonicalization method uri : " + canonURI, new java.lang.Object[]{canonURI});
    }

    private void checkConsistency(String canonicalizationURI, String uri, Transformation[] transforms, String digestMethod) throws SignatureException {
        if (!"".equals(uri) && !uri.startsWith("#")) {
            int i = 0;
            while (i < transforms.length) {
                if (transforms[i].uri.equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) {
                    throw new SignatureException("Enveloped signatures can be done only on same-document references.", new java.lang.Object[]{canonicalizationURI, uri, transforms, digestMethod});
                }
                ++i;
            }
        }
        if ("".equals(uri) && transforms.length < 1) {
            throw new SignatureException("An empty uri (same document) reference without a transformation would surely be invalid!", new java.lang.Object[]{canonicalizationURI, uri, transforms, digestMethod});
        }
    }

    private static byte[] Asn1toXMLsignture(byte[] asn1Octets) throws SignatureException {
        int sLength;
        int rLength;
        int i = rLength = asn1Octets[3];
        while (i > 0 && asn1Octets[4 + rLength - i] == 0) {
            --i;
        }
        int j = sLength = asn1Octets[5 + rLength];
        while (j > 0 && asn1Octets[6 + rLength + sLength - j] == 0) {
            --j;
        }
        if (asn1Octets[0] != 48 || asn1Octets[1] != asn1Octets.length - 2 || asn1Octets[2] != 2 || i > 20 || asn1Octets[4 + rLength] != 2 || j > 20) {
            throw new SignatureException("Invalid format for DSA", new java.lang.Object[]{asn1Octets});
        }
        byte[] signatureOctets = new byte[40];
        System.arraycopy(asn1Octets, 4 + rLength - i, signatureOctets, 20 - i, i);
        System.arraycopy(asn1Octets, 6 + rLength + sLength - j, signatureOctets, 40 - j, j);
        return signatureOctets;
    }

    public boolean isPrefixListAdded() {
        return !this.skipPrefixList;
    }

    public void addPrefixList(boolean addPrefixList) {
        this.skipPrefixList = !addPrefixList;
    }

    public Node sign() throws NoSuchAlgorithmException, SignatureException {
        if (this.generateSignature) {
            throw new SignatureException("Document already signed");
        }
        this.sValue.appendTextChild(new String(this.sign(this.sInfo, this.privateKey)));
        return this.signature.getDomRepresentation();
    }

    public boolean isGenerateSignature() {
        return this.generateSignature;
    }

    public void setGenerateSignature(boolean generateSignature) {
        this.generateSignature = generateSignature;
    }

    public XMLSignature getSignature() {
        return this.signature;
    }

    static {
        nsMappings.put("ds", "http://www.w3.org/2000/09/xmldsig#");
    }
}

