/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption.keytrans.algorithms;

import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.encryption.keytrans.KeyTransporter;
import java.security.Key;

public class RSA_1_5_Transporter
extends KeyTransporter {
    static boolean rsa15fallback = Boolean.getBoolean("com.sap.xml.security.rsa15.fallback");

    public byte[] encrypt(Key wrapping, Key wrapped) throws SignatureException {
        SignatureException.traceKey("Key for wrapping(RSA 1.5)", wrapping);
        SignatureException.traceKey("Key to be wrapped(RSA 1.5)", wrapped);
        try {
            try {
                byte[] encoded = wrapped.getEncoded();
                this.cipher = SignatureContext.getCryptographicPool().generateCipherInstance("http://www.w3.org/2001/04/xmlenc#rsa-1_5", "ECB", "PKCS1Padding");
                this.cipher.init(1, wrapping);
                byte[] encrypted = this.cipher.doFinal(encoded, 0, encoded.length);
                SignatureException.traceByte("Result of encryption(RSA 1.5)", encrypted);
                byte[] byArray = encrypted;
                Object var7_7 = null;
                this.releaseCipher();
                return byArray;
            }
            catch (Exception other) {
                throw new SignatureException("Error in unwrapping key with RSA_1_5", other);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseCipher();
            throw throwable;
        }
    }

    public byte[] decrypt(Key wrapping, byte[] wrapped) throws SignatureException {
        SignatureException.traceKey("Key for unwrapping(RSA 1.5)", wrapping);
        SignatureException.traceByte("Wrapped bytes (RSA 1.5)", wrapped);
        try {
            try {
                this.cipher = SignatureContext.getCryptographicPool().generateCipherInstance("http://www.w3.org/2001/04/xmlenc#rsa-1_5", "ECB", "PKCS1Padding");
                this.cipher.init(2, wrapping);
                byte[] decrypted = this.cipher.doFinal(wrapped, 0, wrapped.length);
                SignatureException.traceByte("Result of decryption(RSA 1.5)", decrypted);
                byte[] byArray = decrypted;
                Object var6_7 = null;
                this.releaseCipher();
                return byArray;
            }
            catch (Exception other) {
                if (rsa15fallback) {
                    byte[] byArray = this.decryptFallBack(wrapping, wrapped);
                    Object var6_8 = null;
                    this.releaseCipher();
                    return byArray;
                }
                throw new SignatureException("Error in unwrapping key with RSA_1_5", other);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.releaseCipher();
            throw throwable;
        }
    }

    public byte[] decryptFallBack(Key wrapping, byte[] wrapped) throws SignatureException {
        this.mode = 2;
        this.cryptMode = "ECB";
        this.key = wrapping;
        this.createCipher("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        try {
            try {
                byte[] block = this.cipher.doFinal(wrapped, 0, wrapped.length);
                int start = 0;
                while (block[start] == 0) {
                    ++start;
                }
                if (block[start++] != 2) {
                    throw new SignatureException("Invalid encrypted key!", new Object[]{wrapping, wrapped});
                }
                while (block[start++] != 0) {
                }
                byte[] result = new byte[block.length - start];
                System.arraycopy(block, start, result, 0, result.length);
                byte[] byArray = result;
                Object var8_9 = null;
                this.releaseCipher();
                return byArray;
            }
            catch (SignatureException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SignatureException("Error while decrypting", new Object[]{wrapping, wrapped}, e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.releaseCipher();
            throw throwable;
        }
    }
}

