/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption.keytrans;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.encryption.XMLCryptor;
import com.sap.engine.lib.xml.signature.encryption.keytrans.algorithms.AES_Transporter;
import com.sap.engine.lib.xml.signature.encryption.keytrans.algorithms.RSA_1_5_Transporter;
import com.sap.engine.lib.xml.signature.encryption.keytrans.algorithms.RSA_OAEP_Transporter;
import com.sap.engine.lib.xml.signature.encryption.keytrans.algorithms.TDES_Transporter;
import java.security.Key;

public abstract class KeyTransporter
extends XMLCryptor {
    public abstract byte[] encrypt(Key var1, Key var2) throws SignatureException;

    public abstract byte[] decrypt(Key var1, byte[] var2) throws SignatureException;

    public static KeyTransporter getInstance(String uri) throws SignatureException {
        if ("http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(uri)) {
            return new RSA_1_5_Transporter();
        }
        if ("http://www.w3.org/2001/04/xmlenc#kw-tripledes".equals(uri)) {
            return new TDES_Transporter();
        }
        if (uri.startsWith("http://www.w3.org/2001/04/xmlenc#kw-aes")) {
            return new AES_Transporter(uri);
        }
        if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(uri)) {
            return new RSA_OAEP_Transporter();
        }
        throw new SignatureException("Unrecognized key transport algorithm uri: " + uri, new Object[]{uri});
    }

    public static KeyTransporter getInstance(String uri, GenericElement parent) throws SignatureException {
        if ("http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(uri)) {
            return new RSA_1_5_Transporter();
        }
        if ("http://www.w3.org/2001/04/xmlenc#kw-tripledes".equals(uri)) {
            return new TDES_Transporter();
        }
        if (uri.startsWith("http://www.w3.org/2001/04/xmlenc#kw-aes")) {
            return new AES_Transporter(uri);
        }
        if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(uri)) {
            return new RSA_OAEP_Transporter(parent);
        }
        throw new SignatureException("Unrecognized key transport algorithm uri: " + uri, new Object[]{uri});
    }
}

