/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption.aliases;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.encryption.aliases.KeyAliasResolver;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;

public class KeyStoreAliasResolver
implements KeyAliasResolver {
    private static final String name = "Key Store Alias Resolver v0.1";
    private KeyStore keyStore = null;
    private transient char[] password = null;
    private Certificate[] cert = null;

    public KeyStoreAliasResolver(KeyStore keystore, char[] password) {
        this.password = password;
        this.keyStore = keystore;
    }

    public Key getKey(String alias) throws SignatureException {
        try {
            return this.keyStore.getKey(alias, this.password);
        }
        catch (Exception ex) {
            throw new SignatureException("Unable to get key:" + alias + " from keystore with this password", new Object[]{this.keyStore, alias, this.password}, ex);
        }
    }

    public Enumeration getKeyAliases() throws SignatureException {
        try {
            return this.keyStore.aliases();
        }
        catch (Exception ex) {
            throw new SignatureException("Unable to get aliases", new Object[]{this.keyStore}, ex);
        }
    }

    public void removeKey(String alias) throws SignatureException {
        try {
            this.keyStore.deleteEntry(alias);
        }
        catch (Exception ex) {
            throw new SignatureException("Unable to delete:" + alias, new Object[]{this.keyStore, alias}, ex);
        }
    }

    public void addKey(String alias, Key key) throws SignatureException {
        try {
            this.keyStore.setKeyEntry(alias, key, this.password, this.cert);
        }
        catch (Exception ex) {
            throw new SignatureException("Unable to delete:" + alias, new Object[]{this.keyStore, alias}, ex);
        }
    }

    public String getName() {
        return name;
    }

    public void setCertificates(Certificate[] certificates) {
        this.cert = certificates;
    }

    public void setKeyStore(KeyStore ks) {
        this.keyStore = ks;
    }

    public Certificate[] getCertificates() {
        return this.cert;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public boolean contains(String alias) throws SignatureException {
        try {
            return this.keyStore.containsAlias(alias) && this.keyStore.isKeyEntry(alias);
        }
        catch (Exception ex) {
            throw new SignatureException("Unable to check:" + alias, new Object[]{this.keyStore, alias}, ex);
        }
    }

    public Key getKey(Object alias) throws SignatureException {
        String name = alias instanceof String ? (String)alias : alias.toString();
        return this.getKey(name);
    }

    public void removeKey(Object alias) throws SignatureException {
        String name = alias instanceof String ? (String)alias : alias.toString();
        this.removeKey(name);
    }

    public void addKey(Object alias, Key key) throws SignatureException {
        String name = alias instanceof String ? (String)alias : alias.toString();
        this.addKey(name, key);
    }

    public boolean contains(Object alias) throws SignatureException {
        String name = alias instanceof String ? (String)alias : alias.toString();
        return this.contains(name);
    }
}

