/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.elements;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.xml.dom.BinaryTextImpl;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.KeyInfo;
import com.sap.engine.lib.xml.signature.elements.Object;
import com.sap.engine.lib.xml.signature.elements.Reference;
import com.sap.engine.lib.xml.signature.elements.RetrievalMethod;
import com.sap.engine.lib.xml.signature.encryption.CipherData;
import com.sap.engine.lib.xml.signature.encryption.CipherReference;
import com.sap.engine.lib.xml.signature.encryption.EncReference;
import com.sap.engine.lib.xml.signature.encryption.EncryptedKey;
import com.sap.engine.lib.xml.signature.encryption.EncryptionMethod;
import com.sap.engine.lib.xml.signature.encryption.EncryptionProperties;
import com.sap.engine.lib.xml.signature.encryption.EncryptionProperty;
import com.sap.engine.lib.xml.signature.encryption.ReferenceList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class GenericElement {
    protected Document owner = null;
    protected Element domRepresentation = null;
    protected GenericElement parent = null;
    protected String namespaceUri = null;
    protected String qualifiedName = null;
    protected Hashtable attribs = null;
    protected List childElements = null;
    protected boolean descendantsInitialized = false;
    static char[] buf = new char[100];
    static Object monitor = new Object();

    public GenericElement(String namespaceUri, String qualifiedName) {
        this.namespaceUri = namespaceUri;
        this.qualifiedName = qualifiedName;
    }

    public GenericElement(String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        this(parent.getOwner(), namespaceUri, qualifiedName, parent);
    }

    public GenericElement(Node n, String namespaceUri, String qualifiedName, GenericElement parent, boolean generateDom) throws SignatureException {
        if (generateDom) {
            if (!(n instanceof Document)) {
                throw new SignatureException("The owner is supposed to be a document.", new java.lang.Object[]{n, namespaceUri, qualifiedName, parent});
            }
            this.init((Document)n, namespaceUri, qualifiedName, parent);
        } else {
            if (!(n instanceof Element)) {
                throw new SignatureException("The owner is supposed to be a document.", new java.lang.Object[]{n, namespaceUri, qualifiedName, parent});
            }
            this.init((Element)n, parent);
        }
    }

    public GenericElement(Document owner, String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        this.init(owner, namespaceUri, qualifiedName, parent);
    }

    public GenericElement(Element domRepresentation, GenericElement parent) throws SignatureException {
        this.init(domRepresentation, parent);
    }

    private void init(Document $owner, String $namespaceUri, String $qualifiedName, GenericElement $parent) throws SignatureException {
        if ($owner == null && $parent != null) {
            $owner = $parent instanceof Document ? (Document)((java.lang.Object)$parent) : $parent.getOwner();
        }
        this.namespaceUri = $namespaceUri;
        this.qualifiedName = $qualifiedName;
        this.owner = $owner;
        this.domRepresentation = $owner.createElementNS($namespaceUri, $qualifiedName);
        if ($parent != null) {
            $parent.appendChild(this);
        }
    }

    private void init(Element $domRepresentation, GenericElement $parent) throws SignatureException {
        this.owner = $domRepresentation.getOwnerDocument();
        this.parent = $parent;
        this.domRepresentation = $domRepresentation;
        this.namespaceUri = $domRepresentation.getNamespaceURI();
        if ($domRepresentation.getPrefix() == null) {
            this.qualifiedName = $domRepresentation.getLocalName();
        } else {
            String str = $domRepresentation.getPrefix();
            String other = $domRepresentation.getLocalName();
            int count = str.length();
            int otherLen = other.length();
            Object object = monitor;
            synchronized (object) {
                if (buf.length < count + otherLen + 1) {
                    buf = new char[count + otherLen + 1];
                }
                str.getChars(0, count, buf, 0);
                GenericElement.buf[count] = 58;
                other.getChars(0, otherLen, buf, count + 1);
                this.qualifiedName = new String(buf, 0, count + otherLen + 1);
            }
        }
        NamedNodeMap map = $domRepresentation.getAttributes();
        if (this.attribs == null && map.getLength() > 0) {
            this.attribs = new Hashtable();
        }
        int i = 0;
        while (i < map.getLength()) {
            Attr next = (Attr)map.item(i);
            this.attribs.put(next.getName(), next.getValue());
            ++i;
        }
    }

    public void initDOM(Document $owner) {
        this.owner = $owner;
        this.domRepresentation = $owner.createElementNS(this.namespaceUri, this.qualifiedName);
    }

    public void initDOM() throws SignatureException {
        try {
            DocumentBuilderFactoryImpl dbf = new DocumentBuilderFactoryImpl();
            DocumentBuilder db = ((DocumentBuilderFactory)dbf).newDocumentBuilder();
            this.initDOM(db.newDocument());
        }
        catch (ParserConfigurationException e) {
            throw new SignatureException("Error while initializing DOM", e);
        }
    }

    public Hashtable getNamespaceMappingsInScope() {
        return DOM.getNamespaceMappingsInScopeSpecial(this.domRepresentation);
    }

    public String getNodeValue() {
        this.domRepresentation.normalize();
        return this.domRepresentation.getFirstChild().getNodeValue();
    }

    public void setDomRepresentation(Element domRepresentation) {
        this.domRepresentation = domRepresentation;
    }

    public Node getDomRepresentation() {
        return this.domRepresentation;
    }

    public void setOwner(Document owner) {
        this.owner = owner;
    }

    public void setParent(GenericElement parent) {
        this.parent = parent;
    }

    public Document getOwner() {
        return this.owner;
    }

    public String getNamespaceURI() {
        return this.namespaceUri == null ? "" : this.namespaceUri;
    }

    public String getQName() {
        return this.qualifiedName;
    }

    public String getLocalName() {
        return this.qualifiedName.substring(this.qualifiedName.indexOf(":") + 1);
    }

    public String getAttribute(String localName, String prefix, String uri) {
        if (uri != null) {
            return this.domRepresentation.getAttributeNS(localName, uri);
        }
        return this.domRepresentation.getAttribute(localName);
    }

    public Hashtable getAttributes() {
        return this.attribs;
    }

    public GenericElement getParent() {
        return this.parent;
    }

    public void setAttribute(String name, String value) {
        if (name.startsWith("xmlns:") || "xmlns".equals(name)) {
            this.domRepresentation.setAttributeNS("http://www.w3.org/2000/xmlns/", name, value);
        } else {
            this.domRepresentation.setAttributeNS(null, name, value);
        }
        if (this.attribs == null) {
            this.attribs = new Hashtable();
        }
        this.attribs.put(name, value);
    }

    public void appendTextChild(String text) {
        Text t = this.owner.createTextNode(text);
        this.domRepresentation.appendChild(t);
    }

    public void appendBinaryTextChild(byte[] value) {
        BinaryTextImpl bin = new BinaryTextImpl(this.owner);
        bin.setBinaryData(value);
        this.domRepresentation.appendChild(bin);
    }

    public void insertBefore(GenericElement newChild, GenericElement refChild) throws SignatureException {
        Node refC = refChild.getDomRepresentation();
        Node newC = newChild.getDomRepresentation();
        if (newC.getParentNode() == this.domRepresentation) {
            this.domRepresentation.removeChild(newC);
        }
        this.domRepresentation.insertBefore(newC, refC);
        newChild.setParent(this);
    }

    public void appendChild(GenericElement child) throws SignatureException {
        this.domRepresentation.appendChild(child.getDomRepresentation());
        child.setParent(this);
    }

    public GenericElement getFirstChild() throws SignatureException {
        if (this.childElements != null && this.childElements.size() > 0) {
            return (GenericElement)this.childElements.get(0);
        }
        return null;
    }

    public Vector getDirectChildren(String uri, String localName) throws SignatureException {
        if (this.childElements == null) {
            return SignatureContext.EMPTY_VECTOR;
        }
        Vector<GenericElement> v = new Vector<GenericElement>(10);
        int i = 0;
        while (i < this.childElements.size()) {
            GenericElement next = (GenericElement)this.childElements.get(i);
            if (next.getNamespaceURI().equals(uri) && next.getLocalName().equals(localName)) {
                v.add(next);
            }
            ++i;
        }
        return v;
    }

    public GenericElement getDirectChild(String uri, String localName) throws SignatureException {
        if (this.childElements == null) {
            return null;
        }
        int i = 0;
        while (i < this.childElements.size()) {
            GenericElement next = (GenericElement)this.childElements.get(i);
            if (next.getNamespaceURI().equals(uri) && next.getLocalName().equals(localName)) {
                return next;
            }
            ++i;
        }
        return null;
    }

    public GenericElement getDirectChildIgnoreCase(String uri, String localName) throws SignatureException {
        if (this.childElements == null) {
            return null;
        }
        int i = 0;
        while (i < this.childElements.size()) {
            GenericElement next = (GenericElement)this.childElements.get(i);
            if (next.getNamespaceURI().equals(uri) && next.getLocalName().equalsIgnoreCase(localName)) {
                return next;
            }
            ++i;
        }
        return null;
    }

    public GenericElement getDescendant(String uri, String localName) throws SignatureException {
        GenericElement directChild = this.getDirectChild(uri, localName);
        if (directChild != null) {
            return directChild;
        }
        if (this.childElements == null) {
            return null;
        }
        int i = 0;
        while (i < this.childElements.size()) {
            GenericElement grandson = ((GenericElement)this.childElements.get(i)).getDescendant(uri, localName);
            if (grandson != null) {
                return grandson;
            }
            ++i;
        }
        return null;
    }

    public void removeChild(GenericElement child) {
        this.domRepresentation.removeChild(child.getDomRepresentation());
        child.setParent(null);
    }

    public void initializeDescendants() throws SignatureException {
        if (this.descendantsInitialized) {
            return;
        }
        NodeList children = this.domRepresentation.getChildNodes();
        if (children != null) {
            int length = children.getLength();
            if (length > 0 && this.childElements == null) {
                this.childElements = new Vector(length);
            }
            int i = 0;
            while (i < length) {
                Node next = children.item(i);
                if (next instanceof Element) {
                    GenericElement ge = null;
                    String nextUri = next.getNamespaceURI();
                    String name = next.getLocalName();
                    ge = "http://www.w3.org/2000/09/xmldsig#".equals(nextUri) ? ("Reference".equals(name) ? new Reference((Element)next, this) : ("KeyInfo".equals(name) ? new KeyInfo((Element)next, this) : ("RetrievalMethod".equals(name) ? new RetrievalMethod((Element)next, this) : new GenericElement((Element)next, this)))) : ("http://www.w3.org/2001/04/xmlenc#".equals(nextUri) ? ("EncryptionMethod".equals(name) ? new EncryptionMethod((Element)next, this) : ("CipherData".equals(name) ? new CipherData((Element)next, this) : ("EncryptedKey".equals(name) ? new EncryptedKey((Element)next, this) : ("CipherReference".equals(name) ? new CipherReference((Element)next, this) : ("DataReference".equals(name) ? new EncReference((Element)next, this, true) : ("KeyReference".equals(name) ? new EncReference((Element)next, this, false) : ("ReferenceList".equals(name) ? new ReferenceList((Element)next, this) : ("EncryptionProperty".equals(name) ? new EncryptionProperty((Element)next, this) : ("EncryptionProperties".equals(name) ? new EncryptionProperties((Element)next, this) : new GenericElement((Element)next, this)))))))))) : new GenericElement((Element)next, this));
                    this.childElements.add(ge);
                }
                ++i;
            }
        }
        if (this.childElements != null) {
            int i = 0;
            while (i < this.childElements.size()) {
                ((GenericElement)this.childElements.get(i)).initializeDescendants();
                ++i;
            }
        }
        this.descendantsInitialized = true;
    }
}

