/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.elements;

import com.sap.engine.lib.xml.signature.Constants;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.elements.KeyValue;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;

public class DSAKeyValue
extends KeyValue {
    private BigInteger p = null;
    private BigInteger q = null;
    private BigInteger g = null;
    private BigInteger y = null;
    private Certificate certificate = null;
    private DSAPublicKey publicKey = null;
    private DSAParams params = null;

    public DSAKeyValue(String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        super(namespaceUri, qualifiedName, parent);
    }

    public Certificate getCerificate() {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = (DSAPublicKey)publicKey;
    }

    public void construct() throws SignatureException {
        if (this.publicKey == null && this.certificate != null) {
            try {
                this.publicKey = (DSAPublicKey)this.certificate.getPublicKey();
            }
            catch (ClassCastException e) {
                throw new SignatureException("DSA key expected but " + this.certificate.getPublicKey().getAlgorithm() + " key received", new Object[]{this.certificate}, e);
            }
        }
        this.y = this.publicKey.getY();
        this.params = this.publicKey.getParams();
        this.p = this.params.getP();
        this.q = this.params.getQ();
        this.g = this.params.getG();
        GenericElement keyValue = new GenericElement("http://www.w3.org/2000/09/xmldsig#", Constants.STANDARD_PREFIX + "DSAKeyValue", this);
        GenericElement valueP = new GenericElement("http://www.w3.org/2000/09/xmldsig#", Constants.STANDARD_PREFIX + "P", keyValue);
        valueP.appendTextChild(new String(BASE64Encoder.encode(SignatureContext.getBytes(this.p))));
        GenericElement valueQ = new GenericElement("http://www.w3.org/2000/09/xmldsig#", Constants.STANDARD_PREFIX + "Q", keyValue);
        valueQ.appendTextChild(new String(BASE64Encoder.encode(SignatureContext.getBytes(this.q))));
        GenericElement valueG = new GenericElement("http://www.w3.org/2000/09/xmldsig#", Constants.STANDARD_PREFIX + "G", keyValue);
        valueG.appendTextChild(new String(BASE64Encoder.encode(SignatureContext.getBytes(this.g))));
        GenericElement valueY = new GenericElement("http://www.w3.org/2000/09/xmldsig#", Constants.STANDARD_PREFIX + "Y", keyValue);
        valueY.appendTextChild(new String(BASE64Encoder.encode(SignatureContext.getBytes(this.y))));
    }
}

