/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.engine.lib.xml.parser.DOMParser;
import com.sap.engine.lib.xml.parser.URLLoaderBase;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.handlers.INamespaceHandler;
import com.sap.engine.lib.xml.parser.handlers.NamespaceHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.signature.CryptographicPool;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.encryption.aliases.DefaultKeyAliasResolver;
import com.sap.engine.lib.xml.signature.encryption.aliases.KeyAliasResolver;
import com.sap.engine.lib.xml.signature.encryption.aliases.KeyAliasResolverImpl;
import com.sap.engine.lib.xml.signature.transform.algorithms.ByteArrayOutputStreamPool;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.DTMFactory;
import com.sap.engine.lib.xsl.xpath.ETBuilder;
import com.sap.engine.lib.xsl.xslt.NamespaceManager;
import com.sap.engine.lib.xsl.xslt.output.AttributeComparator;
import com.sap.engine.lib.xsl.xslt.output.CanonicalDocHandlerSerializerPool;
import com.sap.engine.lib.xsl.xslt.output.ExclusiveCanonicalDocHandlerSerializerPool;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public class SignatureContext {
    private static CryptographicPool cryptographicPool = null;
    private static CanonicalDocHandlerSerializerPool canPool = null;
    private static ExclusiveCanonicalDocHandlerSerializerPool exCanPool = null;
    private static ByteArrayOutputStreamPool bytePool = null;
    private static TransformerFactoryImpl tr = null;
    private static DocumentBuilderFactoryImpl documentBuilderFactoryTT = null;
    private static DocumentBuilderFactoryImpl documentBuilderFactoryFT = null;
    private static EntityResolver resolver = new URLLoaderBase();
    private static KeyAliasResolverImpl keyAliasResolver = null;
    public static final CharArray DEFAULT = new CharArray("#default").setStatic();
    public static final CharArray XMLNS = new CharArray("xmlns").setStatic();
    public static final CharArray XML = new CharArray("xml").setStatic();
    public static final Hashtable EMPTY = new Hashtable();
    public static final AttributeComparator ac = new AttributeComparator();
    public static int MAX_STACK_SIZE = 200;
    private static Properties propertiesCache = null;
    public static final String MIME_XML = "xml";
    public static final String MIME_HTML = "html";
    public static final String MIME_ANY = "";
    public static String DEFAULT_STR = "#default";
    public static Vector EMPTY_VECTOR = new Vector(0);
    public static boolean debug = false;
    public static int count = 0;
    public static final int ARRAY_SIZE = 16;
    public static int[] excludeList = new int[16];
    public static int excluded = 0;
    private static NamespaceManager nm = null;
    private static DTM dtm = null;
    private static DTMFactory factory = null;
    private static ETBuilder etBuilder = null;
    private static int calls = 0;
    public static int MAX_CALL_VALUE = 1000;
    protected static CharArray defaultPrefixName = NamespaceHandler.defaultPrefixName;
    protected static XMLParser parser = null;
    protected static DOMParser domParser = null;
    static /* synthetic */ Class class$com$sap$engine$lib$xml$dom$DocumentImpl;

    public static CryptographicPool getCryptographicPool() {
        if (cryptographicPool == null) {
            cryptographicPool = new CryptographicPool();
        }
        return cryptographicPool;
    }

    public static void nullCryptographicPool() {
        cryptographicPool = null;
    }

    public static CanonicalDocHandlerSerializerPool getCanonicalizationPool() {
        if (canPool == null) {
            canPool = new CanonicalDocHandlerSerializerPool();
        }
        return canPool;
    }

    public static ExclusiveCanonicalDocHandlerSerializerPool getExclusiveCanonicalizationPool() {
        if (exCanPool == null) {
            exCanPool = new ExclusiveCanonicalDocHandlerSerializerPool();
        }
        return exCanPool;
    }

    public static ByteArrayOutputStreamPool getByteArrayOutputStreamPool() {
        if (bytePool == null) {
            bytePool = new ByteArrayOutputStreamPool();
        }
        return bytePool;
    }

    public static synchronized Transformer getTransformer() throws TransformerConfigurationException {
        if (tr == null) {
            tr = new TransformerFactoryImpl();
        }
        return tr.newTransformer();
    }

    public static synchronized DocumentBuilder getDocumentBuilderTT() throws ParserConfigurationException {
        if (documentBuilderFactoryTT == null) {
            documentBuilderFactoryTT = new DocumentBuilderFactoryImpl();
            documentBuilderFactoryTT.setNamespaceAware(true);
            documentBuilderFactoryTT.setValidating(true);
        }
        DocumentBuilder ret = documentBuilderFactoryTT.newDocumentBuilder();
        ret.setEntityResolver(resolver);
        return ret;
    }

    public static synchronized DocumentBuilder getDocumentBuilderFT() throws ParserConfigurationException {
        if (documentBuilderFactoryFT == null) {
            documentBuilderFactoryFT = new DocumentBuilderFactoryImpl();
            documentBuilderFactoryFT.setNamespaceAware(true);
            documentBuilderFactoryFT.setValidating(false);
        }
        DocumentBuilder ret = documentBuilderFactoryFT.newDocumentBuilder();
        ret.setEntityResolver(resolver);
        return ret;
    }

    public static void setEntityResolver(EntityResolver er) {
        resolver = er;
    }

    public static EntityResolver getEntityResolver() {
        return resolver;
    }

    public static void nullPools() {
        canPool = null;
        exCanPool = null;
        bytePool = null;
    }

    public static KeyAliasResolver getKeyAliasResolver() {
        if (keyAliasResolver == null) {
            keyAliasResolver = new KeyAliasResolverImpl();
            keyAliasResolver.addKeyAliasResolver(new DefaultKeyAliasResolver());
        }
        return keyAliasResolver;
    }

    public static void nullKeyAliasResolver() {
        keyAliasResolver = null;
    }

    public static boolean isNamespace(CharArray prefix, CharArray localName) {
        return XMLNS.equals(prefix) || (prefix == null || prefix.length() == 0) && XMLNS.equals(localName);
    }

    public static CharArray getNamespaceDeclaration(CharArray prefix, CharArray localName) {
        if (XMLNS.equals(prefix)) {
            return localName;
        }
        if ((prefix == null || prefix.length() == 0) && XMLNS.equals(localName)) {
            return DEFAULT;
        }
        return null;
    }

    public static boolean equals(String arg1, String arg2) {
        return (arg1 == null || arg1.length() == 0) && (arg2 == null || arg2.length() == 0) || arg1 != null && arg1.equals(arg2);
    }

    private static void fillMore(Properties p) {
        p.setProperty("method", MIME_XML);
        p.setProperty("encoding", "utf-8");
        p.setProperty("indent", "no");
        p.setProperty("omit-xml-declaration", "yes");
        p.setProperty("cdata-section-elements", MIME_ANY);
    }

    public static Properties getProperties() {
        if (propertiesCache == null) {
            propertiesCache = new Properties();
            SignatureContext.fillMore(propertiesCache);
        }
        return propertiesCache;
    }

    public static String getLocalName(String qualifiedName) {
        return qualifiedName.substring(qualifiedName.indexOf(":") + 1);
    }

    public static String getPrefix(String qualifiedName) {
        return qualifiedName.substring(0, qualifiedName.indexOf(":"));
    }

    public static String[] removeDuplicates(String[] source) {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < source.length) {
            block3: {
                int j = 0;
                while (j < v.size()) {
                    if (!v.get(j).equals(source[i])) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                v.add(source[i]);
            }
            ++i;
        }
        Object[] res = new String[v.size()];
        v.copyInto(res);
        return res;
    }

    public static String removeAllOccurrencesOf(char what, String where) {
        StringBuffer result = new StringBuffer(where.length());
        int i = 0;
        while (i < where.length()) {
            char temp = where.charAt(i);
            if (temp != what) {
                result.append(temp);
            }
            ++i;
        }
        return result.toString();
    }

    public static String[] getTypes(Certificate[] certs) {
        String[] certTypes = new String[certs.length];
        int i = 0;
        while (i < certs.length) {
            certTypes[i] = certs[i].getType();
            certTypes[i] = SignatureContext.removeAllOccurrencesOf('.', certTypes[i]);
            ++i;
        }
        return certTypes;
    }

    public static byte[] getBytes(BigInteger b) {
        int length = b.bitLength();
        if (length >> 3 << 3 == length) {
            byte[] signed = b.toByteArray();
            byte[] unsigned = new byte[signed.length - 1];
            System.arraycopy(signed, 1, unsigned, 0, signed.length - 1);
            return unsigned;
        }
        byte[] bytes = b.toByteArray();
        return bytes;
    }

    public static byte[] getBytes(BigInteger big, int bitlen) {
        if ((bitlen = bitlen + 7 - (bitlen + 7) % 8) < big.bitLength()) {
            throw new IllegalArgumentException("IllegalBitlength");
        }
        byte[] bigBytes = big.toByteArray();
        if (big.bitLength() % 8 != 0 && big.bitLength() / 8 + 1 == bitlen / 8) {
            return bigBytes;
        }
        int startSrc = 0;
        int bigLen = bigBytes.length;
        if (big.bitLength() % 8 == 0) {
            startSrc = 1;
            --bigLen;
        }
        int startDst = bitlen / 8 - bigLen;
        byte[] resizedBytes = new byte[bitlen / 8];
        System.arraycopy(bigBytes, startSrc, resizedBytes, startDst, bigLen);
        return resizedBytes;
    }

    public static DTM getDTM() {
        if (++calls > MAX_CALL_VALUE) {
            nm = null;
            dtm = null;
            factory = null;
            etBuilder = null;
            excludeList = new int[16];
            calls = 0;
        }
        if (dtm == null) {
            dtm = new DTM();
        } else {
            dtm.clearDirty();
        }
        return dtm;
    }

    public static DTMFactory getDTMFactory() {
        if (factory == null) {
            factory = new DTMFactory();
        }
        return factory;
    }

    public static NamespaceManager getNamespaceManager() {
        if (nm == null) {
            nm = new NamespaceManager();
        } else {
            nm.reuse();
        }
        return nm;
    }

    public static ETBuilder getETBuilder() {
        if (etBuilder == null) {
            etBuilder = new ETBuilder();
        }
        return etBuilder;
    }

    public static synchronized Document parse(InputStream is, Hashtable mappings) throws SignatureException {
        try {
            if (domParser == null) {
                parser = new XMLParser();
                parser.setInitializeNamespaceHandler(false);
                domParser = new DOMParser(parser);
                domParser.setFeature("http://xml.org/sax/features/namespaces", true);
                domParser.setFeature("http://xml.org/sax/features/validation", false);
                domParser.setDocumentClassName((class$com$sap$engine$lib$xml$dom$DocumentImpl == null ? (class$com$sap$engine$lib$xml$dom$DocumentImpl = SignatureContext.class$("com.sap.engine.lib.xml.dom.DocumentImpl")) : class$com$sap$engine$lib$xml$dom$DocumentImpl).getName());
            }
            parser.init();
            if (mappings != null && mappings.size() > 0) {
                INamespaceHandler nh = parser.getNamespaceHandler();
                Enumeration enumeration = mappings.keys();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    CharArray mapping = key.length() == 0 ? defaultPrefixName : new CharArray(key);
                    CharArray value = new CharArray((String)mappings.get(key));
                    value.setStatic();
                    mapping.setStatic();
                    nh.add(mapping, value);
                }
            }
            return domParser.parse(is);
        }
        catch (Exception ex) {
            throw new SignatureException("Error while parsing input stream", new Object[]{is, mappings}, ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

