/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.tokenizer;

import com.sap.engine.lib.xml.parser.ActiveXMLParser;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.XMLParserConstants;
import com.sap.engine.lib.xml.parser.handlers.EmptyDocHandler;
import com.sap.engine.lib.xml.parser.handlers.INamespaceHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.CharArrayStack;
import com.sap.engine.lib.xml.parser.helpers.Entity;
import com.sap.engine.lib.xml.parser.helpers.Reference;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xsl.xslt.InternalAttribute;
import com.sap.engine.lib.xsl.xslt.InternalAttributeList;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.AttributesImpl;

public class XMLTokenReaderImpl
extends EmptyDocHandler
implements XMLParserConstants,
XMLTokenReader {
    boolean ommitComments = true;
    private boolean shouldFakeEnd = false;
    private boolean textDeclAllowed = true;
    private boolean endOfRootReached = false;
    private InputStream xmlInputStream = null;
    private InputSource xmlInputSource = null;
    private Reader xmlReader = null;
    private int currentState = 0;
    private XMLParser parser = null;
    private INamespaceHandler namespaceHandler = null;
    private CharArray uri = null;
    private CharArray localName = null;
    private CharArray qName = null;
    private CharArray charData = new CharArray();
    private InternalAttributeList attribs = new InternalAttributeList();
    private int depthReached = 0;
    private boolean append = false;
    private CharArray tempGetPrefix = new CharArray();

    public INamespaceHandler getNamespaceHandler() {
        return this.namespaceHandler;
    }

    public void setOmmitComments(boolean flag) {
        this.ommitComments = flag;
    }

    public boolean getOmmitComments() {
        return this.ommitComments;
    }

    public XMLTokenReaderImpl(InputSource xmlInputSource) {
        this();
        this.xmlInputSource = xmlInputSource;
    }

    public XMLTokenReaderImpl(XMLParser parser) {
        this();
        this.parser = parser;
    }

    public XMLTokenReaderImpl(InputStream xmlInputStream) {
        this();
        this.xmlInputStream = xmlInputStream;
    }

    public XMLTokenReaderImpl(Reader xmlReader) {
        this();
        this.xmlReader = xmlReader;
    }

    public XMLTokenReaderImpl() {
    }

    public void reuse(InputStream stream) {
        this.xmlInputStream = stream;
        this.append = false;
        this.depthReached = 0;
        this.shouldFakeEnd = false;
        this.textDeclAllowed = true;
        this.endOfRootReached = false;
        this.xmlInputSource = null;
        this.currentState = 0;
        this.charData.clear();
    }

    public void init(InputStream stream) {
        this.reuse(stream);
    }

    public int begin() throws ParserException {
        try {
            this.parser = this.getParser();
            this.namespaceHandler = this.parser.getNamespaceHandler();
            this.shouldFakeEnd = false;
            this.endOfRootReached = false;
            if (this.xmlInputSource == null) {
                if (this.xmlReader != null) {
                    this.xmlInputSource = new InputSource(this.xmlReader);
                }
                if (this.xmlInputStream != null) {
                    this.xmlInputSource = new InputSource(this.xmlInputStream);
                }
            }
            this.parser.activeParse(this.xmlInputSource, this);
            this.currentState = 0;
            return this.currentState;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    public int next() throws ParserException {
        try {
            if (this.endOfRootReached) {
                this.parser.scanS();
            }
            if (this.parser.getDocFinished()) {
                this.currentState = 6;
                this.parser.finalizeActiveParse();
                return 6;
            }
            if (this.shouldFakeEnd) {
                this.shouldFakeEnd = false;
                this.currentState = 2;
                --this.depthReached;
                return this.currentState;
            }
            int i = this.parser.checkMarkup();
            switch (i) {
                case 2: {
                    this.parser.scanPI(this.textDeclAllowed);
                    this.textDeclAllowed = false;
                    return 4;
                }
                case 3: {
                    this.parser.scanElement();
                    return 1;
                }
                case 1: {
                    this.parser.scanComment();
                    if (this.ommitComments) {
                        return this.next();
                    }
                    return 5;
                }
                case 8: {
                    this.parser.scanCharData();
                    return 3;
                }
                case 9: {
                    this.parser.scanCDSect();
                    return 3;
                }
                case 10: {
                    this.parser.scanEndTag();
                    if (this.depthReached < 1) {
                        this.endOfRootReached = true;
                        this.parser.finalizeActiveScan();
                    }
                    return 2;
                }
                case 16: {
                    this.parser.handleContentReference(false);
                    return 3;
                }
                case 17: {
                    this.parser.scanDTD();
                    return this.next();
                }
            }
            throw new ParserException(" Unrecognized case: " + i, -1, 0);
        }
        catch (ParserException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    public void startElementStart(CharArray uri, CharArray localName, CharArray qname) throws Exception {
        this.uri = uri;
        this.localName = localName;
        this.qName = qname;
        this.attribs.clear();
        this.charData.setSize(0);
        ++this.depthReached;
    }

    public void addAttribute(CharArray uri, CharArray prefix, CharArray localName, CharArray qname, String type, CharArray value) throws Exception {
        this.attribs.addAttribute(uri, prefix, qname, localName, value);
    }

    public void startElementEnd(boolean isEmpty) throws Exception {
        this.currentState = 1;
        if (isEmpty) {
            this.shouldFakeEnd = true;
        }
    }

    public void endElement(CharArray uri, CharArray localName, CharArray qname, boolean isEmpty) throws Exception {
        this.uri = uri;
        this.localName = localName;
        this.qName = qname;
        if (!isEmpty) {
            this.currentState = 2;
            --this.depthReached;
        }
    }

    public void startDocument() throws Exception {
        this.currentState = 0;
    }

    public void endDocument() throws Exception {
        this.currentState = 6;
    }

    public void charData(CharArray carr, boolean bDisableOutputEscaping) throws Exception {
        if (this.append) {
            this.charData.append(carr);
        } else {
            this.charData.set(carr);
        }
        this.currentState = 3;
    }

    public void onXMLDecl(String version, String encoding, String ssdecl) throws Exception {
    }

    public void onPI(CharArray target, CharArray data) throws Exception {
    }

    public void onComment(CharArray text) throws Exception {
        if (!this.ommitComments) {
            this.currentState = 5;
            this.charData.set(text);
        }
    }

    public void onCDSect(CharArray text) throws Exception {
        if (this.append) {
            this.charData.append(text);
        } else {
            this.charData.set(text);
        }
        this.currentState = 3;
    }

    public void onDTDElement(CharArray name, CharArray model) throws Exception {
    }

    public void onDTDAttListStart(CharArray name) throws Exception {
    }

    public void onDTDAttListItem(CharArray name, CharArray attname, String type, String defDecl, CharArray vAttValue, String note) throws Exception {
    }

    public void onDTDAttListEnd() throws Exception {
    }

    public void onDTDEntity(Entity entity) throws Exception {
    }

    public void onDTDNotation(CharArray name, CharArray pub, CharArray sys) throws Exception {
    }

    public void startDTD(CharArray name, CharArray pub, CharArray sys) throws Exception {
    }

    public void endDTD() throws Exception {
    }

    public void onContentReference(Reference ref) throws Exception {
    }

    public void end() throws ParserException {
        if (this.currentState != 6) {
            throw new ParserException("EOF not reached yet!", 0, 0);
        }
        try {
            this.parser.finalizeActiveParse();
        }
        catch (Exception e) {
            throw new ParserException(e.toString(), 0, 0);
        }
    }

    public int getState() {
        return this.currentState;
    }

    public String getQName() {
        return this.qName.getString();
    }

    public CharArray getQNameCharArray() {
        return this.qName;
    }

    public String getLocalName() {
        return this.localName.getString();
    }

    public CharArray getLocalNameCharArray() {
        return this.localName;
    }

    public String getURI() {
        return this.uri.getString();
    }

    public CharArray getURICharArray() {
        return this.uri;
    }

    public Attributes getAttributes() {
        if (this.currentState != 1) {
            return null;
        }
        AttributesImpl attr = new AttributesImpl();
        int i = 0;
        while (i < this.attribs.size()) {
            InternalAttribute ia = this.attribs.get(i);
            attr.addAttribute(ia.uri == null ? null : ia.uri.getString(), ia.localName == null ? null : ia.localName.toString(), ia.qname == null ? null : ia.qname.getString(), null, ia.value == null ? null : ia.value.getString());
            ++i;
        }
        return attr;
    }

    public InternalAttributeList getInternalAttributeList() {
        return this.attribs;
    }

    public String getValue() {
        return this.charData.getStringFast();
    }

    public CharArray getValueCharArray() {
        return this.charData;
    }

    public CharArray getValuePassCharsCA() throws ParserException {
        this.append = true;
        while (this.currentState == 3) {
            this.next();
        }
        this.append = false;
        return this.charData;
    }

    public String getValuePassChars() throws ParserException {
        this.append = true;
        while (this.currentState == 3) {
            this.next();
        }
        this.append = false;
        return this.charData.getStringFast();
    }

    public boolean isWhitespace() {
        return this.charData.isWhitespace();
    }

    public Element getDOMRepresentation(Element element) throws ParserException {
        if (this.getState() != 1) {
            return null;
        }
        Hashtable prefixMappings = this.namespaceHandler.getNamespaceMappings();
        Enumeration enum1 = prefixMappings.keys();
        while (enum1.hasMoreElements()) {
            CharArray key = (CharArray)enum1.nextElement();
            String namespace = (String)prefixMappings.get(key);
            if (namespace.length() == 0) continue;
            if (key.length() == 0) {
                element.setAttribute("xmlns", namespace);
                continue;
            }
            element.setAttribute("xmlns:" + key, namespace);
        }
        return this.fillElement(element);
    }

    public Element getDOMRepresentation(Document document) throws ParserException {
        if (this.getState() != 1) {
            return null;
        }
        Element element = document.createElementNS(this.getURI(), this.getQName());
        return this.getDOMRepresentation(element);
    }

    public void writeTo(Writer writer) throws ParserException, IOException {
        if (this.getState() != 3 && this.getState() != 1) {
            throw new ParserException("Invalid reader state.", 0, 0);
        }
        if (this.getState() != 3) {
            Hashtable<String, String> effPrefMapsAttr = new Hashtable<String, String>();
            Hashtable prefixMappings = this.namespaceHandler.getNamespaceMappings();
            Enumeration enum1 = prefixMappings.keys();
            while (enum1.hasMoreElements()) {
                CharArray key = (CharArray)enum1.nextElement();
                String namespace = (String)prefixMappings.get(key);
                if (namespace.length() == 0) continue;
                if (key.length() == 0) {
                    effPrefMapsAttr.put("xmlns", namespace);
                    continue;
                }
                effPrefMapsAttr.put("xmlns:" + key, namespace);
            }
            writer.write(60);
            CharArray charArr = this.getQNameCharArray();
            writer.write(charArr.getData(), charArr.getOffset(), charArr.getSize());
            writer.write(32);
            Attributes atts = this.getAttributes();
            int i = 0;
            while (i < atts.getLength()) {
                String qname = atts.getQName(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(atts.getURI(i)) && !"xmlns".equals(atts.getLocalName(i))) {
                    writer.write(atts.getQName(i));
                    writer.write("='");
                    writer.write(atts.getValue(i));
                    writer.write("' ");
                } else {
                    effPrefMapsAttr.put(atts.getQName(i), atts.getValue(i));
                }
                ++i;
            }
            enum1 = effPrefMapsAttr.keys();
            while (enum1.hasMoreElements()) {
                String prefD = (String)enum1.nextElement();
                writer.write(prefD + "='");
                writer.write((String)effPrefMapsAttr.get(prefD));
                writer.write("' ");
            }
            writer.write(62);
            int level = 0;
            block10: while (true) {
                int code = this.next();
                switch (code) {
                    case 5: {
                        this.writeCharsOrComment(writer);
                        continue block10;
                    }
                    case 3: {
                        this.writeCharsOrComment(writer);
                        continue block10;
                    }
                    case 1: {
                        this.writeStartEndElement(writer);
                        ++level;
                        continue block10;
                    }
                    case 2: {
                        this.writeStartEndElement(writer);
                        if (level == 0) {
                            writer.flush();
                            return;
                        }
                        --level;
                        continue block10;
                    }
                    case 6: {
                        throw new ParserException("Unexpexted EOF.", 0, 0);
                    }
                }
            }
        }
        this.writeCharsOrComment(writer);
        writer.flush();
    }

    private Element fillElement(Element element) throws ParserException {
        Attributes attrs = this.getAttributes();
        int attrsLeght = attrs.getLength();
        int i = 0;
        while (i < attrsLeght) {
            String attribUri = attrs.getURI(i);
            String attribQName = attrs.getQName(i);
            String attribValue = attrs.getValue(i);
            if (attribQName.equals("xmlns")) {
                attribUri = "http://www.w3.org/2000/xmlns/";
            }
            element.setAttributeNS(attribUri, attribQName, attribValue);
            ++i;
        }
        while (true) {
            int code = this.next();
            switch (code) {
                case 5: {
                    element.appendChild(element.getOwnerDocument().createComment(this.getValue()));
                    break;
                }
                case 3: {
                    element.appendChild(element.getOwnerDocument().createTextNode(this.getValue()));
                    break;
                }
                case 1: {
                    Element child = element.getOwnerDocument().createElementNS(this.getURI(), this.getQName());
                    element.appendChild(this.fillElement(child));
                    break;
                }
                case 2: {
                    return element;
                }
                case 6: {
                    throw new ParserException("Unexpexted EOF.", 0, 0);
                }
            }
        }
    }

    public int moveToNextElementStart() throws ParserException {
        int code;
        do {
            if ((code = this.next()) != 1) continue;
            return 1;
        } while (code != 6);
        return 6;
    }

    public void startPrefixMapping(CharArray prefix, CharArray uri) throws Exception {
    }

    public void endPrefixMapping(CharArray prefix) throws Exception {
    }

    public XMLParser getParser() throws ParserException {
        if (this.parser == null) {
            this.parser = new XMLParser();
            this.parser.setSoapProcessing(true);
            this.parser.setNamespaces(true);
        }
        return this.parser;
    }

    public void setParser(XMLParser parser) {
        this.parser = parser;
    }

    public String getPrefixMapping(String prefix) {
        this.tempGetPrefix.set(prefix);
        return this.namespaceHandler.get(this.tempGetPrefix).toString();
    }

    public void passChars() throws ParserException {
        while (this.currentState == 3) {
            this.next();
        }
    }

    public String getParentElement() {
        CharArrayStack stack = this.parser.getElementStack();
        if (this.currentState == 1) {
            CharArray current = new CharArray(stack.getTop());
            stack.matchTop(new CharArray(current));
            if (stack.isEmpty()) {
                stack.put(current);
                return null;
            }
            char[] top = stack.getTop();
            stack.put(current);
            return new String(top);
        }
        if (stack.isEmpty()) {
            return null;
        }
        return new String(stack.getTop());
    }

    public static void main(String[] args) throws Exception {
        ActiveXMLParser parser = new ActiveXMLParser(new FileInputStream("D:\\develop\\schema_test\\test3.xml"));
        parser.begin();
    }

    public int getCurrentLevel() {
        return this.depthReached;
    }

    public void setEntityResolver(EntityResolver entityResolver) throws ParserException {
        this.getParser().setEntityResolver(entityResolver);
    }

    private void writeStartEndElement(Writer writer) throws IOException {
        if (this.getState() == 1) {
            writer.write(60);
            CharArray charArr = this.getQNameCharArray();
            writer.write(charArr.getData(), charArr.getOffset(), charArr.getSize());
            writer.write(32);
            Attributes atts = this.getAttributes();
            int i = 0;
            while (i < atts.getLength()) {
                writer.write(atts.getQName(i));
                writer.write("='");
                writer.write(atts.getValue(i));
                writer.write("' ");
                ++i;
            }
            writer.write(62);
        } else {
            writer.write("</");
            CharArray charArr = this.getQNameCharArray();
            writer.write(charArr.getData(), charArr.getOffset(), charArr.getSize());
            writer.write(62);
        }
    }

    private void writeCharsOrComment(Writer writer) throws IOException {
        CharArray charArr = this.getValueCharArray();
        if (this.getState() == 5) {
            writer.write("<!--");
            writer.write(charArr.getData(), charArr.getOffset(), charArr.getSize());
            writer.write("-->");
        } else {
            writer.write(charArr.getData(), charArr.getOffset(), charArr.getSize());
        }
    }
}

