/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.tokenizer;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.tokenizer.PrefixHolder;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReader;
import com.sap.engine.lib.xsl.xslt.InternalAttributeList;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.helpers.AttributesImpl;

public class XMLDOMTokenReaderNew
implements XMLTokenReader {
    private boolean omitComments = true;
    private Element rootElement = null;
    private int state = 0;
    private Element currentElement = null;
    private Node currentNode = null;
    private CharArray currentCharacters = new CharArray();
    private int currentLevel = 0;
    private AttributesImpl attributes = null;
    private boolean append = false;
    private Hashtable namespaces;
    private Hashtable currentNamespaces;
    private ArrayList namespacesToRemove;

    public XMLDOMTokenReaderNew(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("[NULL] Node passed for XML reading.");
        }
        this.rootElement = element;
        this.attributes = new AttributesImpl();
        this.namespaces = new Hashtable();
        this.currentNamespaces = new Hashtable();
        this.namespacesToRemove = new ArrayList();
    }

    public void setOmitComments(boolean flag) {
        this.omitComments = flag;
    }

    public boolean isOmitComments() {
        return this.omitComments;
    }

    public XMLDOMTokenReaderNew(Element element, Hashtable prefixes) {
        if (element == null) {
            throw new IllegalArgumentException("[NULL] Node passed for XML reading.");
        }
        this.rootElement = element;
        this.attributes = new AttributesImpl();
        this.namespaces = new Hashtable();
        this.setInitialPrefixes(prefixes);
        this.currentNamespaces = new Hashtable();
        this.namespacesToRemove = new ArrayList();
    }

    private void setInitialPrefixes(Hashtable hashtable) {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String prefix = (String)enumeration.nextElement();
                String namespace = (String)hashtable.get(prefix);
                PrefixHolder ph = new PrefixHolder(prefix);
                ph.enter(namespace);
                this.namespaces.put(prefix, ph);
            }
        }
    }

    public void init(Element element, Hashtable prefixes) {
        this.init(element);
        this.setInitialPrefixes(prefixes);
    }

    public void init(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("[NULL] Node passed for XML reading.");
        }
        this.rootElement = element;
        this.currentElement = null;
        this.state = 0;
        this.currentLevel = 0;
        this.attributes.clear();
        this.append = false;
        this.namespaces.clear();
        this.currentNamespaces.clear();
        this.namespacesToRemove.clear();
    }

    public int begin() throws ParserException {
        this.state = 1;
        this.currentElement = this.rootElement;
        this.currentNode = null;
        this.currentCharacters.clear();
        ++this.currentLevel;
        this.initAttributes();
        this.append = false;
        return this.state;
    }

    private void namespacesDown() {
        String prefix;
        Enumeration nsKeys = this.namespaces.keys();
        while (nsKeys.hasMoreElements()) {
            prefix = (String)nsKeys.nextElement();
            if (this.currentNamespaces.containsKey(prefix)) continue;
            PrefixHolder ph = (PrefixHolder)this.namespaces.get(prefix);
            ph.enter();
        }
        nsKeys = this.currentNamespaces.keys();
        while (nsKeys.hasMoreElements()) {
            prefix = (String)nsKeys.nextElement();
            String ns = (String)this.currentNamespaces.get(prefix);
            PrefixHolder ph = (PrefixHolder)this.namespaces.get(prefix);
            if (ph == null) {
                ph = new PrefixHolder(prefix);
                ph.enter(ns);
                this.namespaces.put(prefix, ph);
                continue;
            }
            ph.enter(ns);
        }
        this.currentNamespaces.clear();
    }

    private void namespacesUp() {
        this.namespacesToRemove.clear();
        Enumeration enumeration = this.namespaces.keys();
        while (enumeration.hasMoreElements()) {
            String prefix = (String)enumeration.nextElement();
            PrefixHolder ph = (PrefixHolder)this.namespaces.get(prefix);
            if (!ph.leave()) continue;
            this.namespacesToRemove.add(prefix);
        }
        int i = 0;
        while (i < this.namespacesToRemove.size()) {
            String prefix = (String)this.namespacesToRemove.get(i);
            this.namespaces.remove(prefix);
            ++i;
        }
    }

    private void initAttributes() {
        this.attributes.clear();
        this.currentNamespaces.clear();
        NamedNodeMap attributesNodeMap = this.currentElement.getAttributes();
        int i = 0;
        while (i < attributesNodeMap.getLength()) {
            String namespace;
            String prefix;
            Node attrib = attributesNodeMap.item(i);
            String attribUri = attrib.getNamespaceURI();
            if (attribUri == null) {
                attribUri = "";
            }
            String attribLocalName = attrib.getLocalName();
            String attribQName = attrib.getNodeName();
            String attribValue = attrib.getNodeValue();
            if (attribUri.equals("http://www.w3.org/2000/xmlns/")) {
                prefix = attribQName.indexOf(58) < 0 ? "" : attribLocalName;
                namespace = attribValue;
                this.currentNamespaces.put(prefix, namespace);
            }
            if ("xmlns".equals(attribQName)) {
                prefix = "";
                namespace = attribValue;
                this.currentNamespaces.put(prefix, namespace);
            }
            this.attributes.addAttribute(attribUri, attribLocalName, attribQName, null, attribValue);
            ++i;
        }
        this.namespacesDown();
    }

    public void end() throws ParserException {
        this.currentCharacters.clear();
        this.state = 6;
        this.currentElement = null;
        this.currentNode = null;
        this.currentLevel = 0;
        this.attributes.clear();
    }

    public Attributes getAttributes() {
        if (this.state == 1) {
            return this.attributes;
        }
        return null;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public Element getDOMRepresentation(Document doc) throws ParserException {
        if (this.state == 1) {
            this.state = 2;
            return this.currentElement;
        }
        return null;
    }

    public InternalAttributeList getInternalAttributeList() {
        return null;
    }

    public String getLocalName() {
        if (this.state == 1 || this.state == 2) {
            return this.currentElement.getLocalName();
        }
        return null;
    }

    public CharArray getLocalNameCharArray() {
        if (this.state == 1 || this.state == 2) {
            return new CharArray(this.currentElement.getLocalName());
        }
        return null;
    }

    public String getParentElement() {
        Node node = null;
        if (this.state == 1 || this.state == 2) {
            node = this.currentElement.getParentNode();
            if (node != null && node instanceof Element) {
                return ((Element)node).getLocalName();
            }
            return null;
        }
        node = this.currentNode.getParentNode();
        if (node != null && node instanceof Element) {
            return ((Element)node).getLocalName();
        }
        return null;
    }

    public String getPrefixMapping(String prefix) {
        PrefixHolder ph;
        if (prefix == null) {
            prefix = "";
        }
        if ((ph = (PrefixHolder)this.namespaces.get(prefix)) != null) {
            String top = ph.top();
            if (top.length() == 0) {
                return null;
            }
            return top;
        }
        return null;
    }

    public String getQName() {
        if (this.state == 1 || this.state == 2) {
            return this.currentElement.getTagName();
        }
        return null;
    }

    public CharArray getQNameCharArray() {
        if (this.state == 1 || this.state == 2) {
            return new CharArray(this.currentElement.getTagName());
        }
        return null;
    }

    public int getState() {
        return this.state;
    }

    public String getURI() {
        if (this.state == 1 || this.state == 2) {
            return this.currentElement.getNamespaceURI();
        }
        return null;
    }

    public CharArray getURICharArray() {
        if (this.state == 1 || this.state == 2) {
            return new CharArray(this.currentElement.getNamespaceURI());
        }
        return null;
    }

    public String getValue() {
        return this.currentCharacters.getStringFast();
    }

    public CharArray getValueCharArray() {
        return this.currentCharacters;
    }

    public String getValuePassChars() throws ParserException {
        this.append = true;
        while (this.state == 3) {
            this.next();
        }
        this.append = false;
        return this.currentCharacters.getStringFast();
    }

    public CharArray getValuePassCharsCA() throws ParserException {
        this.append = true;
        while (this.state == 3) {
            this.next();
        }
        this.append = false;
        return this.currentCharacters;
    }

    public void init(InputStream input) {
    }

    public boolean isWhitespace() {
        return this.currentCharacters.isWhitespace();
    }

    public int moveToNextElementStart() throws ParserException {
        int code = this.next();
        while (code != 1 && code != 6) {
            code = this.next();
        }
        return code;
    }

    public int next() throws ParserException {
        if (this.currentElement != null) {
            if (this.state == 2) {
                --this.currentLevel;
                this.currentCharacters.clear();
                this.namespacesUp();
                if (this.currentElement == this.rootElement) {
                    this.state = 6;
                    this.currentElement = null;
                } else {
                    Node newNode = this.currentElement.getNextSibling();
                    if (newNode == null) {
                        this.currentElement = (Element)this.currentElement.getParentNode();
                        this.state = 2;
                    } else if (newNode instanceof Element) {
                        ++this.currentLevel;
                        this.currentElement = (Element)newNode;
                        this.state = 1;
                        this.initAttributes();
                    } else {
                        this.state = this.getNodeState(newNode);
                        this.currentElement = null;
                        this.currentNode = newNode;
                        if (this.omitComments && this.state == 5) {
                            this.state = this.next();
                        } else {
                            this.appendNodeContent(this.currentNode);
                        }
                    }
                }
            } else {
                this.currentCharacters.clear();
                Node newNode = this.currentElement.getFirstChild();
                if (newNode == null) {
                    this.state = 2;
                } else if (newNode instanceof Element) {
                    ++this.currentLevel;
                    this.state = 1;
                    this.currentElement = (Element)newNode;
                    this.initAttributes();
                } else {
                    this.state = this.getNodeState(newNode);
                    this.currentElement = null;
                    this.currentNode = newNode;
                    if (this.omitComments && this.state == 5) {
                        this.state = this.next();
                    } else {
                        this.appendNodeContent(this.currentNode);
                    }
                }
            }
        } else {
            Node newNode = this.currentNode.getNextSibling();
            if (newNode == null) {
                newNode = this.currentNode.getParentNode();
                if (newNode instanceof Element) {
                    this.currentElement = (Element)newNode;
                    this.currentNode = null;
                    this.state = 2;
                }
            } else if (newNode instanceof Element) {
                this.state = 1;
                ++this.currentLevel;
                this.currentElement = (Element)newNode;
                this.currentNode = null;
                this.initAttributes();
            } else {
                this.state = this.getNodeState(newNode);
                this.currentNode = newNode;
                if (this.omitComments && this.state == 5) {
                    this.state = this.next();
                } else {
                    this.appendNodeContent(this.currentNode);
                }
            }
        }
        return this.state;
    }

    private void appendNodeContent(Node node) {
        if (this.state == 3) {
            if (this.append) {
                this.currentCharacters.append(node.getNodeValue());
            } else {
                this.currentCharacters.set(node.getNodeValue());
            }
        }
        if (this.state == 5) {
            this.currentCharacters.set(node.getNodeValue());
        }
        if (this.state == 4) {
            this.currentCharacters.set(node.getNodeValue());
        }
    }

    private int getNodeState(Node node) throws ParserException {
        switch (node.getNodeType()) {
            case 3: 
            case 4: 
            case 5: {
                return 3;
            }
            case 8: {
                return 5;
            }
            case 7: {
                return 4;
            }
        }
        throw new ParserException(" Unrecognized case: " + node.getNodeType(), -1, 0);
    }

    public void passChars() throws ParserException {
        while (this.state == 3) {
            this.next();
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) throws ParserException {
    }

    public void writeTo(Writer writer) throws ParserException, IOException {
    }

    private void writeStartEndElement(Writer writer) throws IOException {
        if (this.getState() == 1) {
            writer.write(60);
            CharArray charArr = this.getQNameCharArray();
            writer.write(charArr.getData(), charArr.getOffset(), charArr.getSize());
            writer.write(32);
            Attributes atts = this.getAttributes();
            int i = 0;
            while (i < atts.getLength()) {
                writer.write(atts.getQName(i));
                writer.write("='");
                writer.write(atts.getValue(i));
                writer.write("' ");
                ++i;
            }
            writer.write(62);
        } else {
            writer.write("</");
            CharArray charArr = this.getQNameCharArray();
            writer.write(charArr.getData(), charArr.getOffset(), charArr.getSize());
            writer.write(62);
        }
    }

    private void writeCharsOrComment(Writer writer) throws IOException {
        CharArray charArr = this.getValueCharArray();
        if (this.getState() == 5) {
            writer.write("<!--");
            writer.write(charArr.getData(), charArr.getOffset(), charArr.getSize());
            writer.write("-->");
        } else {
            writer.write(charArr.getData(), charArr.getOffset(), charArr.getSize());
        }
    }

    public static void main(String[] args) throws Exception {
        DocumentBuilderFactoryImpl dbf = new DocumentBuilderFactoryImpl();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse("D:/Problems/webcontxml/web.xml");
        XMLDOMTokenReaderNew xmlReader = new XMLDOMTokenReaderNew(doc.getDocumentElement());
        xmlReader.begin();
        while (xmlReader.getState() != 6) {
            switch (xmlReader.getState()) {
                case 1: {
                    System.out.print("<" + xmlReader.getLocalName() + "{" + xmlReader.getURI() + "}");
                    Attributes attr = xmlReader.getAttributes();
                    int i = 0;
                    while (i < attr.getLength()) {
                        System.out.print(" " + attr.getLocalName(i) + "=[" + attr.getValue(i) + "]");
                        ++i;
                    }
                    System.out.print(">");
                    xmlReader.next();
                    break;
                }
                case 2: {
                    System.out.print("</" + xmlReader.getLocalName() + ">");
                    xmlReader.next();
                    break;
                }
                case 3: {
                    System.out.print(xmlReader.getValue());
                    xmlReader.next();
                    break;
                }
                case 5: {
                    System.out.print("<!--" + xmlReader.getValue() + "-->");
                    xmlReader.next();
                    break;
                }
            }
        }
        System.out.println(xmlReader.getCurrentLevel());
    }
}

