/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.pool;

import com.sap.engine.lib.xml.parser.helpers.Reference;

public final class ReferencePool {
    private static final int MAX_SIZE = 1000;
    private int initialSize;
    private int resizeStep = 100;
    private int pos;
    private Reference[] arrayOfObjects;
    private Reference temp;

    public ReferencePool(int initSize, int step) {
        if (step < 1 || initSize < 1) {
            throw new IllegalArgumentException("Wrong value of initialSize or resizeStep parameter");
        }
        this.initialSize = initSize;
        this.resizeStep = step;
        this.arrayOfObjects = new Reference[this.initialSize];
        int i = 0;
        while (i < this.initialSize) {
            this.arrayOfObjects[i] = new Reference();
            ++i;
        }
        this.pos = this.initialSize - 1;
    }

    public Reference getObject() {
        if (this.pos < 0) {
            if (this.arrayOfObjects.length >= 1000) {
                return new Reference();
            }
            this.autoResize();
        }
        return this.arrayOfObjects[this.pos--];
    }

    public void releaseObject(Reference obj) {
        if (this.pos < this.arrayOfObjects.length - 1) {
            ++this.pos;
            this.arrayOfObjects[this.pos] = obj;
        }
    }

    private void autoResize() {
        Reference[] tempArr = new Reference[this.arrayOfObjects.length + this.resizeStep];
        int i = 0;
        while (i < this.resizeStep) {
            tempArr[i] = new Reference();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.arrayOfObjects.length) {
            tempArr[i2 + this.resizeStep] = this.arrayOfObjects[i2];
            ++i2;
        }
        this.arrayOfObjects = tempArr;
        this.pos = this.resizeStep - 1;
    }
}

