/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.pool;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import java.io.Serializable;

public final class CharArrayPool
implements Serializable {
    private static final int MAX_SIZE = 1000;
    private int initialSize;
    private int resizeStep = 100;
    public int pos;
    private CharArray[] arrayOfObjects;
    private CharArray temp;

    public int getPos() {
        return this.pos;
    }

    public void releasePool() {
        this.pos = this.arrayOfObjects.length - 1;
    }

    public CharArrayPool(int initSize, int step) {
        if (initSize > 1000) {
            initSize = 1000;
        }
        if (step < 1 || initSize < 1) {
            throw new IllegalArgumentException("Wrong value of initialSize or resizeStep parameter");
        }
        this.initialSize = initSize;
        this.resizeStep = step;
        this.arrayOfObjects = new CharArray[this.initialSize];
        this.pos = this.initialSize - 1;
    }

    public CharArray getObject() {
        if (this.pos < 0) {
            if (this.arrayOfObjects.length >= 1000) {
                return new CharArray();
            }
            this.autoResize();
        }
        if (this.arrayOfObjects[this.pos] == null) {
            this.arrayOfObjects[this.pos] = new CharArray();
        }
        return this.arrayOfObjects[this.pos--];
    }

    public void releaseObject(CharArray obj) {
        if (this.pos < this.arrayOfObjects.length - 1) {
            ++this.pos;
            this.arrayOfObjects[this.pos] = obj;
        }
    }

    public void release() {
        int i = 0;
        while (i < this.pos) {
            this.arrayOfObjects[i] = null;
            ++i;
        }
    }

    public void releaseAllObjects() {
        this.pos = this.arrayOfObjects.length - 1;
    }

    private void autoResize() {
        CharArray[] tempArr = new CharArray[this.arrayOfObjects.length + this.resizeStep];
        int i = 0;
        while (i < this.arrayOfObjects.length) {
            tempArr[i + this.resizeStep] = this.arrayOfObjects[i];
            ++i;
        }
        this.arrayOfObjects = tempArr;
        this.pos = this.resizeStep - 1;
        this.resizeStep *= 2;
    }
}

