/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.helpers;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Encoding;

public class SingleByteEncoding
extends Encoding {
    private char[] mapping = null;
    private CharArray name = new CharArray();
    private boolean allCharsMapping = false;

    public SingleByteEncoding(char[] mapping, CharArray name, boolean allCharsMapping) {
        this.mapping = mapping;
        this.name = name;
        name.setStatic();
        this.allCharsMapping = allCharsMapping;
    }

    public SingleByteEncoding(char[] mapping, CharArray name) {
        this(mapping, name, false);
    }

    public int process(byte ch) {
        if (ch < 0) {
            return this.mapping[256 + ch];
        }
        if (this.allCharsMapping) {
            return this.mapping[ch];
        }
        return ch;
    }

    public int reverseEncode(byte[] result, int ch) {
        int i = 127;
        while (i <= 255) {
            if (this.mapping[i] == ch) {
                result[0] = (byte)i;
                return 1;
            }
            ++i;
        }
        return -1;
    }

    public CharArray getName() {
        return this.name;
    }
}

