/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.handlers;

import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.XMLParserConstants;
import com.sap.engine.lib.xml.parser.handlers.EmptyDocHandler;
import com.sap.engine.lib.xml.parser.handlers.INamespaceHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xslt.NamespaceManager;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public final class NamespaceHandlerEx
implements INamespaceHandler {
    protected XMLParser parent = null;
    protected static final CharArray defaultPrefixName = new CharArray("<<<>>>").setStatic();
    protected CharArray defaultPrefixMapping = CharArray.EMPTY;
    protected Stack defaultUri = new Stack();
    protected int level = 0;
    protected Hashtable hashNS = new Hashtable();
    protected Vector nsLevels = new Vector();
    private Stack stIsMappedRes = null;

    public NamespaceHandlerEx(XMLParser parent) {
        defaultPrefixName.bufferHash();
        this.reuse(parent);
    }

    public INamespaceHandler reuse(XMLParser parent) {
        this.parent = parent;
        this.level = 0;
        this.nsLevels.clear();
        this.hashNS.clear();
        this.defaultUri.clear();
        this.addNamespace(XMLParserConstants.crXML, XMLParserConstants.caXMLNamespace);
        this.addNamespace(XMLParserConstants.caXMLNS, XMLParserConstants.crXMLNSNamespace);
        this.addNamespace(defaultPrefixName, CharArray.EMPTY);
        HashSet<CharArray> prefixes = new HashSet<CharArray>();
        prefixes.add(XMLParserConstants.crXML);
        prefixes.add(XMLParserConstants.caXMLNS);
        prefixes.add(defaultPrefixName);
        this.nsLevels.add(this.level, prefixes);
        this.defaultPrefixMapping = CharArray.EMPTY;
        this.levelUp();
        return this;
    }

    public void print() {
    }

    public void addDefault(CharArray uri) {
        this.add(defaultPrefixName, uri.copy());
    }

    public CharArray getDefault() {
        return this.get(defaultPrefixName);
    }

    public CharArray get(CharArray prefix) {
        if (prefix == null || prefix.length() == 0) {
            return this.defaultPrefixMapping;
        }
        Stack stackURIs = (Stack)this.hashNS.get(prefix);
        if (stackURIs != null) {
            return (CharArray)stackURIs.peek();
        }
        return CharArray.EMPTY;
    }

    public CharArray getAttr(CharArray prefix) {
        CharArray result = CharArray.EMPTY;
        Stack stackURIs = (Stack)this.hashNS.get(prefix);
        if (stackURIs != null) {
            result = (CharArray)stackURIs.peek();
        }
        return result;
    }

    public CharArray isMapped(CharArray prefix) throws Exception {
        if (prefix == null || prefix.length() == 0) {
            return this.defaultPrefixMapping;
        }
        try {
            return (CharArray)((Stack)this.hashNS.get(prefix)).peek();
        }
        catch (Exception e) {
            throw new Exception("XMLParser: Prefix '" + prefix + "' is not mapped to a namespace");
        }
    }

    public CharArray isMappedAttr(CharArray prefix) throws Exception {
        if (prefix != null && prefix.length() > 0) {
            this.stIsMappedRes = (Stack)this.hashNS.get(prefix);
            if (this.stIsMappedRes != null) {
                return (CharArray)this.stIsMappedRes.peek();
            }
            throw new Exception("XMLParser: Prefix '" + prefix + "' is not mapped to a namespace");
        }
        return CharArray.EMPTY;
    }

    public void add(CharArray prefix, CharArray uri) {
        if (!prefix.getStatic()) {
            prefix = prefix.copy();
        }
        if (!uri.getStatic()) {
            uri = uri.copy();
        }
        this.addNamespace(prefix, uri);
        if (this.nsLevels.size() > this.level) {
            HashSet<CharArray> prefixes = (HashSet<CharArray>)this.nsLevels.get(this.level);
            if (prefixes != null) {
                prefixes.add(prefix);
            } else {
                prefixes = new HashSet<CharArray>();
                prefixes.add(prefix);
                this.nsLevels.set(this.level, prefixes);
            }
        } else {
            HashSet<CharArray> prefixes = new HashSet<CharArray>();
            prefixes.add(prefix);
            this.nsLevels.setSize(this.level + 1);
            this.nsLevels.set(this.level, prefixes);
        }
    }

    public void levelUp() {
        ++this.level;
    }

    public void levelDown() throws Exception {
        --this.level;
        if (this.nsLevels.size() > this.level) {
            Set prefixes = (Set)this.nsLevels.get(this.level);
            if (prefixes != null) {
                Iterator itor = prefixes.iterator();
                while (itor.hasNext()) {
                    CharArray prefix = (CharArray)itor.next();
                    this.removeLast(prefix);
                }
                prefixes = null;
            }
            this.nsLevels.remove(this.level);
        }
    }

    public void findNamespaceNodes(Element el, NamespaceManager nsmanager) {
        NamedNodeMap nm = el.getAttributes();
        int i = 0;
        while (i < nm.getLength()) {
            Attr attr = (Attr)nm.item(i);
            String prefix = attr.getPrefix();
            if (prefix == null) {
                prefix = "";
            }
            if (prefix.equals("xmlns")) {
                this.add(new CharArray(attr.getLocalName()), new CharArray(attr.getValue()));
                if (nsmanager != null) {
                    nsmanager.put(attr.getValue());
                }
            } else if (prefix.length() == 0 && attr.getLocalName().equals("xmlns")) {
                this.addDefault(new CharArray(attr.getValue()));
                if (nsmanager != null) {
                    nsmanager.put(attr.getValue());
                }
            }
            ++i;
        }
    }

    public Hashtable getNamespaceMappings() {
        Hashtable<CharArray, String> mappings = new Hashtable<CharArray, String>();
        Enumeration enum1 = this.hashNS.keys();
        while (enum1.hasMoreElements()) {
            Stack uri;
            Object prefix = enum1.nextElement();
            if (prefix == XMLParserConstants.crXML || prefix == XMLParserConstants.caXMLNS || (uri = (Stack)this.hashNS.get(prefix)) == null || uri.isEmpty()) continue;
            mappings.put(prefix.equals(defaultPrefixName) ? CharArray.EMPTY : prefix, ((CharArray)uri.peek()).getString());
        }
        return mappings;
    }

    protected void addNamespace(CharArray prefix, CharArray uri) {
        Stack<CharArray> stackURIs = (Stack<CharArray>)this.hashNS.get(prefix);
        if (stackURIs != null) {
            stackURIs.push(uri);
            if (prefix == defaultPrefixName) {
                this.defaultPrefixMapping = uri;
            }
        } else {
            stackURIs = new Stack<CharArray>();
            stackURIs.push(uri);
            this.hashNS.put(prefix, stackURIs);
        }
    }

    protected CharArray removeLast(CharArray prefix) {
        CharArray result = null;
        Stack stackURIs = (Stack)this.hashNS.get(prefix);
        if (stackURIs != null) {
            result = (CharArray)stackURIs.pop();
            if (prefix == defaultPrefixName) {
                this.defaultPrefixMapping = (CharArray)stackURIs.peek();
            }
            if (stackURIs.empty()) {
                this.hashNS.remove(prefix);
                stackURIs = null;
            }
        }
        return result;
    }

    protected void removePrefix(CharArray prefix) {
    }

    public int getLevel() {
        return this.level;
    }

    public static void main(String[] args) throws Exception {
        XMLParser pp = new XMLParser();
        EmptyDocHandler eh = new EmptyDocHandler();
        pp.setSoapProcessing(true);
        int iter = 50;
        long a = System.currentTimeMillis();
        int i = 0;
        while (i < iter) {
            pp.parse("D:/develop/xmls/nstestBasic.xml", (DocHandler)eh);
            ++i;
        }
        long b = System.currentTimeMillis() - a;
        System.out.println("Elapsed time: " + b + " ms");
    }
}

