/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.dtd;

import com.sap.engine.lib.xml.parser.AbstractXMLParser;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.dtd.DTDElement;
import com.sap.engine.lib.xml.parser.dtd.State;
import com.sap.engine.lib.xml.parser.dtd.ValidationException;
import com.sap.engine.lib.xml.parser.dtd.Warning;
import com.sap.engine.lib.xml.parser.handlers.EmptyDocHandler;
import com.sap.engine.lib.xml.parser.helpers.AdvancedXMLStreamReader;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Entity;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.SAXNotSupportedException;

public final class XMLValidator {
    AdvancedXMLStreamReader reader = null;
    CharArray rootElementName = new CharArray();
    AbstractXMLParser owner = null;
    boolean calledStartDTD = false;
    boolean calledEndDTD = false;
    boolean processingAttList = false;
    boolean startedRoot = false;
    boolean endedRoot = false;
    Hashtable elems = new Hashtable(11);
    HashSet notations = new HashSet(11);
    HashSet entities = new HashSet(11);
    HashSet mentionedElementNames = new HashSet(11);
    Stack stackElems = new Stack();
    Stack stackStates = new Stack();
    Hashtable options = new Hashtable();
    Vector usedIds = new Vector();
    Vector referencedIds = new Vector();

    public XMLValidator(AbstractXMLParser owner, AdvancedXMLStreamReader reader) {
        this.reader = reader;
        this.owner = owner;
        this.init();
    }

    public XMLValidator(AbstractXMLParser owner) {
        this.owner = owner;
        this.init();
    }

    void init() {
        this.options.put("http://inqmy.com/dtd-validation/printWarnings", Boolean.FALSE);
        this.options.put("http://inqmy.com/dtd-validation/reportWarnings", Boolean.TRUE);
        this.options.put("http://inqmy.com/dtd-validation/throwWarnings", Boolean.FALSE);
        this.options.put("http://inqmy.com/dtd-validation/warnAttributeBeforeElement", Boolean.TRUE);
        this.options.put("http://inqmy.com/dtd-validation/warnMoreThanOneAttList", Boolean.TRUE);
        this.options.put("http://inqmy.com/dtd-validation/warnMoreThanOneAttribute", Boolean.TRUE);
        this.options.put("http://inqmy.com/dtd-validation/warnUndefinedIdRefs", Boolean.TRUE);
        this.options.put("http://inqmy.com/dtd-validation/warnDuplicatesInEnumerationAttributes", Boolean.TRUE);
        this.options.put("http://inqmy.com/dtd-validation/warnDuplicatesInNotationAttributes", Boolean.TRUE);
        this.options.put("http://inqmy.com/dtd-validation/warnElementMentionedButNotDeclared", Boolean.TRUE);
        this.options.put("http://inqmy.com/dtd-validation/warnNonDeterministicContentModel", Boolean.FALSE);
    }

    public void reuse() {
        this.reader = null;
        this.rootElementName.clear();
        this.calledStartDTD = false;
        this.calledEndDTD = false;
        this.processingAttList = false;
        this.startedRoot = false;
        this.endedRoot = false;
        this.elems.clear();
        this.notations.clear();
        this.entities.clear();
        this.mentionedElementNames.clear();
        this.stackElems.clear();
        this.stackStates.clear();
        this.usedIds.clear();
        this.referencedIds.clear();
    }

    void printFeatureValues() {
        Iterator i = this.options.keySet().iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            System.out.println(s + " -> " + (Boolean)this.options.get(s));
        }
    }

    public void setFeature(String s, boolean b) throws SAXNotSupportedException {
        if (!this.options.containsKey(s)) {
            throw new SAXNotSupportedException(s);
        }
        this.options.put(s, new Boolean(b));
    }

    public boolean getFeature(String s) throws SAXNotSupportedException {
        if (!this.options.containsKey(s)) {
            throw new SAXNotSupportedException(s);
        }
        return (Boolean)this.options.get(s);
    }

    boolean getFeatureV(String s) throws ValidationException {
        if (!this.options.containsKey(s)) {
            throw new ValidationException(this, "Option not supported: " + s);
        }
        return (Boolean)this.options.get(s);
    }

    public void setXMLReader(AdvancedXMLStreamReader r) {
        this.reader = r;
    }

    public void startElement(String uriString, CharArray localName, CharArray qName, Vector attList) throws ValidationException {
        localName = localName.copy();
        qName = qName.copy();
        if (!this.calledEndDTD) {
            throw new ValidationException(this, "There is no DTD defined");
        }
        if (this.endedRoot) {
            throw new ValidationException(this, "Root element already ended");
        }
        DTDElement f = (DTDElement)this.elems.get(qName);
        if (f == null) {
            throw new ValidationException(this, "Wrong tag <" + qName + ">. (Element not declared in DTD, " + qName + ")");
        }
        if (!this.startedRoot) {
            if (!qName.equals(this.rootElementName)) {
                throw new ValidationException(this, "Root element must be " + this.rootElementName);
            }
            this.startedRoot = true;
        } else {
            DTDElement e = (DTDElement)this.stackElems.peek();
            switch (e.spec) {
                case 4: {
                    State x = (State)this.stackStates.pop();
                    x = x.searchFor(qName);
                    if (x == null) {
                        throw new ValidationException(this, "Unexpected element, " + qName + ". It cannot appear here according to the content model of " + e.name);
                    }
                    this.stackStates.push(x);
                    break;
                }
                case 3: {
                    if (e.mixedChildren == null) {
                        throw new ValidationException(this, "Check whether tag <" + e.name + "> is properly closed. (The element <" + e.name + "> cannot have sub-elements, because it is of type (#PCDATA))");
                    }
                    if (e.mixedChildren.contains(qName)) break;
                    throw new ValidationException(this, "Element " + qName + " not found among the mixed children of element " + e.name);
                }
                case 1: {
                    throw new ValidationException(this, "Element " + e.name + " is defined EMPTY, but contains " + qName);
                }
                case 2: {
                    break;
                }
                default: {
                    throw new ValidationException(this, "DTDElement " + e.name + " has an invalid spec field");
                }
            }
        }
        this.stackElems.push(f);
        f.confirmAttributes(attList);
        if (f.spec == 4) {
            State x = f.automaton.initialState;
            this.stackStates.push(x);
        }
    }

    public void endElement(String uriString, CharArray localName, CharArray qName) throws ValidationException {
        try {
            State x;
            if (!this.calledEndDTD) {
                throw new ValidationException(this, "There is no DTD defined.");
            }
            if (this.endedRoot) {
                throw new ValidationException(this, "Root element already ended.");
            }
            if (this.stackElems.empty()) {
                throw new ValidationException(this, "There is no tag to close.");
            }
            DTDElement e = (DTDElement)this.stackElems.pop();
            if (e.spec == 4 && (x = ((State)this.stackStates.pop()).searchFor(State.FINAL_STATE)) == null) {
                throw new ValidationException(this, "Element '" + e.name + "' cannot be closed here.");
            }
            Object var7_6 = null;
            if (this.stackElems.empty()) {
                this.endedRoot = true;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (this.stackElems.empty()) {
                this.endedRoot = true;
            }
            throw throwable;
        }
    }

    public void startDocument() throws ValidationException {
    }

    public void endDocument() throws ValidationException, SAXNotSupportedException {
        if (!this.calledEndDTD) {
            throw new ValidationException(this, "DTD required.");
        }
        if (this.processingAttList) {
            throw new ValidationException(this, "Unexpected end of file while parsing ATTLIST.");
        }
        if (!this.endedRoot) {
            throw new ValidationException(this, "Some elements haven't been closed.");
        }
        if (this.getFeatureV("http://inqmy.com/dtd-validation/warnUndefinedIdRefs")) {
            Vector v = new Vector();
            v.addAll(this.referencedIds);
            v.removeAll(this.usedIds);
            if (!v.isEmpty()) {
                Warning.issue(this, "Some IDREF or IDREFS attributes have not been used as ID attributes: " + v);
            }
        }
    }

    public Boolean charData(CharArray ca) throws ValidationException {
        if (this.stackElems.empty()) {
            throw new ValidationException(this, "XMLValidator is out of synch because of previous errors.");
        }
        if (ca.isWhitespace()) {
            return ((DTDElement)this.stackElems.peek()).spec == 4 ? Boolean.TRUE : Boolean.FALSE;
        }
        this.someText();
        return Boolean.FALSE;
    }

    public void onCDSect(CharArray textCA) throws ValidationException {
        this.charData(textCA);
        this.someText();
    }

    void someText() throws ValidationException {
        if (!this.startedRoot || this.endedRoot || !this.calledEndDTD) {
            throw new ValidationException(this, "Check whether the open and close tags are properly nested. (CharData is not allowed here.)");
        }
        DTDElement e = (DTDElement)this.stackElems.peek();
        if (e.spec == 1 || e.spec == 4) {
            throw new ValidationException(this, "Check whether the open and close tags are properly nested. (CharData is not allowed here.)");
        }
    }

    public void onDTDElement(CharArray name, CharArray model) throws ValidationException {
        if (!this.calledStartDTD || this.calledEndDTD) {
            throw new ValidationException(this, "A DTD declaration out of DTD.");
        }
        DTDElement e = (DTDElement)this.elems.get(name);
        model.trim();
        if (e != null) {
            if (e.model != null) {
                throw new ValidationException(this, "Element '" + name + "' is defined twice in the DTD.");
            }
            e.setContentSpec(model);
        } else {
            e = new DTDElement(name, this);
            e.setContentSpec(model);
            this.elems.put(new CharArray(name), e);
        }
    }

    public void onDTDAttListStart(CharArray name) throws ValidationException, SAXNotSupportedException {
        if (!this.calledStartDTD || this.calledEndDTD) {
            throw new ValidationException(this, "A DTD declaration out of DTD.");
        }
        if (this.processingAttList) {
            throw new ValidationException(this, "Nested AttLists.");
        }
        if (this.getFeatureV("http://inqmy.com/dtd-validation/warnMoreThanOneAttList") && this.elems.containsKey(name) && ((DTDElement)this.elems.get((Object)name)).hasAttList) {
            Warning.issue(this, "Element '" + name + "' has more than one ATTLIST.");
        }
        if (!this.elems.containsKey(name)) {
            if (this.getFeatureV("http://inqmy.com/dtd-validation/warnAttributeBeforeElement")) {
                Warning.issue(this, "ATTLIST declaration before ELEMENT declaration of element '" + name + "'.");
            }
            DTDElement e = new DTDElement(name, this);
            this.elems.put(name, e);
        }
        this.processingAttList = true;
    }

    public void onDTDAttListItem(CharArray name, CharArray attname, String type, String defDecl, CharArray vAttValue, String note) throws ValidationException, SAXNotSupportedException {
        if (!this.calledStartDTD || this.calledEndDTD) {
            throw new ValidationException(this, "A DTD declaration out of DTD.");
        }
        if (!this.processingAttList) {
            throw new ValidationException(this, "Nested ATTLISTs.");
        }
        DTDElement e = (DTDElement)this.elems.get(name);
        e.addAttribute(attname, new CharArray(type), new CharArray(defDecl), new CharArray(vAttValue), new CharArray(note));
    }

    public void onDTDAttListEnd() throws ValidationException {
        if (!this.calledStartDTD || this.calledEndDTD) {
            throw new ValidationException(this, "A DTD declaration out of DTD.");
        }
        if (!this.processingAttList) {
            throw new ValidationException(this, "Unexpected ATTLIST end.");
        }
        this.processingAttList = false;
    }

    public void onDTDEntity(Entity x) throws ValidationException {
        if (!this.calledStartDTD || this.calledEndDTD) {
            throw new ValidationException(this, "A DTD declaration out of DTD.");
        }
        this.entities.add(new CharArray(x.getName()));
    }

    public void onDTDNotation(CharArray nameCA, CharArray pubCA, CharArray sysCA) throws ValidationException {
        if (!this.calledStartDTD || this.calledEndDTD) {
            throw new ValidationException(this, "A DTD declaration out of DTD.");
        }
        this.notations.add(new CharArray(nameCA));
    }

    public void startDTD(CharArray name, CharArray pubCA, CharArray sysCA) throws ValidationException {
        if (this.calledEndDTD) {
            throw new ValidationException(this, "Only one DTD may be present.");
        }
        this.rootElementName.set(name);
        this.calledStartDTD = true;
    }

    public void endDTD() throws ValidationException, SAXNotSupportedException {
        if (!this.calledStartDTD) {
            throw new ValidationException(this, "DTD must be started before being ended.");
        }
        if (this.calledEndDTD) {
            throw new ValidationException(this, "DTD must be ended at most once.");
        }
        if (!this.elems.containsKey(this.rootElementName)) {
            throw new ValidationException(this, "Root element '" + this.rootElementName + "' does not have" + " an ELEMENT declaration.");
        }
        if (this.getFeatureV("http://inqmy.com/dtd-validation/warnElementMentionedButNotDeclared")) {
            HashSet h = (HashSet)this.mentionedElementNames.clone();
            Enumeration enum1 = this.elems.keys();
            while (enum1.hasMoreElements()) {
                CharArray ca = (CharArray)enum1.nextElement();
                h.remove(ca);
            }
            if (!h.isEmpty()) {
                Warning.issue(this, "Some elements were mentioned in the DTD but were not declared, " + h);
            }
        }
        this.calledEndDTD = true;
    }

    public static void main(String[] args) throws Exception {
        XMLParser p = new XMLParser();
        p.setValidation(true);
        p.parse("c:/box/test7.xml", (DocHandler)new EmptyDocHandler());
    }

    public int getElementContentSpec(CharArray name) {
        DTDElement el = (DTDElement)this.elems.get(name);
        if (el != null) {
            return el.getContentSpec();
        }
        return 0;
    }

    public int getElementContentSpec(String name) {
        DTDElement el = (DTDElement)this.elems.get(name);
        if (el != null) {
            return el.getContentSpec();
        }
        return 0;
    }

    public AbstractXMLParser getOwner() {
        return this.owner;
    }
}

