/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.dtd;

import com.sap.engine.lib.xml.parser.dtd.Automaton;
import com.sap.engine.lib.xml.parser.dtd.DTDAttribute;
import com.sap.engine.lib.xml.parser.dtd.Model;
import com.sap.engine.lib.xml.parser.dtd.State;
import com.sap.engine.lib.xml.parser.dtd.ValidationException;
import com.sap.engine.lib.xml.parser.dtd.Warning;
import com.sap.engine.lib.xml.parser.dtd.XMLValidator;
import com.sap.engine.lib.xml.parser.helpers.Attribute;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.SAXNotSupportedException;

public final class DTDElement {
    public static final int UNSPECIFIED = 0;
    public static final int EMPTY = 1;
    public static final int ANY = 2;
    public static final int MIXED = 3;
    public static final int CHILDREN = 4;
    static final CharArray caAttXMLNS = new CharArray("xmlns:").setStatic();
    XMLValidator validator;
    CharArray name = new CharArray();
    CharArray contentSpec = new CharArray();
    Model model = null;
    int spec = 0;
    Automaton automaton = null;
    Vector mixedChildren = null;
    Hashtable attributes = new Hashtable();
    boolean hasIdAttribute = false;
    boolean hasAttList = false;
    static String[] specStr = new String[]{"UNSPECIFIED", "EMPTY", "ANY", "MIXED", "CHILDREN"};

    DTDElement(CharArray ca, XMLValidator validator) {
        this.name.set(ca);
        this.validator = validator;
    }

    int getContentSpec() {
        return this.spec;
    }

    void setContentSpec(CharArray s) throws ValidationException {
        this.contentSpec.set(s);
        this.model = new Model(this.validator, this.contentSpec);
        if (this.contentSpec.equals("EMPTY")) {
            this.spec = 1;
            return;
        }
        if (this.contentSpec.equals("ANY")) {
            this.spec = 2;
            return;
        }
        if (this.contentSpec.indexOf("#PCDATA") != -1) {
            this.spec = 3;
            char[] v = new char[]{',', '?', '+'};
            int i = 0;
            while (i < v.length) {
                if (this.contentSpec.indexOf(v[i]) != -1) {
                    throw new ValidationException(this.validator, "Mixed content model cannot contain character '" + v[i] + "'.");
                }
                ++i;
            }
            this.model.confirm("(");
            this.model.skipOptionalWhitespace();
            this.model.confirm("#PCDATA");
            this.model.skipOptionalWhitespace();
            int indOfClBr = this.contentSpec.indexOf(')');
            if (indOfClBr == -1) {
                throw new ValidationException(this.validator, "A mixed content model must contain character ')'");
            }
            int indOfAst = this.contentSpec.indexOf('*');
            if (indOfAst != -1) {
                if (indOfAst < indOfClBr) {
                    throw new ValidationException(this.validator, "Character '*' is not allowed to precede character ')' in a mixed content model.");
                }
                if (indOfAst > indOfClBr + 1) {
                    throw new ValidationException(this.validator, "Character '*' must immediately follow character ')' in a mixed content model.");
                }
                this.model.skipOptionalWhitespace();
                if (this.model.currentChar() != ')') {
                    this.model.confirm("|");
                    this.mixedChildren = this.model.getNames('|');
                    this.validator.mentionedElementNames.addAll(this.mixedChildren);
                }
                this.model.confirm(")*");
            } else {
                this.model.confirm(")");
            }
        } else {
            this.spec = 4;
            this.automaton = Automaton.getAutomaton(this.validator, this, this.contentSpec);
            State x = new State();
            x.next1 = this.automaton.initialState;
            this.automaton.initialState = x;
            this.automaton.finalState.name.set(State.FINAL_STATE);
        }
    }

    void addAttribute(CharArray attName, CharArray attType, CharArray attDefDecl, CharArray attDefValue0, CharArray attNote) throws ValidationException, SAXNotSupportedException {
        CharArray attDefValue = new CharArray(attDefValue0);
        attDefValue.trim();
        if (this.attributes.containsKey(attName)) {
            if (this.validator.getFeature("http://inqmy.com/dtd-validation/warnMoreThanOneAttribute")) {
                Warning.issue(this.validator, "Duplicate declaration for attribute '" + attName + "' to element '" + this.name + "'.");
            }
            return;
        }
        DTDAttribute a = new DTDAttribute(this.validator, attName, attType, attDefDecl, attDefValue, this);
        this.attributes.put(new CharArray(attName), a);
        if (attType.equals("ID")) {
            if (this.hasIdAttribute) {
                throw new ValidationException(this.validator, "Element '" + this.name + "' has more than one " + "ID attribute.");
            }
            if (!attDefDecl.equals("#REQUIRED") && !attDefDecl.equals("#IMPLIED")) {
                throw new ValidationException(this.validator, "Attribute '" + attName + "' to element '" + this.name + "' is ID but is neither #REQUIRED, nor #IMPLIED.");
            }
            this.hasIdAttribute = true;
        } else if (!(attType.equals("IDREF") || attType.equals("IDREFS") || attType.equals("ENTITY") || attType.equals("ENTITIES") || attType.equals("NMTOKEN") || attType.equals("NMTOKENS"))) {
            Model model;
            if (attType.equals("NOTATION")) {
                model = new Model(this.validator, attNote);
                model.skipOptionalWhitespace();
                model.confirm("(");
                a.choices = model.getNmTokens('|');
                if (this.validator.getFeatureV("http://inqmy.com/dtd-validation/warnDuplicatesInNotationAttributes") && !CharArray.areDistinct(a.choices)) {
                    Warning.issue(this.validator, "Duplicates in NOTATION " + a);
                }
                model.confirm(")");
            } else if (!attType.equals("CDATA")) {
                if (attType.charAt(0) == '(') {
                    model = new Model(this.validator, attNote);
                    model.skipOptionalWhitespace();
                    model.confirm("(");
                    a.choices = model.getNmTokens('|');
                    if (this.validator.getFeatureV("http://inqmy.com/dtd-validation/warnDuplicatesInEnumerationAttributes") && !CharArray.areDistinct(a.choices)) {
                        Warning.issue(this.validator, "Duplicates in ENUMERATION " + a);
                    }
                    model.confirm(")");
                } else {
                    throw new ValidationException(this.validator, "Unrecognized attribute type, '" + attType + "'.");
                }
            }
        }
        if (attDefValue != null && !attDefValue.equals("")) {
            try {
                a.confirmValue(attDefValue);
            }
            catch (ValidationException e) {
                throw new ValidationException(this.validator, "Attribute default is not valid: " + e.getMessage());
            }
        }
    }

    private void confirmAttribute(CharArray name, CharArray value) throws ValidationException {
        DTDAttribute a = (DTDAttribute)this.attributes.get(name);
        if (a == null && !name.startsWith(caAttXMLNS)) {
            throw new ValidationException(this.validator, "Element '" + this.name + "' has no attribute '" + name + "'");
        }
        if (a != null) {
            a.confirmValue(value);
        }
    }

    void confirmAttributes(Vector v) throws ValidationException {
        Vector<CharArray> supplied = new Vector<CharArray>();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Attribute a = (Attribute)e.nextElement();
            CharArray qNameCA = new CharArray(a.getQNameStr());
            this.confirmAttribute(qNameCA, new CharArray(a.getValueStr()));
            if (supplied.contains(qNameCA)) {
                throw new ValidationException(this.validator, "Attribute '" + qNameCA + "' supplied more than once to element '" + this.name + "'");
            }
            supplied.addElement(qNameCA);
        }
        Enumeration e2 = this.attributes.elements();
        while (e2.hasMoreElements()) {
            DTDAttribute a = (DTDAttribute)e2.nextElement();
            if (!a.defDecl.equals("#REQUIRED") || supplied.contains(a.name)) continue;
            throw new ValidationException(this.validator, "Attribute '" + a.name + "' to element '" + this.name + "' is #REQUIRED but not supplied.");
        }
    }

    public String toString() {
        return "Element(name=" + this.name + ", spec=" + specStr[this.spec] + ")";
    }
}

