/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.binary.util;

import com.sap.engine.lib.xml.parser.binary.util.EnumerationInt;
import com.sap.engine.lib.xml.parser.binary.util.PrimitiveTypeDataStructure;

public class ArrayInt
extends PrimitiveTypeDataStructure {
    protected transient int[] elementData;
    protected int capacityIncrement;

    public ArrayInt(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new int[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public ArrayInt(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public ArrayInt() {
        this(10);
    }

    public ArrayInt(int[] array, int offset, int length, int capacityIncrement) {
        this.elementData = new int[length];
        System.arraycopy(array, offset, this.elementData, 0, length);
        this.capacityIncrement = capacityIncrement;
        this.count = length;
    }

    public ArrayInt(int[] array) {
        this(array, 0, array.length, 0);
    }

    public void clear() {
        this.removeAllElements();
    }

    public void add(int value) {
        this.ensureCapacity(this.count + 1);
        this.elementData[this.count++] = value;
    }

    public EnumerationInt elements() {
        return new EnumerationInt(){
            private int counter = 0;

            public boolean hasMoreElements() {
                return this.counter < ArrayInt.this.count;
            }

            public int nextElement() {
                return ArrayInt.this.elementData[this.counter++];
            }
        };
    }

    protected void ensureCapacity(int minCapacity) {
        int capacity = this.elementData.length;
        if (minCapacity > capacity) {
            int n = capacity = this.capacityIncrement > 0 ? capacity + this.capacityIncrement : capacity << 1;
            if (capacity < minCapacity) {
                capacity = minCapacity;
            }
            int[] newData = new int[capacity];
            System.arraycopy(this.elementData, 0, newData, 0, this.count);
            this.elementData = newData;
        }
    }

    public void removeAllElements() {
        this.count = 0;
    }
}

