/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.binary.handlers;

import com.sap.engine.lib.xml.parser.XMLParserConstants;
import com.sap.engine.lib.xml.parser.binary.common.MappingData;
import com.sap.engine.lib.xml.parser.binary.exceptions.XmlBinaryException;
import com.sap.engine.lib.xml.parser.binary.pools.MappingDataPool;
import com.sap.engine.lib.xml.parser.binary.util.ArrayInt;
import com.sap.engine.lib.xml.parser.binary.util.HashMapObjectIntPositive;
import com.sap.engine.lib.xml.parser.binary.util.HashMapObjectObject;
import com.sap.engine.lib.xml.parser.binary.util.LinkedList;
import com.sap.engine.lib.xml.parser.binary.util.Stack;
import com.sap.engine.lib.xml.parser.binary.util.iterators.RootIterator;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import java.util.Vector;

public class BinaryNamespaceHandler {
    public final CharArray defaultPrefixName = new CharArray("<<<>>>");
    protected HashMapObjectObject hashPrefix;
    protected HashMapObjectObject hashURI;
    protected HashMapObjectIntPositive hashMapping;
    protected MappingData[] mapData = new MappingData[65536];
    protected Vector prefixLevels;
    protected Vector uriLevels;
    protected Vector mapLevels;
    protected MappingDataPool mappingPool;
    protected int level;
    protected int mappingID;
    private MappingData mappingData;

    public BinaryNamespaceHandler() {
        this.init();
        this.addInitial();
    }

    public void init() {
        this.level = 0;
        this.mappingID = 1;
        this.hashPrefix = new HashMapObjectObject();
        this.hashURI = new HashMapObjectObject();
        this.hashMapping = new HashMapObjectIntPositive();
        this.prefixLevels = new Vector();
        this.uriLevels = new Vector();
        this.mapLevels = new Vector();
        this.mappingPool = new MappingDataPool(100, 100);
        this.mappingData = new MappingData();
    }

    public void clear() {
        this.hashPrefix.clear();
        this.hashURI.clear();
        this.hashMapping.clear();
        this.prefixLevels.clear();
        this.uriLevels.clear();
        this.mapLevels.clear();
        this.mappingPool.release();
    }

    public void reuse() {
        this.level = 0;
        this.mappingID = 1;
        this.hashPrefix.clear();
        this.hashURI.clear();
        this.hashMapping.clear();
        this.prefixLevels.clear();
        this.uriLevels.clear();
        this.mapLevels.clear();
        this.mappingPool.releaseAllObjects();
        this.mappingData.prefix = null;
        this.mappingData.uri = null;
        this.addInitial();
    }

    protected void addInitial() {
        try {
            this.add(XMLParserConstants.crXML, XMLParserConstants.caXMLNamespace);
            this.add(XMLParserConstants.caXMLNS, XMLParserConstants.crXMLNSNamespace);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.levelUp();
    }

    public void addDefault(CharArray uri) throws XmlBinaryException {
        this.add(this.defaultPrefixName, uri, -1);
    }

    public void addDefault(CharArray uri, int mapID) throws XmlBinaryException {
        this.add(this.defaultPrefixName, uri, mapID);
    }

    public CharArray getDefault() {
        return this.getURI(this.defaultPrefixName);
    }

    public CharArray getPrefix(CharArray uri) {
        Stack prefixes;
        CharArray result = CharArray.EMPTY;
        if ((uri != null || uri.length() > 0) && (prefixes = (Stack)this.hashURI.get(uri)) != null && prefixes.size() > 0) {
            result = (CharArray)prefixes.top();
        }
        return result;
    }

    public CharArray getURI(CharArray prefix) {
        CharArray result = CharArray.EMPTY;
        if (prefix == null || prefix.length() == 0) {
            result = this.getDefault();
        } else {
            Stack uris = (Stack)this.hashPrefix.get(prefix);
            if (uris != null && uris.size() > 0) {
                result = (CharArray)uris.top();
            }
        }
        return result;
    }

    public CharArray getAttr(CharArray prefix) {
        CharArray result = CharArray.EMPTY;
        Stack uris = (Stack)this.hashPrefix.get(prefix);
        if (uris != null && uris.size() > 0) {
            result = (CharArray)uris.top();
        }
        return result;
    }

    public boolean isPrefixMapped(CharArray prefix) {
        boolean result = false;
        if (prefix != null && prefix.length() > 0) {
            Stack uris = (Stack)this.hashPrefix.get(prefix);
            result = uris != null && uris.size() > 0;
        }
        return result;
    }

    public boolean isUriMapped(CharArray uri) {
        boolean result = false;
        if (uri != null && uri.length() > 0) {
            Stack prefixes = (Stack)this.hashURI.get(uri);
            result = prefixes != null && prefixes.size() > 0;
        }
        return result;
    }

    public void add(CharArray prefix, CharArray uri) throws XmlBinaryException {
        this.add(prefix, uri, -1);
    }

    public void add(CharArray prefix, CharArray uri, int mapID) throws XmlBinaryException {
        this.addNamespace(prefix, uri, mapID);
        this.addLevelItem(this.prefixLevels, prefix);
        this.addLevelItem(this.uriLevels, uri);
        this.addLevelInt(this.mapLevels, this.mappingID);
    }

    protected void addLevelItem(Vector levelItems, Object item) {
        if (levelItems.size() > this.level) {
            LinkedList list = (LinkedList)levelItems.get(this.level);
            if (list != null) {
                list.add(item);
            } else {
                list = new LinkedList();
                list.add(item);
                levelItems.set(this.level, list);
            }
        } else {
            LinkedList list = new LinkedList();
            list.add(item);
            levelItems.setSize(this.level + 1);
            levelItems.add(this.level, list);
        }
    }

    protected void addLevelInt(Vector levelItems, int value) {
        if (levelItems.size() > this.level) {
            ArrayInt array = (ArrayInt)levelItems.get(this.level);
            if (array != null) {
                array.add(value);
            } else {
                array = new ArrayInt();
                array.add(value);
                levelItems.set(this.level, array);
            }
        } else {
            ArrayInt array = new ArrayInt();
            array.add(value);
            levelItems.setSize(this.level + 1);
            levelItems.add(this.level, array);
        }
    }

    public void levelUp() {
        ++this.level;
    }

    public void levelDown() throws Exception {
        ArrayInt array;
        RootIterator itor;
        LinkedList list;
        if (this.level < 0) {
            return;
        }
        if (this.prefixLevels.size() > this.level && (list = (LinkedList)this.prefixLevels.get(this.level)) != null) {
            itor = list.elementsIterator();
            while (!itor.isAtEnd()) {
                this.removePrefixLast((CharArray)itor.next());
            }
            list.clear();
        }
        if (this.uriLevels.size() > this.level && (list = (LinkedList)this.uriLevels.get(this.level)) != null) {
            itor = list.elementsIterator();
            while (!itor.isAtEnd()) {
                this.removeUriLast((CharArray)itor.next());
            }
            list.clear();
        }
        if (this.mapLevels.size() > this.level && (array = (ArrayInt)this.mapLevels.get(this.level)) != null) {
            array.clear();
        }
        --this.level;
    }

    public ArrayInt getMappingIDs() {
        ArrayInt result = null;
        if (this.level > -1 && this.mapLevels.size() > this.level) {
            result = (ArrayInt)this.mapLevels.get(this.level);
        }
        return result;
    }

    public int getLastMappingID() {
        return this.mappingID;
    }

    public MappingData getMappingData(int id) {
        return this.mapData[id];
    }

    public int getMappingID(CharArray uri) {
        int result = -1;
        Stack prefixes = null;
        prefixes = (Stack)this.hashURI.get(uri);
        if (prefixes != null && prefixes.size() > 0) {
            this.mappingData.prefix = (CharArray)prefixes.top();
            this.mappingData.uri = uri;
            result = this.hashMapping.get(this.mappingData);
        }
        return result;
    }

    public int getMappingID(CharArray prefix, CharArray uri) {
        this.mappingData.prefix = prefix;
        this.mappingData.uri = uri;
        return this.hashMapping.get(this.mappingData);
    }

    protected void addNamespace(CharArray prefix, CharArray uri) throws XmlBinaryException {
        this.addNamespace(prefix, uri, -1);
    }

    protected void addNamespace(CharArray prefix, CharArray uri, int mapID) throws XmlBinaryException {
        Stack prefixes = (Stack)this.hashURI.get(uri);
        if (prefixes != null) {
            prefixes.push(prefix);
        } else {
            prefixes = new Stack();
            prefixes.push(prefix);
            this.hashURI.put(uri, prefixes);
        }
        Stack uris = (Stack)this.hashPrefix.get(prefix);
        if (uris != null) {
            uris.push(uri);
        } else {
            uris = new Stack();
            uris.push(uri);
            this.hashPrefix.put(prefix, uris);
        }
        this.mapPrefixURI(prefix, uri, mapID);
    }

    protected void mapPrefixURI(CharArray prefix, CharArray uri, int mapID) throws XmlBinaryException {
        MappingData mapping;
        if (this.mappingID < 65535) {
            this.mappingID = mapID == -1 ? ++this.mappingID : mapID;
        } else {
            throw new XmlBinaryException("Mapping data ID table exceeded!");
        }
        this.mapData[this.mappingID] = mapping = this.mappingPool.getObject(prefix, uri);
        this.hashMapping.put(mapping, this.mappingID);
    }

    protected CharArray removePrefixLast(CharArray prefix) {
        CharArray result = null;
        Stack uris = (Stack)this.hashPrefix.get(prefix);
        if (uris != null && uris.size() > 0) {
            result = (CharArray)uris.pop();
        }
        return result;
    }

    protected CharArray removeUriLast(CharArray uri) {
        CharArray result = null;
        Stack prefixes = (Stack)this.hashURI.get(uri);
        if (prefixes != null && prefixes.size() > 0) {
            result = (CharArray)prefixes.pop();
        }
        return result;
    }

    protected void removePrefix(CharArray prefix) {
        Stack uris = (Stack)this.hashPrefix.remove(prefix);
        uris.clear();
        Object var2_2 = null;
    }

    protected void removeUri(CharArray uri) {
        Stack prefixes = (Stack)this.hashURI.remove(uri);
        prefixes.clear();
        Object var2_2 = null;
    }

    public void removeMappingID(int mapID) {
        this.removePrefixLast(this.mapData[mapID].prefix);
        this.removeUriLast(this.mapData[mapID].uri);
        this.hashMapping.remove(this.mapData[mapID]);
    }

    protected void clearMapData() {
        int i = 0;
        while (i < this.mapData.length) {
            this.mapData[i] = null;
            ++i;
        }
    }
}

