/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.binary;

import com.sap.engine.lib.xml.parser.XMLParserConstants;
import com.sap.engine.lib.xml.parser.binary.exceptions.XmlBinaryException;
import com.sap.engine.lib.xml.parser.binary.handlers.BinaryNamespaceHandler;
import com.sap.engine.lib.xml.parser.binary.util.ArrayInt;
import com.sap.engine.lib.xml.parser.binary.util.EnumerationInt;
import com.sap.engine.lib.xml.parser.binary.util.HashMapObjectIntPositive;
import com.sap.engine.lib.xml.parser.binary.util.HashMapObjectObject;
import com.sap.engine.lib.xml.parser.handlers.EncodingHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Encoding;
import com.sap.engine.lib.xml.parser.pool.CharArrayPool;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.NoSuchElementException;

public final class BinaryXmlWriter {
    public static final int NO_NAMESPACE_ID = 1;
    public static final int START_ID_VALUE = 2;
    public static final int MAX_ID_VALUE = 65535;
    protected OutputStream stream;
    protected CharArray dataBuffer;
    protected CharArrayPool dataPool;
    protected HashMapObjectIntPositive hashData;
    protected HashMapObjectObject bufferData;
    protected BinaryNamespaceHandler nsHandler;
    protected int currentID;
    protected int prefixID;
    private EncodingHandler encodingHandler = new EncodingHandler();
    private Encoding encoding = this.encodingHandler.getEncoding(new CharArray("UTF-8"));
    private byte[] encodingBuff = new byte[10];

    public BinaryXmlWriter(OutputStream output) {
        this.stream = new BufferedOutputStream(output);
        this.init();
    }

    public void init() {
        this.dataBuffer = new CharArray(500, 500);
        this.dataPool = new CharArrayPool(100, 100);
        this.hashData = new HashMapObjectIntPositive();
        this.bufferData = new HashMapObjectObject();
        this.nsHandler = new BinaryNamespaceHandler();
        this.currentID = 1;
        this.prefixID = 0;
    }

    public void clear() {
        this.dataBuffer.clear();
        this.dataPool.release();
        this.hashData.clear();
        this.bufferData.clear();
        this.nsHandler.clear();
    }

    public void reuse(OutputStream output) {
        this.stream = new BufferedOutputStream(output);
        this.dataBuffer.setSize(0);
        this.dataPool.releaseAllObjects();
        this.hashData.clear();
        this.bufferData.clear();
        this.nsHandler.reuse();
        this.currentID = 1;
        this.prefixID = 0;
    }

    public void flush() {
        try {
            this.stream.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void close() {
        try {
            this.stream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String lookupPrefix(String nsURI) {
        return this.nsHandler.getPrefix(this.bufferData(nsURI)).getStringFast();
    }

    public String lookupNamespace(String prefix) {
        return this.nsHandler.getURI(this.bufferData(prefix)).getStringFast();
    }

    public CharArray lookupPrefix(CharArray nsURI) {
        return this.nsHandler.getPrefix(nsURI);
    }

    public CharArray lookupNamespace(CharArray prefix) {
        return this.nsHandler.getURI(prefix);
    }

    public void addNamespaceMapping(String prefix, String uri) {
        CharArray nsPrefix = this.bufferData(prefix);
        CharArray nsURI = this.bufferData(uri);
        if (!this.nsHandler.isUriMapped(nsURI) || !this.nsHandler.isPrefixMapped(nsPrefix)) {
            try {
                this.nsHandler.add(nsPrefix, nsURI);
                int mappingID = this.nsHandler.getLastMappingID();
                int prefixID = this.prepareRegisterData(nsPrefix);
                int uriID = this.prepareRegisterData(nsURI);
                this.writePrefixMappingEntry(mappingID, prefixID, uriID);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void addNamespaceMapping(CharArray prefix, CharArray uri) {
        if (!this.nsHandler.isUriMapped(uri) || !this.nsHandler.isPrefixMapped(prefix)) {
            try {
                this.nsHandler.add(prefix, uri);
                int mappingID = this.nsHandler.getLastMappingID();
                int prefixID = this.prepareRegisterData(prefix);
                int uriID = this.prepareRegisterData(uri);
                this.writePrefixMappingEntry(mappingID, prefixID, uriID);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void writeAttribute(String localName, String value) throws XmlBinaryException, IllegalArgumentException, IOException {
        if (localName == null || localName.equals("") || value == null) {
            throw new IllegalArgumentException("Invalid localname or value applied!");
        }
        int localNameID = this.prepareRegisterData(this.bufferData(localName));
        this.writeAttributeEntry(localNameID, this.bufferData(value));
    }

    public void writeAttribute(CharArray localName, CharArray value) throws XmlBinaryException, IllegalArgumentException, IOException {
        if (localName == null || localName.equals("") || value == null) {
            throw new IllegalArgumentException("Invalid localname or value applied!");
        }
        int localNameID = this.prepareRegisterData(this.bufferData(localName));
        this.writeAttributeEntry(localNameID, this.bufferData(value));
    }

    public void writeAttribute(String localName, String nsURI, String value) throws XmlBinaryException, IllegalArgumentException, IOException {
        if (nsURI == null || nsURI.equals("")) {
            this.writeAttribute(localName, value);
            return;
        }
        if (localName == null || localName.equals("") || value == null) {
            throw new IllegalArgumentException("Invalid localname or value applied!");
        }
        if ("http://www.w3.org/2000/xmlns/".equals(nsURI)) {
            if (localName.equals("xmlns")) {
                this.prepareDefaultNamespace(this.bufferData(value));
            } else {
                this.prepareNamespace(this.bufferData(value));
            }
            return;
        }
        int localNameID = this.prepareRegisterData(this.bufferData(localName));
        int mappingID = this.prepareNamespace(this.bufferData(nsURI));
        this.writeAttributeEntry(localNameID, mappingID, this.bufferData(value));
    }

    public void writeAttribute(CharArray localName, CharArray nsURI, CharArray value) throws XmlBinaryException, IllegalArgumentException, IOException {
        if (nsURI == null || nsURI.equals("")) {
            this.writeAttribute(localName, value);
            return;
        }
        if (localName == null || localName.equals("") || value == null) {
            throw new IllegalArgumentException("Invalid localname or value applied!");
        }
        if (XMLParserConstants.crXMLNSNamespace.equals(nsURI)) {
            if (localName.equals("xmlns")) {
                this.prepareDefaultNamespace(this.bufferData(value));
            } else {
                this.prepareNamespace(this.bufferData(value));
            }
            return;
        }
        int localNameID = this.prepareRegisterData(this.bufferData(localName));
        int mappingID = this.prepareNamespace(this.bufferData(nsURI));
        this.writeAttributeEntry(localNameID, mappingID, this.bufferData(value));
    }

    public void writeComment(String comment) throws IllegalArgumentException, IOException, XmlBinaryException {
        if (comment == null) {
            throw new IllegalArgumentException("Invalid comment applied!");
        }
        this.writeCommentEntry(this.bufferData(comment));
    }

    public void writeComment(CharArray comment) throws IllegalArgumentException, IOException, XmlBinaryException {
        if (comment == null) {
            throw new IllegalArgumentException("Invalid comment applied!");
        }
        this.writeCommentEntry(this.bufferData(comment));
    }

    public void writeElement(String localName, String value) throws XmlBinaryException, IllegalArgumentException, IOException {
        if (localName == null || localName.equals("") || value == null) {
            throw new IllegalArgumentException("Invalid localname or value applied!");
        }
        this.nsHandler.levelUp();
        int localNameID = this.prepareRegisterData(this.bufferData(localName));
        this.writeElementEntry(localNameID);
        this.writeCharactersEntry(this.bufferData(value));
        this.writeEndElementEntry();
    }

    public void writeElement(CharArray localName, CharArray value) throws XmlBinaryException, IllegalArgumentException, IOException {
        if (localName == null || localName.equals("") || value == null) {
            throw new IllegalArgumentException("Invalid localname or value applied!");
        }
        this.nsHandler.levelUp();
        int localNameID = this.prepareRegisterData(this.bufferData(localName));
        this.writeElementEntry(localNameID);
        this.writeCharactersEntry(this.bufferData(value));
        this.writeEndElementEntry();
    }

    public void writeElement(String localName, String nsURI, String value) throws XmlBinaryException, IllegalArgumentException, IOException {
        if (nsURI == null || nsURI.equals("")) {
            this.writeElement(localName, value);
            return;
        }
        if (localName == null || localName.equals("") || value == null) {
            throw new IllegalArgumentException("Invalid localname or value applied!");
        }
        this.nsHandler.levelUp();
        int localNameID = this.prepareRegisterData(this.bufferData(localName));
        int mappingID = this.prepareNamespace(this.bufferData(nsURI));
        this.writeElementEntry(localNameID, mappingID);
        this.writeCharactersEntry(this.bufferData(value));
        this.writeEndElementEntry();
    }

    public void writeElement(CharArray localName, CharArray nsURI, CharArray value) throws XmlBinaryException, IllegalArgumentException, IOException {
        if (nsURI == null || nsURI.equals("")) {
            this.writeElement(localName, value);
            return;
        }
        if (localName == null || localName.equals("") || value == null) {
            throw new IllegalArgumentException("Invalid localname or value applied!");
        }
        this.nsHandler.levelUp();
        int localNameID = this.prepareRegisterData(this.bufferData(localName));
        int mappingID = this.prepareNamespace(this.bufferData(nsURI));
        this.writeElementEntry(localNameID, mappingID);
        this.writeCharactersEntry(this.bufferData(value));
        this.writeEndElementEntry();
    }

    public void writeStartElement(String localName) throws XmlBinaryException, IllegalArgumentException, IOException {
        if (localName == null || localName.equals("")) {
            throw new IllegalArgumentException("Invalid local name applied!");
        }
        this.nsHandler.levelUp();
        int localNameID = this.prepareRegisterData(this.bufferData(localName));
        this.writeElementEntry(localNameID);
    }

    public void writeStartElement(CharArray localName) throws XmlBinaryException, IllegalArgumentException, IOException {
        if (localName == null || localName.equals("")) {
            throw new IllegalArgumentException("Invalid local name applied!");
        }
        this.nsHandler.levelUp();
        int localNameID = this.prepareRegisterData(this.bufferData(localName));
        this.writeElementEntry(localNameID);
    }

    public void writeStartElement(String localName, String nsURI) throws XmlBinaryException, IllegalArgumentException, IOException {
        if (nsURI == null || nsURI.equals("")) {
            this.writeStartElement(localName);
            return;
        }
        if (localName == null || localName.equals("")) {
            throw new IllegalArgumentException("Invalid local name applied!");
        }
        this.nsHandler.levelUp();
        int localNameID = this.prepareRegisterData(this.bufferData(localName));
        int mappingID = this.prepareNamespace(this.bufferData(nsURI));
        this.writeElementEntry(localNameID, mappingID);
    }

    public void writeStartElement(CharArray localName, CharArray nsURI) throws XmlBinaryException, IllegalArgumentException, IOException {
        if (nsURI == null || nsURI.equals("")) {
            this.writeStartElement(localName);
            return;
        }
        if (localName == null || localName.equals("")) {
            throw new IllegalArgumentException("Invalid local name applied!");
        }
        this.nsHandler.levelUp();
        int localNameID = this.prepareRegisterData(this.bufferData(localName));
        int mappingID = this.prepareNamespace(this.bufferData(nsURI));
        this.writeElementEntry(localNameID, mappingID);
    }

    public void writeEndElement() throws IOException, XmlBinaryException {
        try {
            ArrayInt mappingIDs = this.nsHandler.getMappingIDs();
            if (mappingIDs != null) {
                EnumerationInt itor = mappingIDs.elements();
                while (itor.hasMoreElements()) {
                    this.writeEndPrefixMappingEntry(itor.nextElement());
                }
            }
            this.nsHandler.levelDown();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.writeEndElementEntry();
    }

    public void writeString(String text) throws IllegalArgumentException, IOException, XmlBinaryException {
        if (text == null || text.equals("")) {
            throw new IllegalArgumentException("Invalid text applied!");
        }
        this.writeCharactersEntry(this.bufferData(text));
    }

    public void writeString(CharArray text) throws IllegalArgumentException, IOException, XmlBinaryException {
        if (text == null || text.equals("")) {
            throw new IllegalArgumentException("Invalid text applied!");
        }
        this.writeCharactersEntry(this.bufferData(text));
    }

    public void writeString(char[] chars) throws IOException, XmlBinaryException {
        this.writeString(chars, 0, chars.length);
    }

    public void writeString(char[] chars, int offset, int count) throws IOException, XmlBinaryException {
        this.writeCharactersEntry(this.bufferData(chars, offset, count));
    }

    protected void writeEncodedID(int id) throws IOException {
        int len = this.encoding.reverseEncode(this.encodingBuff, id);
        if (len == -1) {
            throw new IOException("Unable to encode ID in UTF-8!");
        }
        this.stream.write(this.encodingBuff, 0, len);
    }

    protected void writeBytes(byte[] bytes) throws IOException {
        this.writeBytes(bytes, 0, bytes.length);
    }

    protected void writeBytes(byte[] bytes, int index, int count) throws IOException {
        this.stream.write(bytes, index, count);
    }

    protected void writeStringDelimiter() throws IOException {
        this.stream.write(0);
    }

    protected void writeEntryEnd() throws IOException {
        this.stream.write(-1);
    }

    protected void writeCharArray(CharArray value) throws IOException {
        this.writeCharArray(value, true);
    }

    protected void writeCharArray(CharArray value, boolean nullTerminated) throws IOException {
        char[] data = value.getData();
        int begin = value.getOffset();
        int end = begin + value.getSize();
        int i = begin;
        while (i < end) {
            char ch = data[i];
            if (ch < '\u0080') {
                this.stream.write((byte)ch);
            } else {
                int len = this.encoding.reverseEncode(this.encodingBuff, ch);
                if (len == -1) {
                    throw new IOException("Not supported character applied! Unable to write it to the output stream.");
                }
                switch (len) {
                    case 1: {
                        this.stream.write(this.encodingBuff[0]);
                        break;
                    }
                    case 2: {
                        this.stream.write(this.encodingBuff[0]);
                        this.stream.write(this.encodingBuff[1]);
                        break;
                    }
                    default: {
                        int j = 0;
                        while (j < len) {
                            this.stream.write(this.encodingBuff[j]);
                            ++j;
                        }
                        break block0;
                    }
                }
            }
            ++i;
        }
        if (nullTerminated) {
            this.writeStringDelimiter();
        }
    }

    protected void writeRegisterEntry(int id, CharArray value) throws XmlBinaryException, IOException {
        this.stream.write(6);
        this.writeEncodedID(id);
        this.writeCharArray(value, false);
        this.writeEntryEnd();
    }

    protected void writeAttributeEntry(int localNameID, CharArray value) throws IOException, XmlBinaryException {
        this.writeAttributeEntry(localNameID, 1, value);
    }

    protected void writeAttributeEntry(int localNameID, int mappingID, CharArray value) throws XmlBinaryException, IOException {
        this.stream.write(3);
        this.writeEncodedID(localNameID);
        this.writeEncodedID(mappingID);
        this.writeCharArray(value, false);
        this.writeEntryEnd();
    }

    protected void writeCommentEntry(CharArray value) throws XmlBinaryException, IOException {
        this.stream.write(5);
        this.writeCharArray(value, false);
        this.writeEntryEnd();
    }

    protected void writeCharactersEntry(CharArray value) throws XmlBinaryException, IOException {
        this.stream.write(4);
        this.writeCharArray(value, false);
        this.writeEntryEnd();
    }

    protected void writeElementEntry(int localNameID) throws IOException, XmlBinaryException {
        this.writeElementEntry(localNameID, 1);
    }

    protected void writeElementEntry(int localNameID, int mappingID) throws XmlBinaryException, IOException {
        this.stream.write(1);
        this.writeEncodedID(localNameID);
        this.writeEncodedID(mappingID);
    }

    protected void writeEndElementEntry() throws XmlBinaryException, IOException {
        this.stream.write(2);
    }

    protected void writePrefixMappingEntry(int mappingID, int prefixID, int uriID) throws XmlBinaryException, IOException {
        this.stream.write(7);
        this.writeEncodedID(mappingID);
        this.writeEncodedID(prefixID);
        this.writeEncodedID(uriID);
    }

    protected void writeEndPrefixMappingEntry(int mappingID) throws XmlBinaryException, IOException {
        this.stream.write(8);
        this.writeEncodedID(mappingID);
    }

    protected int prepareRegisterData(CharArray data) throws XmlBinaryException, IOException {
        int result = -1;
        try {
            result = this.hashData.get(data);
            if (result == -1) {
                result = this.addHashData(data);
                this.writeRegisterEntry(result, data);
            }
        }
        catch (NoSuchElementException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    protected int prepareNamespace(CharArray uri) throws XmlBinaryException, IOException {
        int result = -1;
        CharArray prefix = null;
        if (!this.nsHandler.isUriMapped(uri)) {
            prefix = this.generatePrefix();
            this.nsHandler.add(prefix, uri);
            result = this.nsHandler.getLastMappingID();
            int prefixID = this.prepareRegisterData(prefix);
            int uriID = this.prepareRegisterData(uri);
            this.writePrefixMappingEntry(result, prefixID, uriID);
        } else {
            result = this.nsHandler.getMappingID(uri);
        }
        return result;
    }

    protected int prepareDefaultNamespace(CharArray uri) {
        int result = -1;
        if (!this.nsHandler.isUriMapped(uri)) {
            try {
                this.nsHandler.addDefault(uri);
                result = this.nsHandler.getLastMappingID();
                int prefixID = this.prepareRegisterData(this.nsHandler.defaultPrefixName);
                int uriID = this.prepareRegisterData(uri);
                this.writePrefixMappingEntry(result, prefixID, uriID);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            result = this.nsHandler.getMappingID(uri);
        }
        return result;
    }

    protected CharArray generatePrefix() {
        return this.bufferData("ns" + String.valueOf(this.prefixID++));
    }

    protected CharArray bufferData(String data) {
        CharArray result = null;
        result = (CharArray)this.bufferData.get(data);
        if (result == null) {
            result = this.dataPool.getObject();
            int offset = this.dataBuffer.getSize();
            this.dataBuffer.append(data);
            result.substring(this.dataBuffer, offset, offset + data.length());
            result.bufferHash();
            this.bufferData.put(data, result);
        }
        return result;
    }

    protected CharArray bufferData(char[] data, int offset, int count) {
        CharArray result = this.dataPool.getObject();
        int bufferOffset = this.dataBuffer.getSize();
        this.dataBuffer.append(data, offset, count);
        result.substring(this.dataBuffer, bufferOffset, bufferOffset + data.length);
        result.bufferHash();
        return result;
    }

    protected CharArray bufferData(CharArray data) {
        if (!data.hashReady) {
            data.bufferHash();
        }
        return data;
    }

    protected int addHashData(CharArray data) throws XmlBinaryException {
        if (this.currentID < 65535) {
            ++this.currentID;
            this.hashData.put(data, this.currentID);
        } else {
            this.hashData.clear();
            this.currentID = 2;
            this.hashData.put(data, this.currentID);
        }
        return this.currentID;
    }
}

