/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser;

import com.sap.engine.lib.xml.parser.NestedSAXParseException;
import com.sap.engine.lib.xml.parser.Parser;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.dtd.ValidationException;
import com.sap.engine.lib.xml.parser.handlers.SAXDocHandler;
import java.io.IOException;
import java.util.Locale;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.LocatorImpl;

public class SAXParser
extends Parser
implements XMLReader,
org.xml.sax.Parser {
    private ContentHandler contentHandler = null;
    private DocumentHandler documentHandler = null;
    private DTDHandler dtdHandler = null;
    private DeclHandler declHandler = null;
    private LexicalHandler lexicalHandler = null;
    private Locale locale = null;
    private SAXDocHandler saxHandler;

    public SAXParser() throws ParserException {
    }

    public SAXParser(XMLParser xmlParser) throws ParserException {
        super(xmlParser);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/declaration-handler")) {
            return this.declHandler;
        }
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.lexicalHandler;
        }
        if (name.equals("http://xml.org/sax/properties/xml-string")) {
            throw new SAXNotSupportedException("");
        }
        throw new SAXNotRecognizedException("");
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/declaration-handler")) {
            this.declHandler = (DeclHandler)value;
        } else if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            this.lexicalHandler = (LexicalHandler)value;
        } else {
            if (name.equals("http://xml.org/sax/properties/xml-string")) {
                throw new SAXNotSupportedException("");
            }
            super.setProperty(name, value);
        }
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public DeclHandler getDeclHandler() {
        return this.declHandler;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
        if (this.saxHandler != null) {
            this.saxHandler.setDTDHandler(handler);
        }
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
        if (this.saxHandler != null) {
            this.saxHandler.setContentHandler(handler);
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.documentHandler = handler;
        if (this.saxHandler != null) {
            this.saxHandler.setDocumentHandler(handler);
        }
    }

    public DocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        String sysId = input.getSystemId();
        String pubId = input.getPublicId();
        this.xmlParser.setSystemId(sysId);
        this.xmlParser.setPublicId(pubId);
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(this.xmlParser);
        }
        if (this.documentHandler != null) {
            this.documentHandler.setDocumentLocator(this.xmlParser);
        }
        try {
            if (this.saxHandler == null) {
                this.saxHandler = new SAXDocHandler();
            }
            this.saxHandler.setLexicalHandler(this.lexicalHandler);
            this.saxHandler.setDocumentHandler(this.documentHandler);
            this.saxHandler.setDeclHandler(this.declHandler);
            this.saxHandler.setContentHandler(this.contentHandler);
            this.saxHandler.setDTDHandler(this.dtdHandler);
            this.saxHandler.setErrorHandler(this.errorHandler);
            super.parse(input, this.saxHandler);
        }
        catch (ParserException e) {
            LocatorImpl loc = new LocatorImpl();
            loc.setPublicId(input.getPublicId());
            loc.setSystemId(e.getSourceID());
            loc.setLineNumber(e.getRow());
            loc.setColumnNumber(e.getCol());
            if (this.contentHandler != null) {
                this.contentHandler.setDocumentLocator(loc);
            }
            if (this.documentHandler != null) {
                this.documentHandler.setDocumentLocator(loc);
            }
            if (this.errorHandler != null) {
                if (e instanceof ValidationException) {
                    this.errorHandler.error(new NestedSAXParseException("Validation Error: " + e, loc, e));
                }
                this.errorHandler.fatalError(new NestedSAXParseException("Fatal Error: " + e, loc, e));
                throw new NestedSAXParseException(e.toString(), loc, e);
            }
            throw new NestedSAXParseException(e.getMessage(), loc, e);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NestedSAXParseException("Generic Exception: ", e);
        }
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

