/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class NestedSAXParseException
extends SAXParseException {
    public static final String WRAPPING = " -> ";
    public static final String TRACE_SEPARATOR = "\t----------------------------------------";
    private Throwable cause;

    public NestedSAXParseException(String message, Locator locator) {
        super(message, locator);
    }

    public NestedSAXParseException(String message, Locator locator, Exception e) {
        super(message, locator, e);
        this.cause = e;
    }

    public NestedSAXParseException(String message, String publicId, String systemId, int lineNumber, int columnNumber) {
        super(message, publicId, systemId, lineNumber, columnNumber);
    }

    public NestedSAXParseException(String message, String publicId, String systemId, int lineNumber, int columnNumber, Exception e) {
        super(message, publicId, systemId, lineNumber, columnNumber, e);
        this.cause = e;
    }

    public NestedSAXParseException(String message, Exception e) {
        this(message, null, e);
    }

    public NestedSAXParseException(Exception e) {
        this(null, null, e);
    }

    public Throwable getCause() {
        return this.cause;
    }

    public final void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public final void printStackTrace(PrintStream out) {
        if (this.cause == null) {
            super.printStackTrace(out);
        } else {
            PrintStream printStream = out;
            synchronized (printStream) {
                out.print(this.toFullString() + WRAPPING);
                this.cause.printStackTrace(out);
                out.println(TRACE_SEPARATOR);
                out.print(this.traceOf(this.cause));
                out.flush();
            }
        }
    }

    public final void printStackTrace(PrintWriter out) {
        if (this.cause == null) {
            super.printStackTrace(out);
        } else {
            PrintWriter printWriter = out;
            synchronized (printWriter) {
                out.print(this.toFullString() + WRAPPING);
                this.cause.printStackTrace(out);
                out.println(TRACE_SEPARATOR);
                out.print(this.traceOf(this.cause));
                out.flush();
            }
        }
    }

    private String traceOf(Throwable th) {
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        super.printStackTrace(pw);
        pw.flush();
        String s = w.toString();
        int p = s.indexOf("\tat");
        if (p != -1) {
            s = s.substring(p);
        }
        return s;
    }

    private final String toFullString() {
        int row;
        StringBuffer buf = new StringBuffer("com.sap.engine.lib.xml.parser.NestedSAXParserException");
        String msg = this.getMessage();
        if (msg != null) {
            buf.append(": " + msg);
        }
        if ((row = super.getLineNumber()) != -1) {
            int col = super.getColumnNumber();
            String systemID = super.getSystemId();
            if (systemID == null) {
                systemID = ":main:";
            }
            buf.append("(");
            buf.append(systemID);
            buf.append(", row=");
            buf.append(row);
            buf.append(", col=");
            buf.append(col);
            buf.append(")");
        }
        return buf.toString();
    }

    public String toString() {
        String str = this.toFullString();
        if (this.cause != null) {
            str = str + WRAPPING + this.cause.toString();
        }
        return str;
    }
}

