/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser;

import java.util.HashSet;
import org.xml.sax.SAXNotSupportedException;

public final class Features {
    public static final String PREFIX_SAX = "http://xml.org/sax/features/";
    public static final String PREFIX_VALIDATION = "http://inqmy.com/dtd-validation/";
    public static final String PREFIX_APACHE = "http://apache.org/xml/features/";
    public static final String FEATURE_SCAN_ONLY_ROOT = "http://sap.com/xml/features/scan-only-root";
    public static final String FEATURE_EXPANDING_REFERENCES = "http://inqmy.com/dom/expanding-references";
    public static final String FEATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    public static final String FEATURE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    public static final String FEATURE_STRING_INTERNING = "http://xml.org/sax/features/string-interning";
    public static final String FEATURE_USE_PROXY = "http://inqmy.org/sax/features/use-proxy";
    public static final String FEATURE_TRIM_WHITESPACES = "http://inqmy.org/dom/features/trim-white-spaces";
    public static final String FEATURE_CLOSE_STREAMS = "http://inqmy.org/xml/features/close-streams";
    public static final String FEATURE_VALIDATION = "http://xml.org/sax/features/validation";
    public static final String FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    public static final String FEATURE_SOAP_DATA = "http://sap.com/xml/soap-input";
    public static final String SCHEMA_AWARENESS = "http://sap.com/xml/schema-awareness";
    public static final String APACHE_SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    public static final String APACHE_DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    public static final String FEATURE_READ_DTD = "http://inqmy.org/sax/features/read-dtd";
    public static final String FEATURE_HTML_MODE = "http://sap.com/xml/html-mode";
    public static final String MAX_REFERENCES = "http://sap.com/xml/max-references";
    public static final String FEATURE_SCHEMA_DOM_VALIDATION = "http://sap.com/xml/schemaDOMValidation";
    public static final String FEATURE_XSD_DOC_VALIDATION = "http://sap.com/xml/validateXSDDoc";
    public static final String FEATURE_BACKWARDS_COMPATIBILITY_MODE = "http://sap.com/xml/features/backwards-compatibility-mode";
    public static final String FEATURE_SCHEMA_CANONICALIZATION_PROCESSING = "http://sap.com/xml/schemaCanonicalizationProcessing";
    public static final HashSet SUPPORTED = new HashSet();
    public static final HashSet RECOGNIZED = new HashSet();
    public static final HashSet POSITIVE_ANSWERS;
    public static final HashSet NEGATIVE_ANSWERS;

    public static boolean createBooleanValue(Object value) throws SAXNotSupportedException {
        if (value == null) {
            throw new SAXNotSupportedException("Attempting to create a feature value from object, whose reference is null.");
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            if (POSITIVE_ANSWERS.contains(value)) {
                return true;
            }
            if (NEGATIVE_ANSWERS.contains(value)) {
                return false;
            }
            throw new SAXNotSupportedException("Attempting to create a feature value from string, whose value '" + value.toString() + "' is not supported.");
        }
        throw new SAXNotSupportedException("Attempting to create a feature value from object, whose class name '" + value.getClass().getName() + "' is not supported.");
    }

    private Features() {
    }

    static {
        SUPPORTED.add(FEATURE_VALIDATION);
        SUPPORTED.add(FEATURE_NAMESPACES);
        SUPPORTED.add(FEATURE_NAMESPACE_PREFIXES);
        SUPPORTED.add(FEATURE_EXTERNAL_GENERAL_ENTITIES);
        SUPPORTED.add(FEATURE_SOAP_DATA);
        SUPPORTED.add(FEATURE_READ_DTD);
        SUPPORTED.add(APACHE_DYNAMIC_VALIDATION);
        SUPPORTED.add(FEATURE_HTML_MODE);
        SUPPORTED.add(FEATURE_TRIM_WHITESPACES);
        SUPPORTED.add(FEATURE_EXPANDING_REFERENCES);
        SUPPORTED.add(FEATURE_SCAN_ONLY_ROOT);
        SUPPORTED.add(FEATURE_USE_PROXY);
        SUPPORTED.add(FEATURE_CLOSE_STREAMS);
        SUPPORTED.add("http://inqmy.com/dtd-validation/printWarnings");
        SUPPORTED.add("http://inqmy.com/dtd-validation/throwWarnings");
        SUPPORTED.add("http://inqmy.com/dtd-validation/warnAttributeBeforeElement");
        SUPPORTED.add("http://inqmy.com/dtd-validation/warnMoreThanOneAttList");
        SUPPORTED.add("http://inqmy.com/dtd-validation/warnMoreThanOneAttribute");
        SUPPORTED.add("http://inqmy.com/dtd-validation/warnUndefinedIdRefs");
        SUPPORTED.add("http://inqmy.com/dtd-validation/warnDuplicatesInEnumerationAttributes");
        SUPPORTED.add("http://inqmy.com/dtd-validation/warnDuplicatesInNotationAttributes");
        SUPPORTED.add("http://inqmy.com/dtd-validation/warnElementMentionedButNotDeclared");
        SUPPORTED.add(SCHEMA_AWARENESS);
        SUPPORTED.add(APACHE_SCHEMA_VALIDATION);
        SUPPORTED.add(FEATURE_XSD_DOC_VALIDATION);
        SUPPORTED.add(MAX_REFERENCES);
        SUPPORTED.add(FEATURE_SCHEMA_DOM_VALIDATION);
        SUPPORTED.add(FEATURE_BACKWARDS_COMPATIBILITY_MODE);
        SUPPORTED.add(FEATURE_SCHEMA_CANONICALIZATION_PROCESSING);
        RECOGNIZED.addAll(SUPPORTED);
        RECOGNIZED.add(FEATURE_EXTERNAL_PARAMETER_ENTITIES);
        RECOGNIZED.add(FEATURE_STRING_INTERNING);
        RECOGNIZED.add("http://inqmy.com/dtd-validation/warnNonDeterministicContentModel");
        POSITIVE_ANSWERS = new HashSet();
        NEGATIVE_ANSWERS = new HashSet();
        POSITIVE_ANSWERS.add("yes");
        NEGATIVE_ANSWERS.add("no");
        POSITIVE_ANSWERS.add("true");
        NEGATIVE_ANSWERS.add("false");
        POSITIVE_ANSWERS.add("1");
        NEGATIVE_ANSWERS.add("0");
    }
}

