/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.names;

public final class EditDistance {
    private int[] d = new int[1024];
    private int la;
    private int lb;
    private int la1;
    private int lb1;

    private int index(int i, int j) {
        return i * this.lb1 + j;
    }

    public void printTable() {
        int i = 0;
        while (i <= this.la) {
            int j = 0;
            while (j <= this.lb) {
                System.out.print(" " + this.d[this.index(i, j)]);
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println();
    }

    public int between(String a, String b) {
        this.la = a.length();
        this.lb = b.length();
        if (this.la == 0) {
            return this.lb;
        }
        if (this.lb == 0) {
            return this.la;
        }
        this.la1 = this.la + 1;
        this.lb1 = this.lb + 1;
        int l = this.la1 * this.lb1;
        if (this.d.length < l) {
            this.d = new int[l];
        }
        int i = 1;
        while (i <= this.la) {
            this.d[this.index((int)i, (int)0)] = 1;
            ++i;
        }
        int j = 1;
        while (j <= this.lb) {
            this.d[this.index((int)0, (int)j)] = 1;
            ++j;
        }
        this.d[this.index((int)0, (int)0)] = 0;
        int i2 = 1;
        while (i2 <= this.la) {
            char cha = a.charAt(i2 - 1);
            int j2 = 1;
            while (j2 <= this.lb) {
                char chb = b.charAt(j2 - 1);
                int x = Math.min(this.d[this.index(i2 - 1, j2)], this.d[this.index(i2, j2 - 1)]) + 1;
                this.d[this.index((int)i2, (int)j2)] = x = Math.min(x, this.d[this.index(i2 - 1, j2 - 1)] + (cha == chb ? 0 : 1));
                ++j2;
            }
            ++i2;
        }
        return this.d[this.index(this.la, this.lb)];
    }

    public static String getMostProbable(String misspelt, String[] dictionary, int delta) {
        try {
            EditDistance editDistance = new EditDistance();
            int indexOfMostProbable = -1;
            int distanceToMostProbable = Integer.MAX_VALUE;
            int i = 0;
            while (i < dictionary.length) {
                int d = editDistance.between(misspelt, dictionary[i]);
                if (d < distanceToMostProbable) {
                    indexOfMostProbable = i;
                    distanceToMostProbable = d;
                }
                ++i;
            }
            return indexOfMostProbable != -1 && distanceToMostProbable <= delta ? dictionary[indexOfMostProbable] : null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

