/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.dom.xpath;

import com.sap.engine.lib.xml.dom.xpath.XPathException;
import java.util.Vector;

public final class XPointerSplitter {
    private XPointerSplitter() {
    }

    public static final void split(String s, Vector schemes, Vector expressions) throws XPathException {
        schemes.clear();
        expressions.clear();
        while ((s = XPointerSplitter.stripLeftWhitespace(s)).length() != 0) {
            int p = s.indexOf(40);
            int q = s.indexOf(41);
            if (p == -1) {
                if (q != -1) {
                    throw new XPathException(1, "Brackets not balanced in an XPointer expression, ')' occurs but '(' does not. expression='" + s + "'");
                }
                schemes.add("(bare)");
                expressions.add(XPointerSplitter.stripRightWhitespace(s));
                return;
            }
            if (q < p) {
                throw new XPathException(1, "Brackets not balanced in an XPointer expression, ')' before '('. expression='" + s + "'");
            }
            int matchingBracket = XPointerSplitter.findMatchingBracket(s, p);
            schemes.add(s.substring(0, p));
            expressions.add(s.substring(p + 1, matchingBracket));
            s = s.substring(matchingBracket + 1);
        }
    }

    private static final String stripLeftWhitespace(String s) {
        int p = 0;
        int ls = s.length();
        while (p < ls) {
            char ch = s.charAt(p);
            if (ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n') break;
            ++p;
        }
        return p == 0 ? s : s.substring(p);
    }

    private static final String stripRightWhitespace(String s) {
        int ls = s.length();
        int p = ls - 1;
        while (p >= 0) {
            char ch = s.charAt(p);
            if (ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n') break;
            --p;
        }
        return p == ls - 1 ? s : s.substring(0, p + 1);
    }

    private static final int findMatchingBracket(String s, int indexOfBracket) throws XPathException {
        int level = 1;
        int i = indexOfBracket + 1;
        int ls = s.length();
        while (i < ls) {
            char ch = s.charAt(i);
            if (ch == '(') {
                ++level;
            } else if (ch == ')' && --level == 0) {
                return i;
            }
            ++i;
        }
        throw new XPathException(1, "Brackets not balanced in an XPointer expression.");
    }

    public static void main(String[] args) throws Exception {
        Vector vSchemes = new Vector();
        Vector vExpressions = new Vector();
        XPointerSplitter.split("xmlns(xs='schema') xpointer(lksd/1/2/3/4)", vSchemes, vExpressions);
        System.out.println(vSchemes);
        System.out.println(vExpressions);
    }
}

