/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.dom;

import com.sap.engine.lib.xml.dom.Base;
import com.sap.engine.lib.xml.dom.DocumentImpl;
import com.sap.engine.lib.xml.dom.NodeListImpl;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class NodeImpl
extends Base
implements Node,
NodeList {
    private static final int INITIAL_N_CHILDREN = 8;
    private Node[] children = null;
    private int nChildren;

    protected final void init() {
        this.nChildren = 0;
    }

    private void ensureChildren() {
        if (this.children == null) {
            this.children = new Node[8];
        }
        if (this.children.length == this.nChildren) {
            Node[] old = this.children;
            this.children = new Node[2 * this.nChildren];
            System.arraycopy(old, 0, this.children, 0, this.nChildren);
        }
    }

    public Node appendChild(Node newChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("DOM: A null child cannot be appended.");
        }
        if (newChild.getNodeType() == 11) {
            DocumentFragment fragment = (DocumentFragment)newChild;
            NodeList list = fragment.getChildNodes();
            int nList = list.getLength();
            Node[] temp = new Node[nList];
            int i = 0;
            while (i < nList) {
                temp[i] = list.item(i);
                ++i;
            }
            int i2 = 0;
            while (i2 < nList) {
                this.appendChild(temp[i2]);
                ++i2;
            }
            return newChild;
        }
        if (newChild.getParentNode() != null && !(newChild instanceof DocumentType)) {
            newChild.getParentNode().removeChild(newChild);
        }
        this.checkChild(newChild);
        Base.checkCompatibleOwnerDocuments(this, newChild);
        if (newChild.getParentNode() != null) {
            newChild.getParentNode().removeChild(newChild);
        }
        this.ensureChildren();
        this.children[this.nChildren] = newChild;
        Base newChildBase = (Base)newChild;
        if (this.nChildren > 0) {
            ((Base)this.children[this.nChildren - 1]).setNextSibling(newChildBase);
            newChildBase.setPreviousSibling(this.children[this.nChildren - 1]);
        }
        newChildBase.setNextSibling(null);
        ++this.nChildren;
        newChildBase.setParent(this);
        return newChild;
    }

    public final NodeList getChildNodes() {
        return this;
    }

    public final Node getFirstChild() {
        if (this.nChildren == 0) {
            return null;
        }
        return this.children[0];
    }

    public final Node getLastChild() {
        if (this.nChildren == 0) {
            return null;
        }
        return this.children[this.nChildren - 1];
    }

    public final boolean hasChildNodes() {
        return this.nChildren != 0;
    }

    public Node insertBefore(Node newChild, Node refChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("DOM: A null child cannot be inserted.");
        }
        if (newChild == refChild) {
            throw new DOMException(3, "Cannot insert a child before itself.");
        }
        if (newChild.getNodeType() == 11) {
            DocumentFragment fragment = (DocumentFragment)newChild;
            NodeList list = fragment.getChildNodes();
            int nList = list.getLength();
            Node[] temp = new Node[nList];
            int i = 0;
            while (i < nList) {
                temp[i] = list.item(i);
                ++i;
            }
            int i2 = 0;
            while (i2 < nList) {
                this.insertBefore(temp[i2], refChild);
                ++i2;
            }
            return newChild;
        }
        if (newChild.getParentNode() != null) {
            newChild.getParentNode().removeChild(newChild);
        }
        this.checkChild(newChild);
        if (refChild == null) {
            this.appendChild(newChild);
            return newChild;
        }
        Document d1 = newChild.getOwnerDocument();
        Document d2 = refChild.getOwnerDocument();
        Document d3 = this.getOwnerDocument();
        if (d3 != null && d1 != null && d1 != d2) {
            throw new DOMException(4, "Cannot insert the newChild (" + Base.nameOfNodeWithArticle(newChild) + ") to this node, the owner documents are incompatible.");
        }
        this.ensureChildren();
        if (newChild.getParentNode() != null) {
            newChild.getParentNode().removeChild(newChild);
        }
        int i = 0;
        while (i < this.nChildren) {
            if (this.children[i] == refChild) {
                System.arraycopy(this.children, i, this.children, i + 1, this.nChildren - i);
                this.children[i] = newChild;
                Base newChildBase = (Base)newChild;
                if (i > 0) {
                    ((Base)this.children[i - 1]).setNextSibling(newChild);
                    newChildBase.setPreviousSibling(this.children[i - 1]);
                } else {
                    ((Base)newChild).setPreviousSibling(null);
                }
                ((Base)this.children[i + 1]).setPreviousSibling(newChild);
                newChildBase.setNextSibling(this.children[i + 1]);
                newChildBase.setParent(this);
                ++this.nChildren;
                return newChild;
            }
            ++i;
        }
        throw new DOMException(8, "The refChild (" + Base.nameOfNodeWithArticle(refChild) + ") is not a child of this node.");
    }

    public final Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException("DOM: Cannot remove a null child.");
        }
        int i = 0;
        while (i < this.nChildren) {
            if (this.children[i] == oldChild) {
                System.arraycopy(this.children, i + 1, this.children, i, this.nChildren - i - 1);
                this.children[this.nChildren - 1] = null;
                if (i > 0) {
                    if (this.children[i - 1] != null) {
                        ((Base)this.children[i - 1]).setNextSibling(this.children[i]);
                    }
                    if (this.children[i] != null) {
                        ((Base)this.children[i]).setPreviousSibling(this.children[i - 1]);
                    }
                } else if (this.children[i] != null) {
                    ((Base)this.children[i]).setPreviousSibling(null);
                }
                if (i < this.nChildren - 2) {
                    ((Base)this.children[i + 1]).setPreviousSibling(this.children[i]);
                    if (this.children[i] != null) {
                        ((Base)this.children[i]).setNextSibling(this.children[i + 1]);
                    }
                } else if (this.children[i] != null && this.children[i] != null) {
                    ((Base)this.children[i]).setNextSibling(null);
                }
                Base oldChildBase = (Base)oldChild;
                oldChildBase.setParent(null);
                oldChildBase.setPreviousSibling(null);
                oldChildBase.setNextSibling(null);
                --this.nChildren;
                return oldChild;
            }
            ++i;
        }
        throw new DOMException(8, "The (" + Base.nameOfNode(oldChild) + ") node you try to remove is not a child of this node.");
    }

    public final void removeChildren(Node firstChild, int length) {
        if (firstChild == null) {
            throw new IllegalArgumentException("DOM: Cannot remove a null child.");
        }
        boolean found = false;
        int i = 0;
        while (i < this.nChildren) {
            if (this.children[i] == firstChild) {
                found = true;
                System.arraycopy(this.children, i + length, this.children, i, this.nChildren - i - length);
                int j = this.nChildren - length;
                while (j < this.nChildren) {
                    Base oldChildBase = (Base)this.children[j];
                    this.children[j] = null;
                    ++j;
                }
                if (i > 0) {
                    if (this.children[i - 1] != null) {
                        ((Base)this.children[i - 1]).setNextSibling(this.children[i]);
                    }
                    if (this.children[i] != null) {
                        ((Base)this.children[i]).setPreviousSibling(this.children[i - 1]);
                    }
                } else if (this.children[i] != null) {
                    ((Base)this.children[i]).setPreviousSibling(null);
                }
                if (i < this.nChildren - 1 - length) {
                    if (this.children[i + 1] != null) {
                        ((Base)this.children[i + 1]).setPreviousSibling(this.children[i]);
                    }
                    if (this.children[i] != null) {
                        ((Base)this.children[i]).setNextSibling(this.children[i + 1]);
                    }
                } else if (this.children[i] != null) {
                    ((Base)this.children[i]).setNextSibling(null);
                }
                this.nChildren -= length;
            }
            ++i;
        }
        if (!found) {
            throw new DOMException(8, "The (" + Base.nameOfNode(firstChild) + ") node you try to remove is not a child of this node.");
        }
    }

    public final Node replaceChild(Node newChild, Node oldChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("DOM: Cannot replace with a null node.");
        }
        if (oldChild == null) {
            throw new IllegalArgumentException("DOM: Cannot replace a null node.");
        }
        if (newChild.getParentNode() != null) {
            newChild.getParentNode().removeChild(newChild);
        }
        this.checkChild(newChild);
        Document d1 = newChild.getOwnerDocument();
        Document d2 = oldChild.getOwnerDocument();
        Document d3 = this.getOwnerDocument();
        if (d1 != null && d2 != null && d1 != d2) {
            throw new DOMException(4, "Cannot replace the oldChild (" + Base.nameOfNodeWithArticle(oldChild) + ") with the newChild (" + Base.nameOfNodeWithArticle(newChild) + "), their owner documents are incompatible.");
        }
        if (d3 != null && d1 != null && d1 != d2) {
            throw new DOMException(4, "Cannot replace with the newChild (" + Base.nameOfNodeWithArticle(newChild) + ") in this node, the owner documents are incompatible.");
        }
        int i = 0;
        while (i < this.nChildren) {
            if (this.children[i] == oldChild) {
                Base oldChildBase = (Base)oldChild;
                Base newChildBase = (Base)newChild;
                oldChildBase.setParent(null);
                newChildBase.setParent(this);
                Base prev = (Base)oldChildBase.getPreviousSibling();
                Base next = (Base)oldChildBase.getNextSibling();
                if (prev != null) {
                    prev.setNextSibling(newChildBase);
                }
                newChildBase.setPreviousSibling(prev);
                if (next != null) {
                    next.setPreviousSibling(newChildBase);
                }
                newChildBase.setNextSibling(next);
                oldChildBase.setPreviousSibling(null);
                oldChildBase.setNextSibling(null);
                this.children[i] = newChild;
                return oldChild;
            }
            ++i;
        }
        throw new DOMException(8, "The oldChild (" + Base.nameOfNodeWithArticle(oldChild) + ") is not a child of this node.");
    }

    public final int getLength() {
        return this.nChildren;
    }

    public final Node item(int index) {
        if (index < 0 || index >= this.nChildren) {
            return null;
        }
        return this.children[index];
    }

    protected final void transferData(NodeImpl source, NodeImpl destination, boolean deep) {
        destination.nChildren = source.nChildren;
        destination.children = new Node[source.nChildren + 1];
        if (deep) {
            int i = 0;
            while (i < source.nChildren) {
                destination.children[i] = source.children[i].cloneNode(true);
                if (i > 0) {
                    ((Base)destination.children[i - 1]).setNextSibling(destination.children[i]);
                    ((Base)destination.children[i]).setPreviousSibling(destination.children[i - 1]);
                } else {
                    ((Base)destination.children[i]).setPreviousSibling(null);
                }
                ((Base)destination.children[i]).setParent(destination);
                ++i;
            }
        } else {
            destination.nChildren = 0;
        }
    }

    public final NodeList getElementsByTagName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("DOM: null is not a valid name.");
        }
        return new NodeListImpl().init(this, name).update();
    }

    public final NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        if (localName == null) {
            throw new IllegalArgumentException("DOM: null is not a valid local name.");
        }
        return new NodeListImpl().init(this, namespaceURI, localName).update();
    }

    protected final void update(NodeListImpl list, String name) {
        if (name.equals("*")) {
            this.recAll(list, this);
        } else {
            this.rec(list, name, this);
        }
    }

    protected final void update(NodeListImpl list, String namespaceURI, String localName) {
        if (namespaceURI != null && namespaceURI.equals("*") && localName.equals("*")) {
            this.recAll(list, this);
        } else if (namespaceURI != null && namespaceURI.equals("*")) {
            this.recAllL(list, localName, this);
        } else if (localName.equals("*")) {
            this.recAllU(list, namespaceURI, this);
        } else {
            this.rec(list, namespaceURI, localName, this);
        }
    }

    private void rec(NodeListImpl list, String name, Node node) {
        NodeList c = node.getChildNodes();
        int i = 0;
        while (i < c.getLength()) {
            Node x = c.item(i);
            if (x.getNodeType() == 1 && name.equals(x.getNodeName())) {
                list.add(x);
            }
            this.rec(list, name, x);
            ++i;
        }
    }

    private void recAll(NodeListImpl list, Node node) {
        NodeList c = node.getChildNodes();
        int i = 0;
        while (i < c.getLength()) {
            Node x = c.item(i);
            if (x.getNodeType() == 1) {
                list.add(x);
            }
            this.recAll(list, x);
            ++i;
        }
    }

    private void rec(NodeListImpl list, String uri, String local, Node node) {
        NodeList c = node.getChildNodes();
        int i = 0;
        while (i < c.getLength()) {
            Node x = c.item(i);
            if (x.getNodeType() == 1 && local.equals(x.getLocalName()) && Base.areNamespaceURIEqual(uri, x.getNamespaceURI())) {
                list.add(x);
            }
            this.rec(list, uri, local, x);
            ++i;
        }
    }

    private void recAllU(NodeListImpl list, String uri, Node node) {
        NodeList c = node.getChildNodes();
        int i = 0;
        while (i < c.getLength()) {
            Node x = c.item(i);
            if (x.getNodeType() == 1 && Base.areNamespaceURIEqual(uri, x.getNamespaceURI())) {
                list.add(x);
            }
            this.recAllU(list, uri, x);
            ++i;
        }
    }

    private void recAllL(NodeListImpl list, String local, Node node) {
        NodeList c = node.getChildNodes();
        int i = 0;
        while (i < c.getLength()) {
            Node x = c.item(i);
            if (x.getNodeType() == 1 && local.equals(x.getLocalName())) {
                list.add(x);
            }
            this.recAllL(list, local, x);
            ++i;
        }
    }

    protected boolean checkChildNodeType(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 3411: {
                return true;
            }
        }
        return false;
    }

    private void checkChild(Node node) {
        short t = node.getNodeType();
        if (!this.checkChildNodeType(node)) {
            throw new DOMException(3, "A node of type " + Base.nameOfNode(node) + " cannot be used for this operation (append, insert or replace).");
        }
        Node x = node;
        int counter = 0;
        while (x != null) {
            if (x == this) {
                throw new DOMException(3, "Attempt to append, insert, or replace a node which is an ancestor of this node.");
            }
            ++counter;
            x = x.getParentNode();
        }
        x = this;
        while (x != null) {
            if (x == node) {
                throw new DOMException(3, "Attempt to append, insert, or replace a node which is an descendant of this node.");
            }
            x = x.getParentNode();
        }
    }

    public void normalize() {
        if (this.getNodeType() != 1 && this.getNodeType() != 9) {
            return;
        }
        NodeList nd = this.getChildNodes();
        CharArray buf = null;
        buf = this instanceof DocumentImpl ? ((DocumentImpl)this).normBuffer : ((DocumentImpl)this.getOwnerDocument()).normBuffer;
        int i = 0;
        while (i < nd.getLength()) {
            if (i < nd.getLength() - 1) {
                if (nd.item(i).getNodeType() == 3) {
                    int j = i;
                    while (j < nd.getLength() - 1 && nd.item(j + 1).getNodeType() == 3) {
                        buf.append(((Text)nd.item(j + 1)).getData());
                        ++j;
                    }
                    ((Text)nd.item(i)).appendData(buf.toString());
                    buf.clear();
                    if (j > i) {
                        this.removeChildren(nd.item(i + 1), j - i);
                        continue;
                    }
                    ((Base)nd.item(i)).normalize();
                    ++i;
                    continue;
                }
                ((Base)nd.item(i)).normalize();
                ++i;
                continue;
            }
            ((Base)nd.item(i)).normalize();
            ++i;
        }
    }

    public abstract String getNodeName();

    public abstract short getNodeType();

    public Node cloneNode(boolean a) {
        throw new RuntimeException("DOM: This node cannot be cloned.");
    }

    protected void forcedAppendChild(Node child) {
        this.ensureChildren();
        this.children[this.nChildren] = child;
        if (this.nChildren > 0) {
            ((Base)this.children[this.nChildren - 1]).setNextSibling(child);
            ((Base)child).setPreviousSibling(this.children[this.nChildren - 1]);
        } else {
            ((Base)child).setPreviousSibling(null);
        }
        ((Base)child).setNextSibling(null);
        ++this.nChildren;
    }
}

