/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml;

import com.sap.engine.lib.xml.StandardEntityResolver;
import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.lib.xml.parser.NestedSAXParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class StandardDOMParser
implements ErrorHandler {
    DocumentBuilderFactory factory = null;
    DocumentBuilder builder = null;
    public static final String INQMY_PARSER = "server.parser.inqmy";
    public static StandardEntityResolver stdentres = new StandardEntityResolver();
    public EntityResolver entres = stdentres;
    private String systemId = null;

    public StandardDOMParser() {
        this(false);
    }

    public StandardDOMParser(boolean useSapXMLToolkit) {
        try {
            if (SystemProperties.getProperty("org.xml.sax.driver") == null) {
                SystemProperties.setProperty("org.xml.sax.driver", "com.sap.engine.lib.xml.parser.SAXParser");
            }
            if (SystemProperties.getProperty(INQMY_PARSER) != null || useSapXMLToolkit) {
                try {
                    this.factory = (DocumentBuilderFactory)Class.forName("com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl").newInstance();
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter((Writer)sw, true);
                    e.printStackTrace(pw);
                    String msg = sw.toString();
                    pw.close();
                    throw new RuntimeException(msg);
                }
            } else {
                this.factory = DocumentBuilderFactory.newInstance();
            }
            this.factory.setExpandEntityReferences(true);
            this.builder = this.factory.newDocumentBuilder();
            this.setValidation(false);
            this.setReadDTD(false);
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            e.printStackTrace(pw);
            String msg = sw.toString();
            pw.close();
            throw new RuntimeException(msg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void trimWhiteSpaces(Node node) {
        if (node instanceof Document) {
            StandardDOMParser.trimWhiteSpaces(((Document)node).getDocumentElement());
            return;
        } else if (node instanceof Element) {
            NodeList nl = ((Element)node).getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                int oldlen = nl.getLength();
                StandardDOMParser.trimWhiteSpaces(nl.item(i));
                if (nl.getLength() < oldlen) {
                    --i;
                }
                ++i;
            }
            return;
        } else {
            if (!(node instanceof Text)) return;
            Text tx = (Text)node;
            try {
                tx.setData(StandardDOMParser.trimWhiteSpace(tx.getData()));
                if (tx.getData().length() != 0) return;
                node.getParentNode().removeChild(node);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("StandardDOMParser.trimWhiteSpaceNodes: Unexpected Exception, when trimming white-space: " + e);
            }
        }
    }

    public Document parse(String uri) throws SAXException, IOException {
        if (this.systemId != null) {
            throw new SAXException("The method parse(InputStream) should be used instead of parse(String), when the systemId is set");
        }
        return this.parse(new InputSource(uri));
    }

    public Document parse(InputStream is) throws SAXException, IOException {
        return this.parse(new InputSource(is));
    }

    public Document parse(InputSource is) throws SAXException, IOException {
        Document doc = null;
        try {
            this.builder.setEntityResolver(this.entres);
            if (this.systemId != null) {
                is.setSystemId(this.systemId);
            }
            doc = this.builder.parse(is);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NestedSAXParseException(ex);
        }
        doc.normalize();
        StandardDOMParser.trimWhiteSpaces(doc);
        return doc;
    }

    public void setSystemId(String s) {
        this.systemId = s;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void warning(SAXParseException ex) {
    }

    public void error(SAXParseException ex) {
    }

    public void fatalError(SAXParseException ex) throws SAXException {
    }

    public void setValidation(boolean value) throws SAXException {
        try {
            if (value) {
                this.setReadDTD(value);
            }
            this.factory.setValidating(value);
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void setAdditionalDTDLocation(InputSource additionalDTD) throws SAXException {
        try {
            this.factory.setAttribute("http://apache.org/xml/properties/schema/additionalDTD", additionalDTD);
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void setFeature(String feature, boolean value) throws SAXException {
        try {
            if (feature.equals("http://xml.org/sax/features/namespaces")) {
                this.setNamespaces(value);
            } else if (feature.equals("http://xml.org/sax/features/validation")) {
                this.setValidation(value);
            } else if (feature.equals("http://inqmy.org/dom/features/trim-white-spaces")) {
                if (this.factory.getClass().getName().equals("com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl")) {
                    this.factory.setAttribute(feature, new Boolean(value));
                }
            } else if (feature.equals("http://apache.org/xml/features/nonvalidating/load-external-dtd")) {
                if (this.factory.getClass().getName().equals("org.apache.xerces.jaxp.DocumentBuilderFactoryImpl")) {
                    this.factory.setAttribute(feature, new Boolean(value));
                } else if (this.factory.getClass().getName().equals("com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl")) {
                    this.factory.setAttribute("http://inqmy.org/sax/features/read-dtd", new Boolean(value));
                }
            } else if (feature.equals("http://inqmy.org/xml/features/close-streams")) {
                try {
                    this.factory.setAttribute(feature, new Boolean(value));
                }
                catch (Exception e) {}
            } else {
                this.factory.setAttribute(feature, new Boolean(value));
            }
            try {
                this.builder = this.factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new NestedSAXParseException(e);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public void setNamespaces(boolean value) throws SAXException {
        try {
            this.factory.setNamespaceAware(value);
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void setParserProxy(String host, int port) throws SAXException {
        this.setProperty("http://inqmy.org/sax/properties/proxy-host", host);
        this.setProperty("http://inqmy.org/sax/properties/proxy-port", new Integer(port));
    }

    public void setProperty(String property, Object data) throws SAXException {
        if (property.equals("http://xml.org/sax/features/namespaces")) {
            this.setNamespaces((Boolean)data);
        } else if (property.equals("http://xml.org/sax/features/validation")) {
            this.setValidation((Boolean)data);
        } else if (property.equals("http://apache.org/xml/properties/schema/additionalDTD")) {
            if (!(data instanceof InputSource)) {
                throw new SAXNotSupportedException("The value of property http://apache.org/xml/properties/schema/additionalDTD has to be an instance of class org.xml.sax.InputSource.");
            }
            this.setAdditionalDTDLocation((InputSource)data);
        } else {
            throw new SAXNotSupportedException(property);
        }
        try {
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void setParserAlternativeDTD(String uri) throws SAXException {
        this.setProperty("http://inqmy.org/sax/properties/alternative-dtd", uri);
    }

    public void setBackwardsCompatibilityMode(boolean value) throws SAXException {
        this.setFeature("http://sap.com/xml/features/backwards-compatibility-mode", value);
    }

    public void setUseProxy(boolean value) throws SAXException {
        this.setFeature("http://inqmy.org/sax/features/use-proxy", value);
    }

    public void setReadDTD(boolean value) throws SAXException {
        this.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", value);
    }

    public void setCloseStreams(boolean value) throws SAXException {
        this.setFeature("http://inqmy.org/xml/features/close-streams", value);
    }

    public static Document createDocument() {
        try {
            DocumentBuilderFactory factory = null;
            if (SystemProperties.getProperty(INQMY_PARSER) != null) {
                try {
                    factory = (DocumentBuilderFactory)Class.forName("com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl").newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    factory = DocumentBuilderFactory.newInstance();
                }
            } else {
                factory = DocumentBuilderFactory.newInstance();
            }
            return factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Could not create a new Document. Exception: " + e);
        }
    }

    public static String trimWhiteSpace(String data) {
        if (data == null) {
            return "";
        }
        int b = 0;
        while (b < data.length() && StandardDOMParser.isWhiteSpaceChar(data.charAt(b))) {
            ++b;
        }
        int e = data.length() - 1;
        while (e > 0 && e > b && StandardDOMParser.isWhiteSpaceChar(data.charAt(e))) {
            --e;
        }
        data = data.substring(b, e + 1);
        return data;
    }

    public static boolean isWhiteSpace(String str) {
        if (str == null) {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            if (!StandardDOMParser.isWhiteSpaceChar(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isWhiteSpaceChar(char ch) {
        return ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t';
    }

    public void setEntityResolver(EntityResolver r) {
        this.entres = r;
    }
}

