/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.xpath.matcher;

import com.sap.engine.lib.schema.validator.xpath.XPathStepObject;
import com.sap.engine.lib.schema.validator.xpath.matcher.NodesSet;
import com.sap.engine.lib.schema.validator.xpath.matcher.XPathTokenizer;

public class DescendentElementsSet
implements NodesSet {
    private String descendentElementUri;
    private String descendentElementName;
    private NodesSet subset;

    protected DescendentElementsSet(String descendentElementUri, String descendentElementName, NodesSet subset) {
        this.descendentElementUri = descendentElementUri;
        this.descendentElementName = descendentElementName;
        this.subset = subset;
    }

    public boolean contains(XPathTokenizer tokenizer) {
        XPathStepObject stepObj = tokenizer.next();
        if (stepObj == null) {
            return false;
        }
        if (!stepObj.isAttribute()) {
            if (this.descendentElementUri.equals(stepObj.getUri()) && this.descendentElementName.equals(stepObj.getLocalName())) {
                if (this.subset == null) {
                    return true;
                }
                int index = tokenizer.getIndex();
                if (this.subset.contains(tokenizer)) {
                    return true;
                }
                tokenizer.setIndex(index);
                return this.contains(tokenizer);
            }
            return this.contains(tokenizer);
        }
        return this.contains(tokenizer);
    }

    public String toString() {
        return "descendent elements set : \nuri : " + this.descendentElementUri + "; name : " + this.descendentElementName + "\nsubset : \n" + (this.subset == null ? "none" : this.subset.toString());
    }
}

