/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.xpath.matcher;

import com.sap.engine.lib.schema.validator.xpath.XPathStepObject;
import com.sap.engine.lib.schema.validator.xpath.matcher.NodesSet;
import com.sap.engine.lib.schema.validator.xpath.matcher.XPathTokenizer;

public class ContextElementSet
implements NodesSet {
    private String contextElementUri;
    private String contextElementName;
    private NodesSet subset;
    private boolean any;

    protected ContextElementSet(NodesSet subset) {
        this.any = true;
        this.subset = subset;
    }

    protected ContextElementSet(String contextElementUri, String contextElementName, NodesSet subset) {
        this.contextElementUri = contextElementUri;
        this.contextElementName = contextElementName;
        this.subset = subset;
    }

    public boolean contains(XPathTokenizer tokenizer) {
        XPathStepObject stepObj = tokenizer.next();
        if (stepObj == null) {
            return false;
        }
        if (stepObj.isAttribute()) {
            return false;
        }
        if (!this.any) {
            if (!this.contextElementUri.equals(stepObj.getUri())) {
                return false;
            }
            if (!this.contextElementName.equals("*") && !this.contextElementName.equals(stepObj.getLocalName())) {
                return false;
            }
        }
        return this.subset == null ? true : this.subset.contains(tokenizer);
    }

    public String toString() {
        return "context element set : \nuri : " + this.contextElementUri + "; name : " + this.contextElementName + "; any : " + this.any + "\nsubset : \n" + (this.subset == null ? "none" : this.subset.toString());
    }
}

