/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.xpath.matcher;

import com.sap.engine.lib.schema.validator.xpath.XPathStepObject;
import com.sap.engine.lib.schema.validator.xpath.matcher.NodesSet;
import com.sap.engine.lib.schema.validator.xpath.matcher.XPathTokenizer;

public class AttributeSet
implements NodesSet {
    private String attributeUri;
    private String attributeName;
    private boolean any;

    protected AttributeSet() {
        this.any = true;
    }

    protected AttributeSet(String attributeUri, String attributeName) {
        this.attributeUri = attributeUri;
        this.attributeName = attributeName;
    }

    public boolean contains(XPathTokenizer tokenizer) {
        XPathStepObject stepObj = tokenizer.next();
        if (stepObj == null) {
            return false;
        }
        if (!stepObj.isAttribute()) {
            return false;
        }
        if (this.any) {
            return true;
        }
        if (!this.attributeUri.equals(stepObj.getUri())) {
            return false;
        }
        if (this.attributeName.equals("*")) {
            return true;
        }
        return this.attributeName.equals(stepObj.getLocalName());
    }

    public String toString() {
        return "attribute set : \nuri : " + this.attributeUri + "; name : " + this.attributeName + "; isAny  : " + this.any;
    }
}

