/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.tokenizer;

import com.sap.engine.lib.schema.exception.SchemaException;
import com.sap.engine.lib.schema.validator.tokenizer.XMLToken;
import java.util.Stack;
import java.util.Vector;

public abstract class XMLTokenizer {
    protected boolean hasFinished;
    protected Stack valueCollectorsStack = new Stack();
    protected XMLToken peekToken;

    public XMLToken next() throws SchemaException {
        XMLToken result = null;
        if (this.peekToken != null) {
            result = this.peekToken;
            this.peekToken = null;
            return result;
        }
        result = this.processNext();
        return result;
    }

    protected abstract XMLToken processNext() throws SchemaException;

    public XMLToken peek() throws SchemaException {
        if (this.peekToken == null) {
            this.peekToken = this.processNext();
        }
        return this.peekToken;
    }

    protected XMLToken createTokenWithEndingMark(Vector valuesCollector) {
        String value = "";
        int i = 0;
        while (i < valuesCollector.size()) {
            value = value + (String)valuesCollector.get(i);
            ++i;
        }
        return new XMLToken(false, null, null, null, value, null, null, null, null, null, null, null);
    }

    protected void collectValue(String value) {
        boolean collectValue = false;
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (ch != '\r' && ch != '\n' && ch != '\t') {
                collectValue = true;
                break;
            }
            ++i;
        }
        if (collectValue && !this.valueCollectorsStack.isEmpty()) {
            Vector collector = (Vector)this.valueCollectorsStack.peek();
            collector.add(value);
        }
    }
}

