/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.tokenizer;

import com.sap.engine.lib.schema.exception.SchemaException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.schema.validator.tokenizer.AttributeStructure;
import com.sap.engine.lib.schema.validator.tokenizer.XMLToken;
import com.sap.engine.lib.schema.validator.tokenizer.XMLTokenizer;
import com.sap.engine.lib.xml.parser.ActiveXMLParser;
import com.sap.engine.lib.xml.parser.ParserException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;
import org.xml.sax.Attributes;

public class XMLSAXTokenizer
extends XMLTokenizer {
    private ActiveXMLParser activeParser;

    public XMLSAXTokenizer(InputStream inputStream) throws SchemaException {
        this(new ActiveXMLParser(inputStream));
    }

    public XMLSAXTokenizer(Reader reader) throws SchemaException {
        this(new ActiveXMLParser(reader));
    }

    public XMLSAXTokenizer(ActiveXMLParser activeParser) throws SchemaException {
        this.activeParser = activeParser;
        try {
            activeParser.begin();
        }
        catch (ParserException parserExc) {
            throw new SchemaException(parserExc);
        }
    }

    public XMLToken processNext() throws SchemaException {
        if (this.hasFinished) {
            return null;
        }
        try {
            int mark = -1;
            while (true) {
                if ((mark = this.activeParser.next()) == 6) {
                    this.hasFinished = true;
                    return null;
                }
                if (mark == 3) {
                    this.collectValue(this.activeParser.getValue());
                    continue;
                }
                if (mark == 1) {
                    Vector valuesCollector = new Vector();
                    this.valueCollectorsStack.push(valuesCollector);
                    return this.createTokenWithStartingMark();
                }
                if (mark == 2) break;
            }
            return this.createTokenWithEndingMark((Vector)this.valueCollectorsStack.pop());
        }
        catch (Exception exc) {
            if (exc instanceof SchemaException) {
                throw (SchemaException)exc;
            }
            throw new SchemaException(exc);
        }
    }

    private XMLToken createTokenWithStartingMark() throws SchemaException {
        String tokenUri = this.activeParser.getURI();
        tokenUri = tokenUri == null ? "" : tokenUri;
        String tokenQName = this.activeParser.getQName();
        String tokenLocalName = this.activeParser.getLocalName();
        String tokenValue = null;
        String tokenXsiTypeUri = null;
        String tokenXsiTypeName = null;
        String tokenXsiNil = null;
        String tokenXsiSchemaLocation = null;
        String tokenXsiNoNamespaceSchemaLocation = null;
        Vector<AttributeStructure> tokenAttribStructuresCollector = new Vector<AttributeStructure>();
        Attributes attributes = this.activeParser.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                String attrUri = attributes.getURI(i);
                attrUri = attrUri == null ? "" : attrUri;
                String attrQName = attributes.getQName(i);
                String attrLocalName = attributes.getLocalName(i);
                String attrValue = attributes.getValue(i);
                if (attrUri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                    if (attrLocalName.equals("type")) {
                        String[] prefixAndTypeName = Tools.parseQName(attrValue.trim());
                        String prefix = prefixAndTypeName[0];
                        if (prefix == null) {
                            tokenXsiTypeUri = this.activeParser.getURI("");
                            tokenXsiTypeUri = tokenXsiTypeUri == null ? "" : tokenXsiTypeUri;
                        } else {
                            tokenXsiTypeUri = this.activeParser.getURI(prefix);
                            if (tokenXsiTypeUri == null) {
                                throw new SchemaException("Value of attribute with qname '" + attrQName + "' contains prefix, which is not mapped to any uri.");
                            }
                        }
                        tokenXsiTypeName = prefixAndTypeName[1];
                        if (tokenXsiTypeName == null) {
                            throw new SchemaException("Value of attribute with qname '" + attrQName + "' has to contain local name, which indicates the name of the corresponding type.");
                        }
                    } else if (attrLocalName.equals("nil")) {
                        tokenXsiNil = attrValue.trim();
                    } else if (attrLocalName.equals("schemaLocation")) {
                        tokenXsiSchemaLocation = attrValue.trim();
                    } else if (attrLocalName.equals("noNamespaceSchemaLocation")) {
                        tokenXsiNoNamespaceSchemaLocation = attrValue.trim();
                    }
                } else if (!attrUri.equals("http://www.w3.org/2000/xmlns/") && !attrQName.startsWith("xmlns")) {
                    tokenAttribStructuresCollector.add(new AttributeStructure(attrUri, attrQName, attrLocalName, attrValue, null));
                }
                ++i;
            }
        }
        return new XMLToken(true, tokenUri, tokenQName, tokenLocalName, tokenValue, tokenXsiTypeUri, tokenXsiTypeName, tokenXsiNil, tokenXsiSchemaLocation, tokenXsiNoNamespaceSchemaLocation, tokenAttribStructuresCollector, null);
    }
}

