/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.tokenizer;

import com.sap.engine.lib.schema.exception.SchemaException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.schema.validator.tokenizer.AttributeStructure;
import com.sap.engine.lib.schema.validator.tokenizer.XMLToken;
import com.sap.engine.lib.schema.validator.tokenizer.XMLTokenizer;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.dom.NodeImpl;
import com.sap.engine.lib.xml.dom.TextImpl;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDOMTokenizer
extends XMLTokenizer {
    private int domIndex;
    private Element ctxElement;
    private Stack domIndexesStack;
    private boolean isInvoked;

    public XMLDOMTokenizer(Node node) throws SchemaException {
        if (node instanceof Document) {
            this.ctxElement = ((Document)node).getDocumentElement();
        } else if (node instanceof Element) {
            this.ctxElement = (Element)node;
        } else {
            throw new SchemaException("Can not create xml tokenizer from node different from Document or Element node.");
        }
        this.domIndexesStack = new Stack();
        this.hasFinished = false;
        this.isInvoked = false;
    }

    public XMLToken processNext() throws SchemaException {
        if (this.hasFinished) {
            return null;
        }
        if (!this.isInvoked) {
            this.isInvoked = true;
            this.domIndex = 0;
            return this.createTokenWithStartingMark(this.ctxElement);
        }
        NodeList list = this.ctxElement.getChildNodes();
        int i = this.domIndex;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node instanceof TextImpl) {
                this.collectValue(node.getNodeValue());
            } else if (node instanceof Element) {
                this.domIndexesStack.push(new Integer(i + 1));
                this.domIndex = 0;
                this.ctxElement = (Element)node;
                return this.createTokenWithStartingMark(node);
            }
            ++i;
        }
        Node parent = this.ctxElement.getParentNode();
        if (parent instanceof Document) {
            this.hasFinished = true;
            return this.createTokenWithEndingMark((Vector)this.valueCollectorsStack.pop());
        }
        this.ctxElement = (Element)parent;
        this.domIndex = (Integer)this.domIndexesStack.pop();
        return this.createTokenWithEndingMark((Vector)this.valueCollectorsStack.pop());
    }

    private XMLToken createTokenWithStartingMark(Node node) throws SchemaException {
        Vector valuesCollector = new Vector();
        this.valueCollectorsStack.push(valuesCollector);
        String tokenUri = node.getNamespaceURI();
        tokenUri = tokenUri == null ? "" : tokenUri;
        String tokenQName = node.getNodeName();
        String tokenLocalName = node.getLocalName();
        String tokenValue = null;
        String tokenXsiTypeUri = null;
        String tokenXsiTypeName = null;
        String tokenXsiSchemaLocation = null;
        String tokenXsiNoNamespaceSchemaLocation = null;
        String tokenXsiNil = null;
        Vector<AttributeStructure> tokenAttribStructuresCollector = new Vector<AttributeStructure>();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int i = 0;
            while (i < namedNodeMap.getLength()) {
                Attr attrib = (Attr)namedNodeMap.item(i);
                String attrUri = attrib.getNamespaceURI();
                attrUri = attrUri == null ? "" : attrUri;
                String attrQName = attrib.getNodeName();
                String attrLocalName = attrib.getLocalName();
                String attrValue = attrib.getValue();
                if (attrUri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                    if (attrLocalName.equals("type")) {
                        String[] prefixAndTypeName = Tools.parseQName(attrValue.trim());
                        String prefix = prefixAndTypeName[0];
                        if (prefix == null) {
                            tokenXsiTypeUri = DOM.prefixToURI("", node);
                            tokenXsiTypeUri = tokenXsiTypeUri == null ? "" : tokenXsiTypeUri;
                        } else {
                            tokenXsiTypeUri = DOM.prefixToURI(prefix, node);
                            if (tokenXsiTypeUri == null) {
                                throw new SchemaException("Value of attribute with qname '" + attrQName + "' contains prefix, which is not mapped to any uri.");
                            }
                        }
                        tokenXsiTypeName = prefixAndTypeName[1];
                        if (tokenXsiTypeName == null) {
                            throw new SchemaException("Value of attribute with qname '" + attrQName + "' has to contain local name, which indicates the name of the corresponding type.");
                        }
                    } else if (attrLocalName.equals("nil")) {
                        tokenXsiNil = attrValue.trim();
                    } else if (tokenLocalName.equals("schemaLocation")) {
                        tokenXsiSchemaLocation = attrValue.trim();
                    } else if (tokenLocalName.equals("noNamespaceSchemaLocation")) {
                        tokenXsiNoNamespaceSchemaLocation = attrValue.trim();
                    }
                } else if (!attrUri.equals("http://www.w3.org/2000/xmlns/") && !attrQName.startsWith("xmlns")) {
                    tokenAttribStructuresCollector.add(new AttributeStructure(attrUri, attrQName, attrLocalName, attrValue, (NodeImpl)((Object)attrib)));
                }
                ++i;
            }
        }
        return new XMLToken(true, tokenUri, tokenQName, tokenLocalName, tokenValue, tokenXsiTypeUri, tokenXsiTypeName, tokenXsiNil, tokenXsiSchemaLocation, tokenXsiNoNamespaceSchemaLocation, tokenAttribStructuresCollector, (NodeImpl)node);
    }
}

