/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.identity;

import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.validator.ValidationContext;
import com.sap.engine.lib.schema.validator.identity.AbstractIdentityConstraintDefinitionValidator;
import com.sap.engine.lib.schema.validator.identity.FieldsStructure;
import com.sap.engine.lib.schema.validator.identity.ReferenceableIdentityConstraintDefinitionValidator;
import com.sap.engine.lib.schema.validator.xpath.matcher.Matcher;

class KeyrefIdentityConstraintDefinitionValidator
extends AbstractIdentityConstraintDefinitionValidator {
    private ReferenceableIdentityConstraintDefinitionValidator referedValidator;

    KeyrefIdentityConstraintDefinitionValidator(IdentityConstraintDefinition identityConstraintDef, Matcher[] matchers, ValidationContext context) {
        super(identityConstraintDef, matchers, context);
    }

    protected IdentityConstraintDefinition getReferedIdentityConstraintDefinition() {
        return this.identityConstrDef.getReferencedKey();
    }

    protected void setReferedValidator(ReferenceableIdentityConstraintDefinitionValidator referedValidator) {
        this.referedValidator = referedValidator;
    }

    public boolean validate() {
        int structuresCount = this.fieldsStructuresCollector.size();
        int i = 0;
        while (i < structuresCount) {
            FieldsStructure structure = (FieldsStructure)this.fieldsStructuresCollector.get(i);
            if (structure.isInitialized()) {
                if (!this.referedValidator.contains(structure)) {
                    this.context.addError_Identity("combination of element information items " + structure.getRepresentation() + " must be identical to some of element information items combinations, represented by the referenced key of keyref identity constraint definition {" + this.identityConstrDef.getTargetNamespace() + "}:" + this.identityConstrDef.getName() + ".");
                    return false;
                }
            } else {
                this.context.addError_Identity("combination of element information items, represented by the keyref identity constraint definition {" + this.identityConstrDef.getTargetNamespace() + "}:" + this.identityConstrDef.getName() + ", must be present.");
                return false;
            }
            ++i;
        }
        return true;
    }
}

