/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.identity;

import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.exception.SchemaException;
import com.sap.engine.lib.schema.validator.ValidationContext;
import com.sap.engine.lib.schema.validator.identity.AbstractIdentityConstraintDefinitionValidator;
import com.sap.engine.lib.schema.validator.identity.KeyIdentityConstraintDefinitionValidator;
import com.sap.engine.lib.schema.validator.identity.KeyrefIdentityConstraintDefinitionValidator;
import com.sap.engine.lib.schema.validator.identity.ReferenceableIdentityConstraintDefinitionValidator;
import com.sap.engine.lib.schema.validator.identity.UniqueIdentityConstraintDefinitionValidator;
import com.sap.engine.lib.schema.validator.xpath.XPathObject;
import com.sap.engine.lib.schema.validator.xpath.matcher.Matcher;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import java.util.Vector;

public class IdentityConstraintDefinitionsValidator {
    private Hashtable reusableValidators = new Hashtable();
    private Vector activeValidators = new Vector();
    private Hashtable reusableMatchers = new Hashtable();

    public void activateValidators(IdentityConstraintDefinition[] identityConstrDefs, ValidationContext context, XPathObject xPathObj) {
        Vector<AbstractIdentityConstraintDefinitionValidator> validators = new Vector<AbstractIdentityConstraintDefinitionValidator>();
        Vector<AbstractIdentityConstraintDefinitionValidator> keyrefValidators = new Vector<AbstractIdentityConstraintDefinitionValidator>();
        int i = 0;
        while (i < identityConstrDefs.length) {
            IdentityConstraintDefinition identConstrDef = identityConstrDefs[i];
            AbstractIdentityConstraintDefinitionValidator validator = this.determineValidator(identConstrDef, context, xPathObj);
            if (validator instanceof KeyrefIdentityConstraintDefinitionValidator) {
                keyrefValidators.add(validator);
            }
            validators.add(validator);
            ++i;
        }
        this.activeValidators.add(validators);
        int i2 = 0;
        while (i2 < keyrefValidators.size()) {
            KeyrefIdentityConstraintDefinitionValidator keyrefValidator = (KeyrefIdentityConstraintDefinitionValidator)keyrefValidators.get(i2);
            this.initReferedValidator(keyrefValidator);
            ++i2;
        }
    }

    private AbstractIdentityConstraintDefinitionValidator determineValidator(IdentityConstraintDefinition identConstrDef, ValidationContext context, XPathObject xPathObj) {
        AbstractIdentityConstraintDefinitionValidator validator = (AbstractIdentityConstraintDefinitionValidator)this.reusableValidators.get(identConstrDef);
        if (validator != null) {
            this.reusableValidators.remove(identConstrDef);
        } else {
            validator = this.createValidator(identConstrDef, context);
        }
        validator.setContextXPathObject(xPathObj.cloneXPathObject());
        return validator;
    }

    private AbstractIdentityConstraintDefinitionValidator createValidator(IdentityConstraintDefinition identConstrDef, ValidationContext context) {
        Matcher[] matchers = this.determineMatchers(identConstrDef);
        if (identConstrDef.isIdentityConstraintCategoryKey()) {
            return new KeyIdentityConstraintDefinitionValidator(identConstrDef, matchers, context);
        }
        if (identConstrDef.isIdentityConstraintCategoryKeyref()) {
            return new KeyrefIdentityConstraintDefinitionValidator(identConstrDef, matchers, context);
        }
        return new UniqueIdentityConstraintDefinitionValidator(identConstrDef, matchers, context);
    }

    private Matcher[] determineMatchers(IdentityConstraintDefinition identConstrDef) {
        Matcher[] matchers = (Matcher[])this.reusableMatchers.get(identConstrDef);
        if (matchers == null) {
            matchers = this.createMatchers(identConstrDef);
            this.reusableMatchers.put(identConstrDef, matchers);
        }
        return matchers;
    }

    private Matcher[] createMatchers(IdentityConstraintDefinition identConstrDef) {
        String selectorXPath = identConstrDef.getSelector();
        Vector fieldXPaths = new Vector();
        identConstrDef.getFields(fieldXPaths);
        Matcher[] matchers = new Matcher[fieldXPaths.size()];
        Hashtable nsMappings = DOM.getNamespaceMappingsInScope(identConstrDef.getAssociatedDOMNode());
        int i = 0;
        while (i < fieldXPaths.size()) {
            String fieldXPath = (String)fieldXPaths.get(i);
            matchers[i] = new Matcher(selectorXPath, fieldXPath, nsMappings);
            ++i;
        }
        return matchers;
    }

    private void initReferedValidator(KeyrefIdentityConstraintDefinitionValidator keyrefValidator) {
        IdentityConstraintDefinition referedIdentConstrDef = keyrefValidator.getReferedIdentityConstraintDefinition();
        int i = this.activeValidators.size() - 1;
        while (i >= 0) {
            Vector validators = (Vector)this.activeValidators.get(i);
            int j = 0;
            while (j < validators.size()) {
                AbstractIdentityConstraintDefinitionValidator validator = (AbstractIdentityConstraintDefinitionValidator)validators.get(j);
                if (validator instanceof ReferenceableIdentityConstraintDefinitionValidator && validator.getIdentityConstraintDefintion() == referedIdentConstrDef) {
                    keyrefValidator.setReferedValidator((ReferenceableIdentityConstraintDefinitionValidator)validator);
                    return;
                }
                ++j;
            }
            --i;
        }
    }

    public void inactivateValidators() {
        Vector validators = (Vector)this.activeValidators.lastElement();
        int i = 0;
        while (i < validators.size()) {
            AbstractIdentityConstraintDefinitionValidator validator = (AbstractIdentityConstraintDefinitionValidator)validators.get(i);
            this.reuseValidator(validator);
            ++i;
        }
        this.activeValidators.remove(this.activeValidators.size() - 1);
    }

    private void reuseValidator(AbstractIdentityConstraintDefinitionValidator validator) {
        IdentityConstraintDefinition identConstrDef = validator.getIdentityConstraintDefintion();
        if (!this.reusableValidators.contains(identConstrDef)) {
            validator.clear();
            this.reusableValidators.put(identConstrDef, validator);
        }
    }

    public boolean validate() {
        Vector validators = (Vector)this.activeValidators.lastElement();
        int i = 0;
        while (i < validators.size()) {
            AbstractIdentityConstraintDefinitionValidator validator = (AbstractIdentityConstraintDefinitionValidator)validators.get(i);
            if (!validator.validate()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addStructure(TypeDefinitionBase typeDefBase, String value, XPathObject xPathObj, boolean isNillable) throws SchemaException {
        int i = 0;
        while (i < this.activeValidators.size()) {
            Vector validators = (Vector)this.activeValidators.get(i);
            int j = 0;
            while (j < validators.size()) {
                AbstractIdentityConstraintDefinitionValidator validator = (AbstractIdentityConstraintDefinitionValidator)validators.get(j);
                validator.add(typeDefBase, value, xPathObj, isNillable);
                ++j;
            }
            ++i;
        }
    }
}

