/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.identity;

import com.sap.engine.lib.schema.validator.identity.ValueStructure;

class FieldsStructure {
    private ValueStructure[] structures;
    private int count = -1;

    protected FieldsStructure(int fieldsCount) {
        this.structures = new ValueStructure[fieldsCount];
        this.count = 0;
    }

    protected void add(ValueStructure structure, int index) {
        this.structures[index] = structure;
        ++this.count;
    }

    protected boolean match(FieldsStructure structure) {
        if (this.structures.length != structure.structures.length) {
            return false;
        }
        int i = 0;
        while (i < structure.structures.length) {
            if (!this.structures[i].match(structure.structures[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isInitialized() {
        return this.count == this.structures.length;
    }

    protected boolean isInitialized(int index) {
        return this.structures[index] != null;
    }

    protected String getRepresentation() {
        String representation = "[";
        int i = 0;
        while (i < this.structures.length) {
            ValueStructure structure = this.structures[i];
            representation = representation + (structure == null ? "empty" : structure.getNodeQualifiedRepresentation() + " - " + structure.getValue()) + "; ";
            ++i;
        }
        representation = representation + "]";
        return representation;
    }
}

