/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.identity;

import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.impl.ffacets.Value;
import com.sap.engine.lib.schema.exception.SchemaException;
import com.sap.engine.lib.schema.validator.ValidationContext;
import com.sap.engine.lib.schema.validator.identity.FieldsStructure;
import com.sap.engine.lib.schema.validator.identity.ValueStructure;
import com.sap.engine.lib.schema.validator.xpath.XPathObject;
import com.sap.engine.lib.schema.validator.xpath.XPathStepObject;
import com.sap.engine.lib.schema.validator.xpath.matcher.Matcher;
import java.util.Vector;

abstract class AbstractIdentityConstraintDefinitionValidator {
    protected IdentityConstraintDefinition identityConstrDef;
    protected Vector fieldsStructuresCollector;
    protected Matcher[] matchers;
    protected ValidationContext context;
    protected XPathObject contextXPathObj;

    protected AbstractIdentityConstraintDefinitionValidator(IdentityConstraintDefinition identityConstrDef, Matcher[] matchers, ValidationContext context) {
        this.identityConstrDef = identityConstrDef;
        this.context = context;
        this.fieldsStructuresCollector = new Vector();
        this.matchers = matchers;
    }

    protected IdentityConstraintDefinition getIdentityConstraintDefintion() {
        return this.identityConstrDef;
    }

    protected void add(TypeDefinitionBase typeDefBase, String value, XPathObject xPathObj, boolean isNillable) throws SchemaException {
        XPathObject subXPathObj = xPathObj.getSubXPathObject(this.contextXPathObj);
        int i = 0;
        while (i < this.matchers.length) {
            Matcher matcher = this.matchers[i];
            if (matcher.matches(subXPathObj)) {
                if (typeDefBase != null && (typeDefBase instanceof ComplexTypeDefinition || isNillable)) {
                    throw new SchemaException();
                }
                SimpleTypeDefinition simpleTypeDef = (SimpleTypeDefinition)typeDefBase;
                FieldsStructure structure = null;
                if (this.fieldsStructuresCollector.size() == 0) {
                    structure = new FieldsStructure(this.matchers.length);
                    this.fieldsStructuresCollector.add(structure);
                } else {
                    structure = (FieldsStructure)this.fieldsStructuresCollector.lastElement();
                    if (structure.isInitialized() || structure.isInitialized(i)) {
                        structure = new FieldsStructure(this.matchers.length);
                        this.fieldsStructuresCollector.add(structure);
                    }
                }
                XPathStepObject lastXPathStep = subXPathObj.lastXPathStepObject();
                Value ffacetsValue = typeDefBase == null ? null : simpleTypeDef.getFundamentalFacets().parse(value);
                structure.add(new ValueStructure(ffacetsValue, value, lastXPathStep.getQNameWithoutPosition()), i);
            }
            ++i;
        }
    }

    protected void setContextXPathObject(XPathObject contextXPathObj) {
        this.contextXPathObj = contextXPathObj;
    }

    protected void clear() {
        this.fieldsStructuresCollector.clear();
    }

    public abstract boolean validate();
}

