/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.automat;

import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.schema.validator.automat.AutomatState;
import com.sap.engine.lib.schema.validator.automat.GroupAutomat;
import com.sap.engine.lib.schema.validator.automat.ParticleAutomat;
import com.sap.engine.lib.schema.validator.automat.Switch;

public final class SequenceAutomat
extends GroupAutomat {
    protected SequenceAutomat(ModelGroup modelGroup) {
        super(modelGroup);
        this.switchingAutomatIndex = 0;
    }

    protected Switch switchState(String uri, String name) {
        if (this.particleAutomats.size() == 0) {
            return null;
        }
        ParticleAutomat switchingAutomat = this.determineSwitchingAutomat();
        Switch switchResult = switchingAutomat.switchState(uri, name);
        boolean switchingAutomatIsSatisfied = switchingAutomat.isSatisfied();
        if (switchingAutomatIsSatisfied && this.switchingAutomatIndex < this.particleAutomats.size() - 1 && (switchResult == null || switchResult.base instanceof Wildcard)) {
            AutomatState presentState = this.getState();
            switchingAutomat.reset();
            ++this.switchingAutomatIndex;
            Switch newSwitchResult = this.switchState(uri, name);
            if (switchResult == null && newSwitchResult == null || switchResult != null && switchResult.base instanceof Wildcard && (newSwitchResult == null || newSwitchResult.base instanceof Wildcard)) {
                this.setState(presentState);
            } else {
                switchResult = newSwitchResult;
            }
        }
        if (switchResult != null) {
            this.isUntouched = false;
        }
        return switchResult;
    }

    protected boolean isSatisfied() {
        int i = this.switchingAutomatIndex;
        while (i < this.particleAutomats.size()) {
            ParticleAutomat particleAutomat = (ParticleAutomat)this.particleAutomats.get(i);
            if (!particleAutomat.isSatisfied()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isDrained() {
        if (this.particleAutomats.size() == 0) {
            return true;
        }
        return this.switchingAutomatIndex == this.particleAutomats.size() - 1 && this.determineSwitchingAutomat().isDrained();
    }

    protected void initToStringBuffer_GroupCompositor(StringBuffer toStringBuffer) {
        toStringBuffer.append("Sequence");
    }

    protected void initExpectedBuffer(StringBuffer expectedBuffer) {
        int i = this.switchingAutomatIndex;
        while (i < this.particleAutomats.size()) {
            ParticleAutomat particleAutomat = (ParticleAutomat)this.particleAutomats.get(i);
            particleAutomat.initExpectedBuffer(expectedBuffer);
            if (!particleAutomat.isSatisfied()) break;
            ++i;
        }
    }
}

