/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.automat;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.ModelGroupDefinition;
import com.sap.engine.lib.schema.components.Particle;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.schema.validator.automat.AllAutomat;
import com.sap.engine.lib.schema.validator.automat.Automat;
import com.sap.engine.lib.schema.validator.automat.AutomatState;
import com.sap.engine.lib.schema.validator.automat.BaseAutomat;
import com.sap.engine.lib.schema.validator.automat.ChoiceAutomat;
import com.sap.engine.lib.schema.validator.automat.ElementAutomat;
import com.sap.engine.lib.schema.validator.automat.GroupAutomat;
import com.sap.engine.lib.schema.validator.automat.ParticleAutomatState;
import com.sap.engine.lib.schema.validator.automat.SequenceAutomat;
import com.sap.engine.lib.schema.validator.automat.Switch;
import com.sap.engine.lib.schema.validator.automat.WildcardAutomat;

public final class ParticleAutomat
extends Automat {
    private int minOccurs;
    private int maxOccurs;
    private boolean isUnbounded;
    private Automat automat;
    private int occurrenceCounter = 0;
    private boolean incremetOccurrenceCounter = true;

    protected ParticleAutomat(Particle particle) {
        this.minOccurs = particle.getMinOccurs();
        this.maxOccurs = particle.getMaxOccurs();
        this.isUnbounded = particle.isMaxOccursUnbounded();
        this.initAutomat(particle);
    }

    private void initAutomat(Particle particle) {
        Base term = particle.getTerm();
        this.automat = term instanceof ElementDeclaration ? new ElementAutomat((ElementDeclaration)term) : (term instanceof Wildcard ? new WildcardAutomat((Wildcard)term) : (term instanceof ModelGroup ? this.determineGroupAutomat((ModelGroup)term) : this.determineGroupAutomat((ModelGroupDefinition)term)));
    }

    private GroupAutomat determineGroupAutomat(ModelGroup modelGroup) {
        if (modelGroup.isCompositorAll()) {
            return new AllAutomat(modelGroup);
        }
        if (modelGroup.isCompositorChoice()) {
            return new ChoiceAutomat(modelGroup);
        }
        return new SequenceAutomat(modelGroup);
    }

    private GroupAutomat determineGroupAutomat(ModelGroupDefinition modelGroupDef) {
        ModelGroup modelGroup = modelGroupDef.getModelGroup();
        return this.determineGroupAutomat(modelGroup);
    }

    protected Switch switchState(String uri, String name) {
        if (this.isDrained()) {
            return null;
        }
        return this.automat instanceof BaseAutomat ? this.switchState_BaseAutomat(uri, name) : this.switchState_GroupAutomat(uri, name);
    }

    private Switch switchState_BaseAutomat(String uri, String name) {
        Switch switchResult = this.automat.switchState(uri, name);
        if (switchResult != null) {
            this.isUntouched = false;
            ++this.occurrenceCounter;
        }
        return switchResult;
    }

    private Switch switchState_GroupAutomat(String uri, String name) {
        Switch switchResult = this.automat.switchState(uri, name);
        boolean automatIsSatisfied = this.automat.isSatisfied();
        if (!this.isOccurrenceDrained() && automatIsSatisfied && (switchResult == null || switchResult.base instanceof Wildcard)) {
            AutomatState presentAutomatState = this.getState();
            this.automat.reset();
            Switch newSwitchResult = this.automat.switchState(uri, name);
            if (switchResult == null && newSwitchResult == null || switchResult != null && switchResult.base instanceof Wildcard && (newSwitchResult == null || newSwitchResult.base instanceof Wildcard)) {
                this.setState(presentAutomatState);
            } else {
                automatIsSatisfied = this.automat.isSatisfied();
                switchResult = newSwitchResult;
            }
        }
        if (switchResult != null) {
            this.isUntouched = false;
            if (this.incremetOccurrenceCounter && automatIsSatisfied) {
                ++this.occurrenceCounter;
                this.incremetOccurrenceCounter = false;
            }
        }
        return switchResult;
    }

    protected boolean isSatisfied() {
        boolean automatIsUntouched = this.automat.isUntouched();
        boolean automatIsSatisfied = this.automat.isSatisfied();
        return automatIsUntouched && automatIsSatisfied || this.minOccurs == 0 && this.isUntouched || this.occurrenceCounter >= this.minOccurs && automatIsSatisfied;
    }

    protected boolean isDrained() {
        return this.isOccurrenceDrained() && this.automat.isDrained();
    }

    private boolean isOccurrenceDrained() {
        return this.occurrenceCounter >= this.maxOccurs && !this.isUnbounded;
    }

    protected void reset() {
        super.reset();
        this.automat.reset();
        this.incremetOccurrenceCounter = true;
        this.occurrenceCounter = 0;
    }

    protected AutomatState createState() {
        return new ParticleAutomatState();
    }

    protected void initState(AutomatState state) {
        super.initState(state);
        ParticleAutomatState particleAutomatState = (ParticleAutomatState)state;
        particleAutomatState.occurrenceCounter = this.occurrenceCounter;
        particleAutomatState.incremetOccurrenceCounter = this.incremetOccurrenceCounter;
        particleAutomatState.automatState = this.automat.getState();
    }

    protected void setState(AutomatState state) {
        super.setState(state);
        ParticleAutomatState particleAutomatState = (ParticleAutomatState)state;
        this.occurrenceCounter = particleAutomatState.occurrenceCounter;
        this.incremetOccurrenceCounter = particleAutomatState.incremetOccurrenceCounter;
        this.automat.setState(particleAutomatState.automatState);
    }

    protected void initToStringBuffer(StringBuffer toStringBuffer, String offset) {
        toStringBuffer.append(offset);
        toStringBuffer.append("Particle ");
        this.initToStringBuffer_Occurs(toStringBuffer, "minOccurs=", this.minOccurs);
        toStringBuffer.append(" ");
        this.initToStringBuffer_Occurs(toStringBuffer, "maxOccurs=", this.maxOccurs);
        toStringBuffer.append(" ");
        this.initToStringBuffer_IsUnbounded(toStringBuffer);
        toStringBuffer.append("\n");
        this.initToStringBuffer_Automat(toStringBuffer, offset + "    ");
    }

    protected void initToStringBuffer_Occurs(StringBuffer toStringBuffer, String occursId, int occursValue) {
        toStringBuffer.append(occursId);
        toStringBuffer.append(occursValue);
    }

    protected void initToStringBuffer_IsUnbounded(StringBuffer toStringBuffer) {
        toStringBuffer.append("isUnbounded=");
        toStringBuffer.append(this.isUnbounded);
    }

    protected void initToStringBuffer_Automat(StringBuffer toStringBuffer, String offset) {
        this.automat.initToStringBuffer(toStringBuffer, offset);
    }

    protected void initExpectedBuffer(StringBuffer expectedBuffer) {
        if (!this.isDrained()) {
            if (this.automat instanceof BaseAutomat) {
                this.automat.initExpectedBuffer(expectedBuffer);
            } else {
                this.initExpectedBuffer_GroupAutomat(expectedBuffer);
            }
        }
    }

    private void initExpectedBuffer_GroupAutomat(StringBuffer expectedBuffer) {
        if (this.automat.isDrained()) {
            this.initExpectedBuffer_GroupAutomat_Reset(expectedBuffer);
        } else {
            this.automat.initExpectedBuffer(expectedBuffer);
            if (!this.automat.isUntouched() && this.automat.isSatisfied()) {
                this.initExpectedBuffer_GroupAutomat_Reset(expectedBuffer);
            }
        }
    }

    private void initExpectedBuffer_GroupAutomat_Reset(StringBuffer expectedBuffer) {
        AutomatState automatState = this.automat.getState();
        this.automat.reset();
        this.automat.initExpectedBuffer(expectedBuffer);
        this.automat.setState(automatState);
    }
}

