/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.automat;

import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.validator.automat.BaseAutomat;
import com.sap.engine.lib.schema.validator.automat.ElementDeclarationWrapper;
import com.sap.engine.lib.schema.validator.automat.Switch;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class ElementAutomat
extends BaseAutomat {
    private Hashtable uriToElemDeclrWrappersMap = new Hashtable();

    protected ElementAutomat(ElementDeclaration elementDeclaration) {
        this.mapElementDeclaration(elementDeclaration, false);
    }

    private void mapElementDeclaration(ElementDeclaration elementDeclaration, boolean isSubstitution) {
        String uri = elementDeclaration.getTargetNamespace();
        String name = elementDeclaration.getName();
        Hashtable<String, ElementDeclarationWrapper> nameToElemDclrWrappersMap = (Hashtable<String, ElementDeclarationWrapper>)this.uriToElemDeclrWrappersMap.get(uri);
        if (nameToElemDclrWrappersMap == null) {
            nameToElemDclrWrappersMap = new Hashtable<String, ElementDeclarationWrapper>();
            this.uriToElemDeclrWrappersMap.put(uri, nameToElemDclrWrappersMap);
        }
        ElementDeclarationWrapper elemDeclrWrapper = new ElementDeclarationWrapper();
        elemDeclrWrapper.elementDeclaration = elementDeclaration;
        elemDeclrWrapper.isSubstitution = isSubstitution;
        nameToElemDclrWrappersMap.put(name, elemDeclrWrapper);
        Vector substitutions = new Vector();
        elementDeclaration.getSubstitutableElementDeclarations(substitutions);
        int i = 0;
        while (i < substitutions.size()) {
            ElementDeclaration substitution = (ElementDeclaration)substitutions.get(i);
            this.mapElementDeclaration(substitution, true);
            ++i;
        }
    }

    protected Switch switchState(String uri, String name) {
        ElementDeclarationWrapper elemDeclrWrapper;
        Hashtable nameToElemDclrWrappersMap = (Hashtable)this.uriToElemDeclrWrappersMap.get(uri);
        if (nameToElemDclrWrappersMap != null && (elemDeclrWrapper = (ElementDeclarationWrapper)nameToElemDclrWrappersMap.get(name)) != null) {
            this.isUntouched = false;
            this.switchResult.base = elemDeclrWrapper.elementDeclaration;
            this.switchResult.isSubstitution = elemDeclrWrapper.isSubstitution;
            this.switchResult.scopeModelGroupAll = null;
            return this.switchResult;
        }
        return null;
    }

    protected void initToStringBuffer(StringBuffer toStringBuffer, String offset) {
        toStringBuffer.append(offset);
        toStringBuffer.append("Element");
        this.initToStringBuffer_UriToElemDeclrWrappersMap(toStringBuffer, offset);
    }

    private void initToStringBuffer_UriToElemDeclrWrappersMap(StringBuffer toStringBuffer, String offset) {
        toStringBuffer.append("[");
        Enumeration nameToElemDclrWrappersMapsEnum = this.uriToElemDeclrWrappersMap.elements();
        while (nameToElemDclrWrappersMapsEnum.hasMoreElements()) {
            Hashtable nameToElemDclrWrappersMap = (Hashtable)nameToElemDclrWrappersMapsEnum.nextElement();
            this.initToStringBuffer_NameToElemDclrWrappersMap(toStringBuffer, offset, nameToElemDclrWrappersMap);
        }
        toStringBuffer.append("]");
    }

    private void initToStringBuffer_NameToElemDclrWrappersMap(StringBuffer toStringBuffer, String offset, Hashtable nameToElemDclrWrappersMap) {
        Enumeration elemDeclrWrappersEnum = nameToElemDclrWrappersMap.elements();
        while (elemDeclrWrappersEnum.hasMoreElements()) {
            ElementDeclarationWrapper elemDeclrWrapper = (ElementDeclarationWrapper)elemDeclrWrappersEnum.nextElement();
            elemDeclrWrapper.initToStringBuffer(toStringBuffer);
            if (!elemDeclrWrappersEnum.hasMoreElements()) continue;
            toStringBuffer.append("; ");
        }
    }

    protected void initExpectedBuffer(StringBuffer expectedBuffer) {
        Enumeration nameToElemDeclrWrappersMapsEnum = this.uriToElemDeclrWrappersMap.elements();
        while (nameToElemDeclrWrappersMapsEnum.hasMoreElements()) {
            Hashtable nameToElemDeclrWrappersMap = (Hashtable)nameToElemDeclrWrappersMapsEnum.nextElement();
            Enumeration elemWrappersEnum = nameToElemDeclrWrappersMap.elements();
            while (elemWrappersEnum.hasMoreElements()) {
                ElementDeclarationWrapper elemDeclrWrapper = (ElementDeclarationWrapper)elemWrappersEnum.nextElement();
                elemDeclrWrapper.initQNameBuffer(expectedBuffer);
                if (!elemWrappersEnum.hasMoreElements()) continue;
                expectedBuffer.append("; ");
            }
        }
    }
}

