/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.automat;

import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.schema.validator.automat.AutomatState;
import com.sap.engine.lib.schema.validator.automat.GroupAutomat;
import com.sap.engine.lib.schema.validator.automat.ParticleAutomat;
import com.sap.engine.lib.schema.validator.automat.Switch;

public final class ChoiceAutomat
extends GroupAutomat {
    protected ChoiceAutomat(ModelGroup modelGroup) {
        super(modelGroup);
    }

    public Switch switchState(String uri, String name) {
        Switch switchResult = null;
        if (this.isUntouched) {
            AutomatState switchToWildcardState = null;
            Switch wildcradSwitchResult = null;
            int i = 0;
            while (i < this.particleAutomats.size()) {
                ParticleAutomat particleAutomat = (ParticleAutomat)this.particleAutomats.get(i);
                switchResult = particleAutomat.switchState(uri, name);
                if (switchResult != null) {
                    this.switchingAutomatIndex = i;
                    if (switchResult.base instanceof Wildcard) {
                        if (switchToWildcardState == null) {
                            switchToWildcardState = this.getState();
                            wildcradSwitchResult = switchResult;
                            particleAutomat.reset();
                        }
                    } else {
                        switchToWildcardState = null;
                        break;
                    }
                }
                ++i;
            }
            if (switchToWildcardState != null) {
                this.setState(switchToWildcardState);
                switchResult = wildcradSwitchResult;
            }
        } else {
            ParticleAutomat switchingAutomat = this.determineSwitchingAutomat();
            switchResult = switchingAutomat.switchState(uri, name);
        }
        if (switchResult != null) {
            this.isUntouched = false;
        }
        return switchResult;
    }

    protected boolean isSatisfied() {
        if (this.particleAutomats.size() == 0) {
            return true;
        }
        if (this.isUntouched) {
            int i = 0;
            while (i < this.particleAutomats.size()) {
                ParticleAutomat particleAutomat = (ParticleAutomat)this.particleAutomats.get(i);
                if (particleAutomat.isSatisfied()) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        ParticleAutomat switchingAutomat = this.determineSwitchingAutomat();
        return switchingAutomat.isSatisfied();
    }

    protected boolean isDrained() {
        if (this.particleAutomats.size() == 0) {
            return true;
        }
        if (this.isUntouched) {
            return false;
        }
        ParticleAutomat switchingautomat = this.determineSwitchingAutomat();
        return switchingautomat.isDrained();
    }

    protected void initToStringBuffer_GroupCompositor(StringBuffer toStringBuffer) {
        toStringBuffer.append("Choice");
    }

    protected void initExpectedBuffer(StringBuffer expectedBuffer) {
        if (this.isUntouched) {
            int i = 0;
            while (i < this.particleAutomats.size()) {
                ParticleAutomat particleAutomat = (ParticleAutomat)this.particleAutomats.get(i);
                particleAutomat.initExpectedBuffer(expectedBuffer);
                if (i != this.particleAutomats.size() - 1) {
                    expectedBuffer.append("; ");
                }
                ++i;
            }
        } else {
            ParticleAutomat switchingAutomat = this.determineSwitchingAutomat();
            switchingAutomat.initExpectedBuffer(expectedBuffer);
        }
    }
}

