/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.exception.SchemaException;
import com.sap.engine.lib.schema.validator.automat.ContentAutomat;
import com.sap.engine.lib.schema.validator.identity.IdentityConstraintDefinitionsValidator;
import com.sap.engine.lib.schema.validator.tokenizer.XMLToken;
import com.sap.engine.lib.schema.validator.tokenizer.XMLTokenizer;
import com.sap.engine.lib.schema.validator.xpath.XPathObject;
import com.sap.engine.lib.schema.validator.xpath.XPathStepObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ValidationContext
implements Constants {
    private IdentityConstraintDefinitionsValidator identConstrDefsValidator;
    private XPathObject xPathObj;
    private Vector idValuesCollector;
    private Hashtable idrefValuesCollector;
    private Hashtable idrefsListsCollector;
    private XPathStepObject removedStep;
    private Vector errorsCollector;
    private Schema schema;
    private XMLTokenizer tokenizer;
    private Hashtable contentAutomatsCollector;

    protected ValidationContext(Schema schema, XMLTokenizer tokenizer) {
        this.schema = schema;
        this.errorsCollector = new Vector();
        this.identConstrDefsValidator = new IdentityConstraintDefinitionsValidator();
        this.xPathObj = new XPathObject();
        this.idValuesCollector = new Vector();
        this.idrefValuesCollector = new Hashtable();
        this.idrefsListsCollector = new Hashtable();
        this.removedStep = null;
        this.tokenizer = tokenizer;
        this.contentAutomatsCollector = new Hashtable();
    }

    protected Schema getSchema() {
        return this.schema;
    }

    public void addError_Element(String errorMessage) {
        this.errorsCollector.add("cvc-element : " + errorMessage);
    }

    public void addError_Attribute(String errorMessage) {
        this.errorsCollector.add("cvc-attribute : " + errorMessage);
    }

    public void addError_Particle(String errorMessage) {
        this.errorsCollector.add("cvc-particle : " + errorMessage);
    }

    public void addError_ComplexType(String errorMessage) {
        this.errorsCollector.add("cvc-complex-type : " + errorMessage);
    }

    public void addError_SimpleType(String errorMessage) {
        this.errorsCollector.add("cvc-simple-type : " + errorMessage);
    }

    public void addError_ModelGroup(String errorMessage) {
        this.errorsCollector.add("cvc-model-group : " + errorMessage);
    }

    public void addError_ModelGroupDefinition(String errorMessage) {
        this.errorsCollector.add("cvc-model-group-definition : " + errorMessage);
    }

    public void addError_ModelGroup_All(String errorMessage) {
        this.errorsCollector.add("cvc-model-group-all : " + errorMessage);
    }

    public void addError_ModelGroup_Choice(String errorMessage) {
        this.errorsCollector.add("cvc-model-group-choice : " + errorMessage);
    }

    public void addError_ModelGroup_Sequence(String errorMessage) {
        this.errorsCollector.add("cvc-model-group-sequence : " + errorMessage);
    }

    public void addError_Wildcard(String errorMessage) {
        this.errorsCollector.add("cvc-wildcard : " + errorMessage);
    }

    public void addError_Wildcard_Attribute(String errorMessage) {
        this.errorsCollector.add("cvc-attribute-wildcard : " + errorMessage);
    }

    public void addError_Wildcard_Allowance(String errorMessage) {
        this.errorsCollector.add("cvc-attribute-allowance : " + errorMessage);
    }

    public void addError_Identity(String errorMessage) {
        this.errorsCollector.add("cvc-identity-constraint : " + errorMessage);
    }

    public void addError_Data(String errorMessage) {
        this.errorsCollector.add("cvc-data : " + errorMessage);
    }

    public String getErrorsRepresentation() {
        String errorsRepresentation = "\nERRORS : \n";
        if (this.errorsCollector.size() == 0) {
            errorsRepresentation = errorsRepresentation + "none";
        } else {
            int i = 0;
            while (i < this.errorsCollector.size()) {
                errorsRepresentation = errorsRepresentation + this.errorsCollector.get(i) + "\n";
                ++i;
            }
        }
        return errorsRepresentation;
    }

    public Vector getErrorsCollector() {
        return this.errorsCollector;
    }

    public void activateIdentityConstraintValidators(IdentityConstraintDefinition[] identConstrDefs) {
        this.identConstrDefsValidator.activateValidators(identConstrDefs, this, this.xPathObj);
    }

    public void inactivateIdentityConstraintValidators() {
        this.identConstrDefsValidator.inactivateValidators();
    }

    public boolean registerValueForIdentityValidation(TypeDefinitionBase typeDefBase, String value, boolean isNillableElemDeclr) throws SchemaException {
        this.identConstrDefsValidator.addStructure(typeDefBase, value, this.xPathObj, isNillableElemDeclr);
        if (typeDefBase != null) {
            if (typeDefBase.isDerivedFrom(this.schema.getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "ID"), false, false)) {
                if (this.idValuesCollector.contains(value)) {
                    this.errorsCollector.add("cvc-identity : attribute information item '" + this.xPathObj.getXPath() + "' is not valid, according to it's {http://www.w3.org/2001/XMLSchema}:ID type definition and the identity validation.");
                    return false;
                }
                this.idValuesCollector.add(value);
            } else if (typeDefBase.isDerivedFrom(this.schema.getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "IDREF"), false, false)) {
                this.idrefValuesCollector.put(this.xPathObj.getXPath(), value);
            } else if (typeDefBase.isDerivedFrom(this.schema.getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "IDREFS"), false, false)) {
                this.idrefsListsCollector.put(this.xPathObj.getXPath(), value);
            }
        }
        return true;
    }

    public boolean validateRegisteredValuesForIdentityValidation_IdentityConstraintDefinitions() {
        return this.identConstrDefsValidator.validate();
    }

    public boolean validateRegisteredValuesForIdentityValidation_ID_IDREF_IDREFS() {
        String xPath;
        Enumeration xPathsEnum = this.idrefValuesCollector.keys();
        while (xPathsEnum.hasMoreElements()) {
            xPath = (String)xPathsEnum.nextElement();
            String value = (String)this.idrefValuesCollector.get(xPath);
            if (this.idValuesCollector.contains(value)) continue;
            this.errorsCollector.add("cvc-identity : attribute '" + xPath + "' is associated with type, derived from type {http://www.w3.org/2001/XMLSchema}:IDREF, but it's value is not identical to any of the values, associated with the items, which type is derived from type {http://www.w3.org/2001/XMLSchema}:ID.");
            return false;
        }
        xPathsEnum = this.idrefsListsCollector.keys();
        while (xPathsEnum.hasMoreElements()) {
            xPath = (String)xPathsEnum.nextElement();
            String values = (String)this.idrefsListsCollector.get(xPath);
            StringTokenizer valuesTokenizer = new StringTokenizer(values);
            while (valuesTokenizer.hasMoreTokens()) {
                String value = valuesTokenizer.nextToken();
                if (this.idValuesCollector.contains(value)) continue;
                this.errorsCollector.add("cvc-identity : attribute '" + xPath + "' is associated with type, derived from type {http://www.w3.org/2001/XMLSchema}:IDREFS, but it's value is not identical to any of the values, associated with the items, which type is derived from type {http://www.w3.org/2001/XMLSchema}:ID.");
                return false;
            }
        }
        return true;
    }

    public String getXPath() {
        return this.xPathObj.getXPath();
    }

    public void updateXPath_Start(String qName, String localName, String uri) {
        int position = this.removedStep == null || !this.removedStep.getLocalName().equals(localName) ? 1 : this.removedStep.getPosition() + 1;
        this.xPathObj.addXPathStep(qName, position, uri);
        this.removedStep = null;
    }

    public void updateXPath_End() {
        this.removedStep = this.xPathObj.removeXPathStep();
    }

    public void updateXPath_Error(String qName, String uri) {
        this.removedStep = this.xPathObj.removeXPathStep();
        if (this.removedStep != null) {
            int position = this.removedStep.getPosition();
            this.removedStep = position == 1 ? null : new XPathStepObject(qName, position - 1, uri);
        }
    }

    public void addStep(String step, String uri) {
        this.xPathObj.addXPathStep(step, uri);
    }

    public void removeStep() {
        this.xPathObj.removeXPathStep();
    }

    public XMLToken nextXMLToken() throws SchemaException {
        return this.tokenizer.next();
    }

    public XMLToken peekXMLToken() throws SchemaException {
        return this.tokenizer.peek();
    }

    public ContentAutomat useContentAutomat(ComplexTypeDefinition complTypeDef) {
        ContentAutomat result = (ContentAutomat)this.contentAutomatsCollector.get(complTypeDef);
        if (result == null) {
            result = new ContentAutomat(complTypeDef);
        } else {
            this.contentAutomatsCollector.remove(complTypeDef);
        }
        return result;
    }

    public void reuseContentAutomat(ContentAutomat contentAutomat, ComplexTypeDefinition complTypeDef) {
        if (!complTypeDef.isAnonymous()) {
            contentAutomat.reset();
            this.contentAutomatsCollector.put(complTypeDef, contentAutomat);
        }
    }
}

