/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.components.Facet;
import com.sap.engine.lib.schema.components.FundamentalFacets;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.impl.ffacets.Value;
import com.sap.engine.lib.schema.components.impl.ffacets.ValueComparator;
import com.sap.engine.lib.schema.exception.RegularExpressionException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.schema.validator.ValidationContext;
import com.sap.engine.lib.schema.validator.regexp.RegularExpression;
import com.sap.engine.lib.xml.dom.NodeImpl;
import java.util.StringTokenizer;
import java.util.Vector;

public class SimpleTypeValidator
implements Constants {
    public static boolean validateSimpleTypeDefinition(SimpleTypeDefinition simpleTypeDef, ValidationContext context, Value ffacetsValue, String initialValue, boolean normalize, NodeImpl node) {
        String value;
        String whiteSpaceNormalizationValue = simpleTypeDef.getWhiteSpaceNormalizationValue();
        String string = value = normalize && whiteSpaceNormalizationValue != null ? Tools.normalizeValue(initialValue, whiteSpaceNormalizationValue) : initialValue;
        if (simpleTypeDef.isVarietyList()) {
            SimpleTypeDefinition listMememberTypeDef = simpleTypeDef.getItemTypeDefinition();
            StringTokenizer listMemebersTokenizer = new StringTokenizer(value, " ");
            while (listMemebersTokenizer.hasMoreElements()) {
                String listMemeberValue = listMemebersTokenizer.nextToken();
                if (SimpleTypeValidator.validateSimpleTypeDefinition(listMememberTypeDef, context, null, listMemeberValue, true, node)) continue;
                if (context != null) {
                    context.addError_SimpleType("information item '" + context.getXPath() + "' is not valid, because it is declared to be with simple type definition with variety list, but it's value is not valid with respect to this list members simple type definition.");
                }
                return false;
            }
        } else if (simpleTypeDef.isVarietyUnion()) {
            Vector unionMemebersTypeDefCollector = new Vector();
            simpleTypeDef.getMemberTypeDefinitions(unionMemebersTypeDefCollector);
            int i = 0;
            while (i < unionMemebersTypeDefCollector.size()) {
                SimpleTypeDefinition unionMemeberTypeDef = (SimpleTypeDefinition)unionMemebersTypeDefCollector.get(i);
                if (SimpleTypeValidator.validateSimpleTypeDefinition(unionMemeberTypeDef, context, null, value, true, node)) {
                    if (node != null) {
                        node.setAugmentation("[member type definition]", unionMemeberTypeDef);
                    }
                    return true;
                }
                ++i;
            }
            if (context != null) {
                context.addError_SimpleType("information item '" + context.getXPath() + "' is not valid, because it is declared to be with simple type definition with variety union, but it's value is not valid with respect to any of the union members simple type definition.");
            }
            return false;
        }
        FundamentalFacets fundamentalFacets = simpleTypeDef.getFundamentalFacets();
        if (fundamentalFacets != null) {
            if (ffacetsValue == null) {
                ffacetsValue = fundamentalFacets.parse(value);
            }
            if (ffacetsValue == null) {
                if (context != null) {
                    context.addError_SimpleType("information item '" + context.getXPath() + "' is not valid, because it's value does not belong to lexical space of element's simple type definition.");
                }
                return false;
            }
        }
        Facet[] facets = simpleTypeDef.getFacetsArray();
        boolean patternPresent = false;
        boolean patternValidation = false;
        boolean enumerationPresent = false;
        boolean enumerationValidation = false;
        int i = 0;
        while (i < facets.length) {
            Facet facet = facets[i];
            String facetValue = facet.getValue();
            String facetName = facet.getName();
            if (facetName.equals("pattern") && !patternValidation) {
                if (!patternPresent) {
                    patternPresent = true;
                }
                if (SimpleTypeValidator.validateFacetPattern(facetValue, value)) {
                    patternValidation = true;
                }
            } else if (facetName.equals("enumeration") && !enumerationValidation) {
                if (!enumerationPresent) {
                    enumerationPresent = true;
                }
                if (SimpleTypeValidator.validateFacetEnumeration(fundamentalFacets, ffacetsValue, facetValue)) {
                    enumerationValidation = true;
                }
            } else if (facetName.equals("length")) {
                if (!SimpleTypeValidator.validateFacetLength(ffacetsValue, value, facetValue)) {
                    if (context != null) {
                        context.addError_SimpleType("information item '" + context.getXPath() + "' is not valid, because it's value does not satisfy the constraints of facet 'length' with value '" + facetValue + "'.");
                    }
                    return false;
                }
            } else if (facetName.equals("minLength")) {
                if (!SimpleTypeValidator.validateFacetMinLength(ffacetsValue, value, facetValue)) {
                    if (context != null) {
                        context.addError_SimpleType("information item '" + context.getXPath() + "' is not valid, because it's value does not satisfy the constraints of facet 'minLength' with value '" + facetValue + "'.");
                    }
                    return false;
                }
            } else if (facetName.equals("maxLength")) {
                if (!SimpleTypeValidator.validateFacetMaxLength(ffacetsValue, value, facetValue)) {
                    if (context != null) {
                        context.addError_SimpleType("information item '" + context.getXPath() + "' is not valid, because it's value does not satisfy the constraints of facet 'maxLength' with value '" + facetValue + "'.");
                    }
                    return false;
                }
            } else if (facetName.equals("minExclusive")) {
                if (!SimpleTypeValidator.validateFacetMinExclusive(fundamentalFacets, ffacetsValue, facetValue)) {
                    if (context != null) {
                        context.addError_SimpleType("information item '" + context.getXPath() + "' is not valid, because it's value does not satisfy the constraints of facet 'minExclusive' with value '" + facetValue + "'.");
                    }
                    return false;
                }
            } else if (facetName.equals("maxExclusive")) {
                if (!SimpleTypeValidator.validateFacetMaxExclusive(fundamentalFacets, ffacetsValue, facetValue)) {
                    if (context != null) {
                        context.addError_SimpleType("information item '" + context.getXPath() + "' is not valid, because it's value does not satisfy the constraints of facet 'maxExclusive' with value '" + facetValue + "'.");
                    }
                    return false;
                }
            } else if (facetName.equals("minInclusive")) {
                if (!SimpleTypeValidator.validateFacetMinInclusive(fundamentalFacets, ffacetsValue, facetValue)) {
                    if (context != null) {
                        context.addError_SimpleType("information item '" + context.getXPath() + "' is not valid, because it's value does not satisfy the constraints of facet 'minInclusive' with value '" + facetValue + "'.");
                    }
                    return false;
                }
            } else if (facetName.equals("maxInclusive")) {
                if (!SimpleTypeValidator.validateFacetMaxInclusive(fundamentalFacets, ffacetsValue, facetValue)) {
                    if (context != null) {
                        context.addError_SimpleType("information item '" + context.getXPath() + "' is not valid, because it's value does not satisfy the constraints of facet 'maxInclusive' with value '" + facetValue + "'.");
                    }
                    return false;
                }
            } else if (facetName.equals("totalDigits")) {
                if (!SimpleTypeValidator.validateFacetTotalDigits(facetValue, value)) {
                    if (context != null) {
                        context.addError_SimpleType("information item '" + context.getXPath() + "' is not valid, because it's value does not satisfy the constraints of facet 'totalDigits' with value '" + facetValue + "'.");
                    }
                    return false;
                }
            } else if (facetName.equals("fractionDigits")) {
                if (!SimpleTypeValidator.validateFacetFractionDigits()) {
                    if (context != null) {
                        context.addError_SimpleType("information item '" + context.getXPath() + "' is not valid, because it's value does not satisfy the constraints of facet 'fractionDigits' with value '" + facetValue + "'.");
                    }
                    return false;
                }
            } else if (facetName.equals("whitespace") && !SimpleTypeValidator.validateFacetWhitespace()) {
                if (context != null) {
                    context.addError_SimpleType("information item '" + context.getXPath() + "' is not valid, because it's value does not satisfy the constraints of facet 'whitespace' with value '" + facetValue + "'.");
                }
                return false;
            }
            ++i;
        }
        if (enumerationPresent && !enumerationValidation) {
            if (context != null) {
                context.addError_SimpleType("information item '" + context.getXPath() + "' is not valid, because it's value does not match to any of the enumeration facets defined in it's simple type definition.");
            }
            return false;
        }
        if (patternPresent && !patternValidation) {
            if (context != null) {
                context.addError_SimpleType("information item '" + context.getXPath() + "' is not valid, because it's value does not match to any of the pattern facets defined in it's simple type definition.");
            }
            return false;
        }
        return true;
    }

    public static boolean validateFacetPattern(String regularExpression, String value) throws RegularExpressionException {
        RegularExpression regExpression = new RegularExpression(regularExpression, "X");
        return regExpression.matches(value);
    }

    public static boolean validateFacetEnumeration(FundamentalFacets fundamentalFacets, Value value, String enumerationValue) {
        return ValueComparator.compare(value, fundamentalFacets.parse(enumerationValue)) == 1;
    }

    public static int getLengthDependingOnType(Value ffacetsValue, String value) {
        if (ffacetsValue != null) {
            return ffacetsValue.getLength();
        }
        StringTokenizer tokenizer = new StringTokenizer(value, " ");
        return tokenizer.countTokens();
    }

    public static boolean validateFacetLength(Value ffactesValue, String value, String facetValue) {
        return SimpleTypeValidator.getLengthDependingOnType(ffactesValue, value) == Integer.parseInt(facetValue);
    }

    public static boolean validateFacetMinLength(Value ffactesValue, String value, String facetValue) {
        return SimpleTypeValidator.getLengthDependingOnType(ffactesValue, value) >= Integer.parseInt(facetValue);
    }

    public static boolean validateFacetMaxLength(Value ffactesValue, String value, String facetValue) {
        return SimpleTypeValidator.getLengthDependingOnType(ffactesValue, value) <= Integer.parseInt(facetValue);
    }

    public static boolean validateFacetMinExclusive(FundamentalFacets fundamentalFacets, Value value, String facetValue) {
        return ValueComparator.compare(value, fundamentalFacets.parse(facetValue)) == 3;
    }

    public static boolean validateFacetMaxExclusive(FundamentalFacets fundamentalFacets, Value value, String facetValue) {
        return ValueComparator.compare(value, fundamentalFacets.parse(facetValue)) == 2;
    }

    public static boolean validateFacetMinInclusive(FundamentalFacets fundamentalFacets, Value value, String facetValue) {
        return ValueComparator.compare(value, fundamentalFacets.parse(facetValue)) != 2;
    }

    public static boolean validateFacetMaxInclusive(FundamentalFacets fundamentalFacets, Value value, String facetValue) {
        return ValueComparator.compare(value, fundamentalFacets.parse(facetValue)) != 3;
    }

    public static boolean validateFacetTotalDigits(String facetValue, String value) {
        int facetIntValue = Integer.parseInt(facetValue);
        int charCounter = 0;
        int valueLength = value.length();
        int i = 0;
        while (i < valueLength) {
            char ch = value.charAt(i);
            if (ch >= '0' && ch <= '9') {
                ++charCounter;
            }
            ++i;
        }
        return charCounter <= facetIntValue;
    }

    public static boolean validateFacetFractionDigits() {
        return true;
    }

    public static boolean validateFacetWhitespace() {
        return true;
    }
}

