/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.util;

import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.impl.LoaderImpl;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.exception.SchemaException;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.parser.URLLoaderBase;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class Tools
implements Constants {
    private static final String PREFIX_DELIMITER = ":";

    private Tools() {
    }

    public static String formatQNameWithUri(String uri, String local) {
        return "{" + uri + "}" + PREFIX_DELIMITER + local;
    }

    public static String formatQNameWithPrefix(String prefix, String local) {
        return prefix == null || prefix.equals("") ? local : prefix + PREFIX_DELIMITER + local;
    }

    public static String formatQNameWithUri(String uri, CharArray local) {
        return Tools.formatQNameWithUri(uri, local.toString());
    }

    public static boolean compareBases(Base srcBase, Base dstBase) {
        if (srcBase == dstBase || srcBase.equals(dstBase)) {
            return true;
        }
        if (srcBase == null ^ dstBase == null) {
            return false;
        }
        if (srcBase != null) {
            return srcBase.match(dstBase);
        }
        return true;
    }

    public static boolean compareStringProps(String srcString, String dstString) {
        if (srcString == null ^ dstString == null) {
            return false;
        }
        if (srcString != null) {
            return srcString.equals(dstString);
        }
        return true;
    }

    public static boolean compareUnorderdSetsOfBases(Vector srcBases, Vector dstBases) {
        if (srcBases == null ^ dstBases == null) {
            return false;
        }
        if (srcBases != null) {
            if (srcBases.size() != dstBases.size()) {
                return false;
            }
            boolean[] checked = new boolean[srcBases.size()];
            int i = 0;
            while (i < srcBases.size()) {
                Base srcBase = (Base)srcBases.get(i);
                boolean found = false;
                int j = 0;
                while (j < dstBases.size()) {
                    Base dstBase;
                    if (!checked[j] && (srcBase == (dstBase = (Base)dstBases.get(j)) || srcBase.equals(dstBase) || srcBase.match(dstBase))) {
                        checked[j] = true;
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean compareUnorderdSetsOfBases(Hashtable srcBases, Hashtable dstBases) {
        if (srcBases == null ^ dstBases == null) {
            return false;
        }
        if (srcBases != null) {
            if (srcBases.size() != dstBases.size()) {
                return false;
            }
            boolean[] checked = new boolean[srcBases.size()];
            Enumeration srcEnum = srcBases.elements();
            Enumeration dstEnum = dstBases.elements();
            int i = 0;
            while (i < srcBases.size()) {
                Base srcBase = (Base)srcEnum.nextElement();
                boolean found = false;
                int j = 0;
                while (j < dstBases.size()) {
                    Base dstBase;
                    if (!checked[j] && (srcBase == (dstBase = (Base)dstEnum.nextElement()) || srcBase.equals(dstBase) || srcBase.match(dstBase))) {
                        checked[j] = true;
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean compareUnorderdSetsOfBases(Base[] srcBases, Base[] dstBases) {
        if (srcBases == null ^ dstBases == null) {
            return false;
        }
        if (srcBases != null) {
            if (srcBases.length != dstBases.length) {
                return false;
            }
            boolean[] checked = new boolean[srcBases.length];
            int i = 0;
            while (i < srcBases.length) {
                Base srcBase = srcBases[i];
                boolean found = false;
                int j = 0;
                while (j < dstBases.length) {
                    Base dstBase;
                    if (!checked[j] && srcBase.match(dstBase = dstBases[j])) {
                        checked[j] = true;
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean compareOrderedSetsOfBases(Vector srcBases, Vector dstBases) {
        if (srcBases == null ^ dstBases == null) {
            return false;
        }
        if (srcBases != null) {
            if (srcBases.size() != dstBases.size()) {
                return false;
            }
            int i = 0;
            while (i < srcBases.size()) {
                Base dstBase;
                Base srcBase = (Base)srcBases.get(i);
                if (!srcBase.match(dstBase = (Base)dstBases.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean compareUnorderedSetsOfStrings(String[] srcArray, String[] dstArray) {
        if (srcArray == null ^ dstArray == null) {
            return false;
        }
        if (srcArray != null) {
            if (srcArray.length != dstArray.length) {
                return false;
            }
            boolean[] checked = new boolean[srcArray.length];
            int i = 0;
            while (i < srcArray.length) {
                String srcString = srcArray[i];
                boolean found = false;
                int j = 0;
                while (j < dstArray.length) {
                    String dstString;
                    if (!checked[j] && srcString.equals(dstString = dstArray[j])) {
                        checked[j] = true;
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean compareUnorderedSetsOfStrings(Vector srcStrings, Vector dstStrings) {
        if (srcStrings == null ^ dstStrings == null) {
            return false;
        }
        if (srcStrings != null) {
            if (srcStrings.size() != dstStrings.size()) {
                return false;
            }
            boolean[] checked = new boolean[srcStrings.size()];
            int i = 0;
            while (i < srcStrings.size()) {
                String srcString = (String)srcStrings.get(i);
                boolean found = false;
                int j = 0;
                while (j < dstStrings.size()) {
                    String dstString;
                    if (!checked[j] && srcString.equals(dstString = (String)dstStrings.get(i))) {
                        checked[j] = true;
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static String generateKey(String uri, String name) {
        if (uri == null) {
            uri = "";
        }
        return "{" + uri + "} : " + name;
    }

    public static void removeFromHashtableToVector(Hashtable hash, Vector collector) {
        if (hash != null) {
            Enumeration enumeration = hash.elements();
            while (enumeration.hasMoreElements()) {
                collector.add(enumeration.nextElement());
            }
        }
    }

    public static void removeFromVectorToVector(Vector srcCollector, Vector dstCollector) {
        if (dstCollector == null) {
            throw new IllegalArgumentException("Destination vector for collection must have a non 'null' value.");
        }
        if (srcCollector != null) {
            dstCollector.addAll(srcCollector);
        }
    }

    public static void initArrayFromHashtable(Hashtable hash, Object[] array) {
        Enumeration enumeration = hash.elements();
        int index = 0;
        while (enumeration.hasMoreElements()) {
            array[index++] = enumeration.nextElement();
        }
    }

    public static void cloneVectorWithBases(Vector srcCollector, Vector dstCollector, Hashtable typesCollector) {
        int i = 0;
        while (i < srcCollector.size()) {
            BaseImpl base = (BaseImpl)srcCollector.get(i);
            dstCollector.add(base.clone(typesCollector));
            ++i;
        }
    }

    public static void cloneHashtableWithBases(Hashtable srcCollector, Hashtable dstCollector, Hashtable typesCollector) {
        Enumeration keys = srcCollector.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            BaseImpl base = (BaseImpl)srcCollector.get(key);
            dstCollector.put(key, base.clone(typesCollector));
        }
    }

    public static String canonicalizeLocation(String base, String location) throws IOException {
        String result = null;
        if (location != null) {
            if (location.startsWith("http:")) {
                int index = "http:".length();
                while (location.charAt(index++) == '/' && index < location.length()) {
                }
                result = "http://" + location.substring(index - 1);
            } else if (location.startsWith("file:")) {
                int index = "file:".length();
                while (location.charAt(index++) == '/' && index < location.length()) {
                }
                result = "file://" + location.substring(index - 1);
            } else {
                result = location.startsWith(".") ? "file://" + (base == null ? new File(location).getCanonicalPath() : new File(base, location).getCanonicalPath()) : "file://" + location;
            }
            result = result.replace('\\', '/');
        }
        return result;
    }

    public static String[] parseQName(String qName) {
        int index = qName.indexOf(PREFIX_DELIMITER);
        if (index < 0) {
            return new String[]{null, qName};
        }
        return new String[]{qName.substring(0, index), qName.substring(index + 1)};
    }

    public static Vector createVector(Enumeration enumeration) {
        Vector result = new Vector();
        while (enumeration.hasMoreElements()) {
            result.add(enumeration.nextElement());
        }
        return result;
    }

    public static String getUri(Hashtable mappings, String prefix) {
        return (String)mappings.get(prefix == null ? "" : prefix);
    }

    public static String getDefaultUri(Hashtable mappings) {
        String uri = Tools.getUri(mappings, "");
        return uri == null ? "" : uri;
    }

    public static String[] parseQName(String qName, Hashtable prefixesMapping) {
        String[] prefixAndName = Tools.parseQName(qName);
        String uri = Tools.getUri(prefixesMapping, prefixAndName[0]);
        return new String[]{uri, prefixAndName[1]};
    }

    public static String normalizeValue(String initialValue, String whiteSpaceNormValue) {
        StringBuffer buffer = new StringBuffer();
        if (whiteSpaceNormValue.equals("replace")) {
            int i = 0;
            while (i < initialValue.length()) {
                char ch = initialValue.charAt(i);
                if (ch == '\t' || ch == '\r' || ch == '\n') {
                    buffer.append(' ');
                } else {
                    buffer.append(ch);
                }
                ++i;
            }
            return buffer.toString();
        }
        if (whiteSpaceNormValue.equals("preserve")) {
            return initialValue;
        }
        initialValue = initialValue.trim();
        int i = 0;
        while (i < initialValue.length()) {
            char ch = initialValue.charAt(i);
            if (ch == '\t' || ch == '\r' || ch == '\n') {
                if (buffer.charAt(buffer.length() - 1) != ' ') {
                    buffer.append(' ');
                }
            } else if (ch == ' ') {
                if (buffer.charAt(buffer.length() - 1) != ' ') {
                    buffer.append(' ');
                }
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static InputSource retrieveInputSource(EntityResolver resolver, String parentLocation, String location) throws SchemaComponentException {
        try {
            InputSource result = null;
            if (resolver != null) {
                result = resolver.resolveEntity(null, location);
                if (result == null) {
                    result = Tools.retriveInputSource(parentLocation, location);
                } else if (result.getByteStream() == null && result.getCharacterStream() == null && result.getSystemId() == null) {
                    throw new SchemaException("[location : " + parentLocation + "] ERROR : Entity resolved to an InputSource, with no InputStream, CharacterStream and SystemId.");
                }
            } else {
                result = Tools.retriveInputSource(parentLocation, location);
            }
            return result;
        }
        catch (Throwable tr) {
            if (tr instanceof SchemaComponentException) {
                throw (SchemaComponentException)tr;
            }
            throw new SchemaComponentException("[location : " + parentLocation + "] ERROR : " + tr.getMessage());
        }
    }

    private static InputSource retriveInputSource(String parentLocation, String location) throws IOException {
        InputSource result = new InputSource();
        URL baseURL = parentLocation == null ? null : URLLoaderBase.fileOrURLToURL(null, parentLocation);
        URL sourceURL = URLLoaderBase.fileOrURLToURL(baseURL, location);
        result.setByteStream(sourceURL.openStream());
        result.setSystemId(sourceURL.toExternalForm());
        return result;
    }

    public static Element retrieveNode(StandardDOMParser parser, InputSource source) throws SchemaComponentException {
        if (source == null) {
            return null;
        }
        try {
            Document doc = parser.parse(source);
            return doc.getDocumentElement();
        }
        catch (Exception exc) {
            throw new SchemaComponentException(exc.getMessage());
        }
    }

    public static Element retrieveNode(DocumentBuilder docBuilder, InputSource source) throws SchemaComponentException {
        if (source == null) {
            return null;
        }
        try {
            Document doc = docBuilder.parse(source);
            return doc.getDocumentElement();
        }
        catch (Exception exc) {
            throw new SchemaComponentException(exc.getMessage());
        }
    }

    public static Element retrieveDocElement(Node node) {
        Element result = null;
        if (node instanceof Element) {
            result = (Element)node;
        } else if (node instanceof Document) {
            Document doc = (Document)node;
            result = doc.getDocumentElement();
        }
        return result;
    }

    public static BaseImpl getTopLevelBase(SchemaImpl ownerSchema, LoaderImpl loader, Node node, String qName, int type, String location) throws SchemaComponentException {
        BaseImpl base;
        String[] prefixAndLocalName = Tools.parseQName(qName);
        String prefix = prefixAndLocalName[0];
        String localName = prefixAndLocalName[1];
        String uri = null;
        if (prefix != null) {
            String string = uri = prefix.equals("xml") ? "http://www.w3.org/XML/1998/namespace" : Tools.getUri(DOM.getNamespaceMappingsInScope(node), prefix);
            if (uri == null) {
                throw new SchemaComponentException("[location : " + location + "] ERROR : Definition of qualified base " + DOM.toXPath(node) + " is not correct. Missing prefix mapping to prefix '" + prefix + "' in the scope node " + DOM.toXPath(node) + ".");
            }
        } else {
            uri = Tools.getDefaultUri(DOM.getNamespaceMappingsInScope(node));
        }
        if ((base = (BaseImpl)((Object)ownerSchema.getTopLevelComponent(uri, localName, type))) == null) {
            loader.resolveQualifiedBase(uri, localName, type);
            base = (BaseImpl)((Object)ownerSchema.getTopLevelComponent(uri, localName, type));
        }
        if (base == null) {
            throw new SchemaComponentException("[location : " + location + "] ERROR : Definition of qualified base " + DOM.toXPath(node) + " is not correct. Missing top level qualified base definition (uri - " + uri + "; name - " + localName + ").");
        }
        return base;
    }

    public static InputSource createInputSource(StreamSource streamSource) {
        InputSource result = new InputSource();
        result.setByteStream(streamSource.getInputStream());
        result.setPublicId(streamSource.getPublicId());
        result.setCharacterStream(streamSource.getReader());
        result.setSystemId(streamSource.getSystemId());
        return result;
    }
}

